/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.c3;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.c3.ds;
import com.aspose.slides.internal.c3.lz;
import com.aspose.slides.internal.c3.xz;
import com.aspose.slides.internal.ge.v8;
import com.aspose.slides.ms.System.h8;
import com.aspose.slides.ms.System.ne;
import com.aspose.slides.ms.System.vr;
import java.io.File;

public class od
extends lz {
    private boolean v2 = false;
    private boolean hn;
    private boolean cl;
    private boolean v8;
    private v8 s0;
    private final String cc;

    public od(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private od(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.cc = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (vr.hn(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.cl = false;
            this.hn = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.cl = true;
            this.hn = false;
            string2 = "rw";
        } else {
            this.cl = true;
            this.hn = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(vr.v2("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{ne.getName(xz.class, n10), ne.getName(ds.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(vr.v2("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{ne.getName(xz.class, n10), ne.getName(ds.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.s0 = bl2 ? new v8(file, string2, n) : new v8(file, string2);
            if (n10 == 6) {
                this.s0.v2(this.s0.v8());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.s0 = new v8(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.s0 = new v8(file, string2);
                this.s0.v2(true);
            } else {
                this.s0 = new v8(file, string2);
            }
        }
        this.v8 = true;
    }

    public od(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public od(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public od(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.hn;
    }

    @Override
    public boolean canSeek() {
        return this.v8;
    }

    @Override
    public boolean canWrite() {
        return this.cl;
    }

    @Override
    public long getLength() {
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.s0.v8();
    }

    @Override
    public long getPosition() {
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.s0.cl();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.s0.v2(position);
    }

    @Override
    public void flush() {
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.s0.s0();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.s0.v2(offset);
                break;
            }
            case 1: {
                this.s0.v2(this.s0.cl() + offset);
                break;
            }
            case 2: {
                this.s0.v2(this.s0.v8() + offset);
            }
        }
        return this.s0.cl();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.s0 != null && !this.s0.hn()) {
                this.s0.v2();
            }
        }
        finally {
            this.hn = false;
            this.cl = false;
            this.v8 = false;
            super.dispose(disposing);
            this.v2 = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.cl) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.s0.cl(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.hn) {
            int n = this.s0.hn(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.hn) {
            return this.s0.cc();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.cl) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.s0.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.cl) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.s0.write(value);
    }

    public String v2() {
        return this.cc;
    }

    @Override
    public h8 beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.ds callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(h8 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public h8 beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.ds userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.v2) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(h8 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

