/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.di;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.u1;
import java.util.Arrays;

@u1
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] l0;
    private int ql;
    private int r2;
    private int ic;
    private int yx;
    private final Object ek;

    public Queue() {
        this.l0 = new Object[0];
        this.ek = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.l0 = new Object[capacity];
        this.ek = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.l0 = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.ek = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, this.l0.length);
        this.ic = 0;
        this.r2 = 0;
        this.ql = 0;
        ++this.yx;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ic array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.yx() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.yx() - arrayIndex < this.ic) {
            throw new ArgumentException();
        }
        if (this.ic == 0) {
            return;
        }
        try {
            int n = this.l0.length;
            int n10 = n - this.ql;
            com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), this.ql, array, arrayIndex, di.ql(this.ic, n10));
            if (this.ic > n10) {
                com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), 0, array, arrayIndex + n10, this.ic - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.l0[this.ql] = null;
        if (++this.ql == this.l0.length) {
            this.ql = 0;
        }
        --this.ic;
        ++this.yx;
        return t;
    }

    public T peek() {
        if (this.ic == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.l0[this.ql];
    }

    public void enqueue(T item) {
        if (this.ic == this.l0.length || this.r2 == this.l0.length) {
            this.l0(di.l0(di.l0(this.ic, this.r2) * 2, 4));
        }
        this.l0[this.r2] = item;
        if (++this.r2 == this.l0.length) {
            this.r2 = 0;
        }
        ++this.ic;
        ++this.yx;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.ic) {
            return Arrays.copyOf(this.l0, this.ic, a.getClass());
        }
        System.arraycopy(this.l0, 0, a, 0, this.ic);
        if (a.length > this.ic) {
            a[this.ic] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.ic < (double)this.l0.length * 0.9) {
            this.l0(this.ic);
        }
    }

    private void l0(int n) {
        if (n == this.l0.length) {
            return;
        }
        if (n < this.ic) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.ic > 0) {
            this.copyTo(com.aspose.slides.ms.System.ic.l0(objectArray), 0);
        }
        this.l0 = objectArray;
        this.r2 = this.ic;
        this.ql = 0;
        ++this.yx;
    }

    @Override
    public int size() {
        return this.ic;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.ek;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @u1
    public static class Enumerator<T>
    extends el<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> ql;
        private int r2;
        private int ic;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.ql = q;
            this.r2 = -2;
            this.ic = ((Queue)q).yx;
        }

        @Override
        public void dispose() {
            this.r2 = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.ic != ((Queue)this.ql).yx) {
                throw new InvalidOperationException();
            }
            if (this.r2 == -2) {
                this.r2 = ((Queue)this.ql).ic;
            }
            return this.r2 != -1 && --this.r2 != -1;
        }

        @Override
        public T next() {
            if (this.r2 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.ql).l0[(((Queue)this.ql).ic - 1 - this.r2 + ((Queue)this.ql).ql) % ((Queue)this.ql).l0.length];
        }

        @Override
        public void reset() {
            if (this.ic != ((Queue)this.ql).yx) {
                throw new InvalidOperationException();
            }
            this.r2 = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.ql = this.ql;
            that.r2 = this.r2;
            that.ic = this.ic;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean l0(Enumerator enumerator) {
            return qu.l0(enumerator.ql, this.ql) && enumerator.r2 == this.r2 && enumerator.ic == this.ic;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.l0((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ql != null ? this.ql.hashCode() : 0;
            n = 31 * n + this.r2;
            n = 31 * n + this.ic;
            return n;
        }
    }
}

