/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.u1;
import java.util.Arrays;

@u1
public class Queue
implements ICollection,
IEnumerable,
g0 {
    private Object[] l0;
    private int ql = 0;
    private int r2 = 0;
    private int ic = 0;
    private int yx;
    private int ek = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.l0 = new Object[capacity];
        this.yx = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.r2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ic array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ic() > 1 || index != 0 && index >= array.yx() || this.r2 > array.yx() - index) {
            throw new ArgumentException();
        }
        int n = this.l0.length;
        int n10 = n - this.ql;
        com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), this.ql, array, index, Math.min(this.r2, n10));
        if (this.r2 > n10) {
            com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), 0, array, index + n10, this.r2 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.l0.length);
        queue.yx = this.yx;
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, queue.l0, 0, this.l0.length);
        queue.ql = this.ql;
        queue.r2 = this.r2;
        queue.ic = this.ic;
        return queue;
    }

    public void clear() {
        ++this.ek;
        this.ql = 0;
        this.r2 = 0;
        this.ic = 0;
        for (int i = this.l0.length - 1; i >= 0; --i) {
            this.l0[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.ql + this.r2;
        if (obj == null) {
            for (int i = this.ql; i < n; ++i) {
                if (this.l0[i % this.l0.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.ql; i < n; ++i) {
                if (!obj.equals(this.l0[i % this.l0.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.ek;
        if (this.r2 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.l0[this.ql];
        this.l0[this.ql] = null;
        this.ql = (this.ql + 1) % this.l0.length;
        --this.r2;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.ek;
        if (this.r2 == this.l0.length) {
            this.l0();
        }
        this.l0[this.ic] = obj;
        this.ic = (this.ic + 1) % this.l0.length;
        ++this.r2;
    }

    public Object peek() {
        if (this.r2 < 1) {
            throw new InvalidOperationException();
        }
        return this.l0[this.ql];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.r2) {
            return Arrays.copyOf(this.l0, this.r2, a.getClass());
        }
        System.arraycopy(this.l0, 0, a, 0, this.r2);
        if (a.length > this.r2) {
            a[this.r2] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.ek;
        Object[] objectArray = new Object[this.r2];
        this.copyTo(com.aspose.slides.ms.System.ic.l0(objectArray), 0);
        this.l0 = objectArray;
        this.ql = 0;
        this.ic = 0;
    }

    private void l0() {
        int n = this.l0.length * this.yx / 100;
        if (n < this.l0.length + 1) {
            n = this.l0.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.ic.l0(objectArray), 0);
        this.l0 = objectArray;
        this.ql = 0;
        this.ic = this.ql + this.r2;
    }

    @u1
    private static class QueueEnumerator
    implements IEnumerator,
    g0 {
        private Queue l0;
        private int ql;
        private int r2;

        QueueEnumerator(Queue q) {
            this.l0 = q;
            this.ql = q.ek;
            this.r2 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.l0);
            queueEnumerator.ql = this.ql;
            queueEnumerator.r2 = this.r2;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.ql != this.l0.ek || this.r2 < 0 || this.r2 >= this.l0.r2) {
                throw new InvalidOperationException();
            }
            return this.l0.l0[(this.l0.ql + this.r2) % this.l0.l0.length];
        }

        @Override
        public boolean hasNext() {
            if (this.ql != this.l0.ek) {
                throw new InvalidOperationException();
            }
            if (this.r2 >= this.l0.r2 - 1) {
                this.r2 = Integer.MAX_VALUE;
                return false;
            }
            ++this.r2;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.ql != this.l0.ek) {
                throw new InvalidOperationException();
            }
            this.r2 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue l0;

        SyncQueue(Queue queue) {
            this.l0 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int index) {
            Queue queue = this.l0;
            synchronized (queue) {
                this.l0.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.l0;
            synchronized (queue) {
                return new SyncQueue((Queue)this.l0.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.l0;
            synchronized (queue) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.l0;
            synchronized (queue) {
                this.l0.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.l0;
            synchronized (queue) {
                this.l0.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.l0;
            synchronized (queue) {
                return this.l0.toArray(a);
            }
        }
    }
}

