/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.ka;
import com.aspose.slides.ms.System.sg;
import com.aspose.slides.ms.System.yl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@yl
public class ArrayList
implements IList,
List {
    private Object[] pf;
    private int aa;
    private int r3;
    private static Object[] ik = new Object[0];

    protected int getVersion() {
        return this.r3;
    }

    public ArrayList() {
        this.pf = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.pf = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.pf("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.pf = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.pf = null;
    }

    private ArrayList(ik array, int index, int count) {
        this.pf = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.ik.pf(array, index, com.aspose.slides.ms.System.ik.pf(this.pf), 0, count);
        this.aa = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.aa) {
            ArrayList.pf("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.pf[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.aa) {
            ArrayList.pf("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.pf[index] = value;
        ++this.r3;
    }

    @Override
    public int size() {
        return this.aa;
    }

    public int getCapacity() {
        return this.pf.length;
    }

    public void setCapacity(int value) {
        if (value < this.aa) {
            ArrayList.pf("Capacity", (Object)value, "Must be more than count.");
        }
        this.pf = value > 0 ? Arrays.copyOf(this.pf, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void pf(int n) {
        int n10;
        if (n <= this.pf.length) {
            return;
        }
        int n11 = n10 = this.pf.length == 0 ? 4 : this.pf.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void pf(int n, int n10) {
        if (n10 > 0) {
            if (this.aa + n10 > this.pf.length) {
                int n11;
                int n12 = n11 = this.pf.length > 0 ? this.pf.length << 1 : 1;
                while (n11 < this.aa + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.ik.pf(this.pf, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.ik.pf(this.pf, n, objectArray, n + n10, this.aa - n);
                this.pf = objectArray;
            } else {
                com.aspose.slides.ms.System.ik.pf(this.pf, n, this.pf, n + n10, this.aa - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.ik.pf(this.pf, n13, this.pf, n, this.aa - n13);
            com.aspose.slides.ms.System.ik.pf(this.pf, this.aa + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.pf.length <= this.aa) {
            this.pf(this.aa + 1);
        }
        this.pf[this.aa] = value;
        ++this.r3;
        return this.aa++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, this.aa);
        this.aa = 0;
        ++this.r3;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.aa) > -1;
    }

    boolean pf(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.aa - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.aa) {
            ArrayList.pf("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.pf("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.aa - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.ik.pf(this.pf, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.aa - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return ka.pf(this.pf, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.aa) {
            ArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.pf(index, 1);
        this.pf[index] = value;
        ++this.aa;
        ++this.r3;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.aa) {
            ArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.pf.length < this.aa + n) {
                this.pf(this.aa + n);
            }
            if (index < this.aa) {
                com.aspose.slides.ms.System.ik.pf(this.pf, index, this.pf, index + n, this.aa - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.ik.pf(this.pf, 0, this.pf, index, index);
                com.aspose.slides.ms.System.ik.pf(this.pf, index + n, this.pf, index << 1, this.aa - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.ik.pf(this.pf), index);
            }
            this.aa += c.size();
            ++this.r3;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.aa) {
            ArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.pf.length < this.aa + n) {
                this.pf(this.aa + n);
            }
            if (index < this.aa) {
                com.aspose.slides.ms.System.ik.pf(this.pf, index, this.pf, index + n, this.aa - index);
            }
            com.aspose.slides.ms.System.ik.pf(c).copyTo(com.aspose.slides.ms.System.ik.pf(this.pf), index);
            this.aa += c.length;
            ++this.r3;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.r3;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.aa) {
            ArrayList.pf("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.pf(index, -1);
        --this.aa;
        ++this.r3;
    }

    public void removeRange(int index, int count) {
        ArrayList.pf(index, count, this.aa);
        this.pf(index, -count);
        this.aa -= count;
        ++this.r3;
    }

    public void reverse() {
        ka.pf(this.pf, 0, this.aa);
        ++this.r3;
    }

    public void reverse(int index, int count) {
        ArrayList.pf(index, count, this.aa);
        ka.pf(this.pf, index, count);
        ++this.r3;
    }

    public void copyTo(ik array) {
        com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf), 0, array, 0, this.aa);
    }

    @Override
    public void copyTo(ik array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.aa);
    }

    public void copyTo(int index, ik array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ik() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.pf(index, count, this.aa);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.aa, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.aa, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return ka.pf(this.pf, 0, this.aa, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return ka.pf(this.pf, 0, this.aa, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return ka.pf(this.pf, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.pf(index, count, this.aa);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.aa) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.ik.pf(this.pf), index);
        ++this.r3;
    }

    public void trimToSize() {
        this.setCapacity(this.aa);
    }

    public void sort() {
        Arrays.sort(this.pf, 0, this.aa, Comparer.Default);
        ++this.r3;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.pf, 0, this.aa, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.pf(index, count, this.aa);
        Arrays.sort(this.pf, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.aa];
        this.copyTo(com.aspose.slides.ms.System.ik.pf(objectArray));
        return objectArray;
    }

    public ik toArray(sg type) {
        ik ik2 = com.aspose.slides.ms.System.ik.pf(type, this.aa);
        this.copyTo(ik2);
        return ik2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.ik.pf(this.pf), 0, this.aa);
    }

    static void pf(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.pf("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.pf("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void pf(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.ik.pf(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.aa, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List pf;
        private int aa;

        @Override
        protected int getVersion() {
            return this.pf instanceof ArrayList ? ((ArrayList)this.pf).getVersion() : this.aa;
        }

        public ArrayListInternalized(List internal) {
            this.pf = internal;
            if (internal instanceof ArrayList) {
                this.aa = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.pf.set(index, value);
            ++this.aa;
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.pf.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.pf.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.pf.size(); ++i) {
                this.pf.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.pf.size();
            this.pf.add(value);
            ++this.aa;
            return n;
        }

        @Override
        public void clear() {
            this.pf.clear();
            ++this.aa;
        }

        @Override
        public boolean contains(Object item) {
            return this.pf.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.pf.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.pf.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.pf.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.pf.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.pf.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return ka.pf(this.pf.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.pf.add(index, value);
            ++this.aa;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.pf.add(index++, e);
            }
            ++this.aa;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.pf.add(index++, object);
            }
            ++this.aa;
        }

        @Override
        public void removeItem(Object obj) {
            this.pf.remove(obj);
            ++this.aa;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.pf.remove(index);
            ++this.aa;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.pf.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.pf.remove(index);
            }
            ++this.aa;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.pf.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.pf.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.pf.size() - 1; n < i; ++n, --i) {
                Object e = this.pf.get(n);
                this.pf.set(n, this.pf.get(i));
                this.pf.set(i, e);
            }
            ++this.aa;
        }

        @Override
        public void copyTo(ik array) {
            com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf.toArray()), 0, array, 0, this.pf.size());
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.pf.size());
        }

        @Override
        public void copyTo(int index, ik array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ik() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.pf(index, count, this.pf.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.pf.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return ka.pf(this.pf.toArray(), 0, this.pf.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return ka.pf(this.pf.toArray(), 0, this.pf.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return ka.pf(this.pf.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.pf(index, count, this.pf.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.pf.set(index++, e);
            }
            ++this.aa;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.pf, null);
            ++this.aa;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.pf, comparer);
            ++this.aa;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.pf.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.pf.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.pf.set(i, list.get(i - index));
            }
            ++this.aa;
        }

        @Override
        public Object[] toArray() {
            return this.pf.toArray();
        }

        @Override
        public ik toArray(sg type) {
            ik ik2 = com.aspose.slides.ms.System.ik.pf(type, this.pf.size());
            this.copyTo(ik2);
            return ik2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.pf.size()];
            com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), 0, objectArray, 0, this.pf.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.pf.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.pf.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.aa;
            return this.pf.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.aa;
            return this.pf.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.pf.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.aa;
            return this.pf.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.aa;
            return this.pf.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.aa;
            return this.pf.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.aa;
            return this.pf.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.pf.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.aa;
            return this.pf.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.pf.add(index, element);
            ++this.aa;
        }

        @Override
        public Object remove(int index) {
            ++this.aa;
            return this.pf.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.pf.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.pf.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.pf.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.pf = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.pf != 0;
        }

        @Override
        public int nextIndex() {
            return this.pf;
        }

        @Override
        public int previousIndex() {
            return this.pf - 1;
        }

        public Object previous() {
            int n = this.pf - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.pf;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.pf = n;
            this.aa = n;
            return objectArray[this.aa];
        }

        public void set(Object e) {
            if (this.aa < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).pf[this.aa] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.pf;
                ArrayList.this.add(n, e);
                this.pf = n + 1;
                this.aa = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int pf;
        int aa = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pf != ArrayList.this.size();
        }

        public Object next() {
            int n = this.pf;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.pf;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.pf = n + 1;
            this.aa = n;
            return objectArray[this.aa];
        }

        @Override
        public void remove() {
            if (this.aa < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.aa);
                this.pf = this.aa;
                this.aa = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @yl
    private static class ListWrapper
    implements IList {
        protected IList pf;

        public ListWrapper(IList innerList) {
            this.pf = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.pf.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.pf.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.pf.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.pf.addItem(value);
        }

        @Override
        public void clear() {
            this.pf.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.pf.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.pf.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.pf.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.pf.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.pf.removeAt(index);
        }

        @Override
        public void copyTo(ik array, int index) {
            this.pf.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.pf.iterator();
        }
    }

    @yl
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String pf() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.pf());
        }
    }

    @yl
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String pf() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.pf());
        }
    }

    @yl
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object aa;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.aa = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.aa;
            synchronized (object) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int index) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.iterator();
            }
        }
    }

    @yl
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int aa;
        private int r3;
        private int ik;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.aa = index;
            this.r3 = count;
            this.ik = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.r3) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.pf.get_Item(this.aa + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.r3) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.pf.set_Item(this.aa + index, value);
        }

        @Override
        public int size() {
            this.pf();
            return this.r3;
        }

        @Override
        public int getCapacity() {
            return this.pf.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.r3) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void pf() {
            if (this.ik != this.pf.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.pf();
            this.pf.insertItem(this.aa + this.r3, value);
            this.ik = this.pf.getVersion();
            return ++this.r3;
        }

        @Override
        public void clear() {
            this.pf();
            this.pf.removeRange(this.aa, this.r3);
            this.r3 = 0;
            this.ik = this.pf.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.pf.pf(value, this.aa, this.r3);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.r3 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.r3) {
                RangedArrayList.pf("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.pf("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.r3 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.pf.indexOf(value, this.aa + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.aa;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.r3 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.pf("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.pf("count", (Object)count, "count is negative.");
            }
            if ((n = this.pf.lastIndexOf(value, this.aa + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.aa;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.pf();
            if (index < 0 || index > this.r3) {
                RangedArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.pf.insertItem(this.aa + index, value);
            ++this.r3;
            this.ik = this.pf.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.pf();
            if (index < 0 || index > this.r3) {
                RangedArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.pf.insertRange(this.aa + index, c);
            this.r3 += c.size();
            this.ik = this.pf.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.pf();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.ik = this.pf.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.pf();
            if (index < 0 || index > this.r3) {
                RangedArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.pf.removeAt(this.aa + index);
            --this.r3;
            this.ik = this.pf.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.pf();
            RangedArrayList.pf(index, count, this.r3);
            this.pf.removeRange(this.aa + index, count);
            this.r3 -= count;
            this.ik = this.pf.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.r3);
        }

        @Override
        public void reverse(int index, int count) {
            this.pf();
            RangedArrayList.pf(index, count, this.r3);
            this.pf.reverse(this.aa + index, count);
            this.ik = this.pf.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.pf();
            if (index < 0 || index > this.r3) {
                RangedArrayList.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.pf.setRange(this.aa + index, c);
            this.ik = this.pf.getVersion();
        }

        @Override
        public void copyTo(ik array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(ik array, int index) {
            this.copyTo(0, array, index, this.r3);
        }

        @Override
        public void copyTo(int index, ik array, int arrayIndex, int count) {
            RangedArrayList.pf(index, count, this.r3);
            this.pf.copyTo(this.aa + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.r3);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.pf(index, count, this.r3);
            return this.pf.iterator(this.aa + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.pf();
            this.pf.insertRange(this.r3, c);
            this.r3 += c.size();
            this.ik = this.pf.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.r3, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.r3, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.pf(index, count, this.r3);
            return this.pf.binarySearch(this.aa + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.pf.deepClone(), this.aa, this.r3);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.pf(index, count, this.r3);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.r3, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.pf();
            RangedArrayList.pf(index, count, this.r3);
            this.pf.sort(this.aa + index, count, comparer);
            this.ik = this.pf.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.r3];
            this.pf.copyTo(this.aa, com.aspose.slides.ms.System.ik.pf(objectArray), 0, this.r3);
            return objectArray;
        }

        @Override
        public ik toArray(sg elementType) {
            ik ik2 = com.aspose.slides.ms.System.ik.pf(elementType, this.r3);
            this.pf.copyTo(this.aa, ik2, 0, this.r3);
            return ik2;
        }
    }

    @yl
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String pf() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.pf());
        }
    }

    @yl
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String pf() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.pf());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.pf());
        }
    }

    @yl
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object aa;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.aa = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.aa;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.aa;
            synchronized (object) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.aa;
            synchronized (object) {
                this.pf.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int index) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, ik array, int arrayIndex, int count) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.aa;
            synchronized (object) {
                this.pf.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.aa;
            synchronized (object) {
                this.pf.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.aa;
            synchronized (object) {
                this.pf.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ik toArray(sg elementType) {
            Object object = this.aa;
            synchronized (object) {
                return this.pf.toArray(elementType);
            }
        }
    }

    @yl
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList pf;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.pf = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.pf.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public int getCapacity() {
            return this.pf.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.pf.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.pf.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.pf.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.pf.addItem(value);
        }

        @Override
        public void clear() {
            this.pf.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.pf.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.pf.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.pf.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.pf.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.pf.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.pf.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.pf.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.pf.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.pf.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.pf.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.pf.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.pf.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.pf.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.pf.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.pf.setRange(index, c);
        }

        @Override
        public void copyTo(ik array) {
            this.pf.copyTo(array);
        }

        @Override
        public void copyTo(ik array, int index) {
            this.pf.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ik array, int arrayIndex, int count) {
            this.pf.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.pf.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.pf.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.pf.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.pf.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.pf.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.pf.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.pf.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.pf.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.pf.trimToSize();
        }

        @Override
        public void sort() {
            this.pf.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.pf.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.pf.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.pf.toArray();
        }

        @Override
        public ik toArray(sg elementType) {
            return this.pf.toArray(elementType);
        }
    }

    @yl
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList pf;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.pf = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.pf.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public int getCapacity() {
            return this.pf.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.pf.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.pf.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.pf.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.pf.addItem(value);
        }

        @Override
        public void clear() {
            this.pf.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.pf.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.pf.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.pf.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.pf.size()) {
                ArrayListAdapter.pf("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.pf("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.pf.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.pf.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.pf.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.pf.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.pf("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.pf("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.pf("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.pf.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.pf.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.pf.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.pf.size()) {
                ArrayListAdapter.pf("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.pf.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.pf.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.pf.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            for (int i = 0; i < count; ++i) {
                this.pf.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.pf.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.pf.get_Item(i + index);
                this.pf.set_Item(i + index, this.pf.get_Item(index + count - i + index - 1));
                this.pf.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.pf.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.pf.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(ik array) {
            this.pf.copyTo(array, 0);
        }

        @Override
        public void copyTo(ik array, int index) {
            this.pf.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ik array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.pf("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.pf("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.pf("index", (Object)index, "Can't be less than zero.");
            }
            if (array.ik() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.pd() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.pf.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.r3(this.pf.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.pf.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            return new EnumeratorWithRange(this.pf.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.pf.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.pf.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.pf.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.pf);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.pf.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.pf(index, count, this.pf.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.pf(this.pf, index, index + count - 1, comparer);
        }

        private static void pf(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void pf(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.pf(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.pf(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.pf(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.pf(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.pf(iList, n12, n13);
            }
            ArrayListAdapter.pf(iList, n10 - 1, n12);
            ArrayListAdapter.pf(iList, n, n12 - 1, comparator);
            ArrayListAdapter.pf(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.pf.size()];
            this.pf.copyTo(com.aspose.slides.ms.System.ik.pf(objectArray), 0);
            return objectArray;
        }

        @Override
        public ik toArray(sg elementType) {
            ik ik2 = com.aspose.slides.ms.System.ik.pf(elementType, this.pf.size());
            this.pf.copyTo(ik2, 0);
            return ik2;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        gd,
        Cloneable {
            private int pf;
            private int aa;
            private int r3;
            private IEnumerator ik;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.aa = 0;
                this.pf = index;
                this.r3 = count;
                this.ik = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.pf();
            }

            @Override
            public Object next() {
                return this.ik.next();
            }

            @Override
            public boolean hasNext() {
                if (this.aa >= this.r3) {
                    return false;
                }
                ++this.aa;
                return this.ik.hasNext();
            }

            @Override
            public void reset() {
                this.aa = 0;
                this.ik.reset();
                for (int i = 0; i < this.pf; ++i) {
                    this.ik.hasNext();
                }
            }

            protected Object pf() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.pf = this.pf;
                enumeratorWithRange.aa = this.aa;
                enumeratorWithRange.r3 = this.r3;
                enumeratorWithRange.ik = this.ik;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    gd,
    Cloneable {
        private ArrayList aa;
        private Object r3;
        private int ik;
        private int pd;
        static Object pf = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.aa = list;
            this.ik = -1;
            this.pd = list.getVersion();
            this.r3 = pf;
        }

        @Override
        public Object deepClone() {
            return this.pf();
        }

        @Override
        public boolean hasNext() {
            if (this.pd != this.aa.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.ik < this.aa.size()) {
                this.r3 = this.aa.get_Item(this.ik);
                return true;
            }
            this.r3 = pf;
            return false;
        }

        @Override
        public Object next() {
            if (this.r3 == pf) {
                if (this.ik == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.r3;
        }

        @Override
        public void reset() {
            if (this.pd != this.aa.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.r3 = pf;
            this.ik = -1;
        }

        protected Object pf() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.aa = this.aa;
            simpleEnumerator.r3 = this.r3;
            simpleEnumerator.ik = this.ik;
            simpleEnumerator.pd = this.pd;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    gd,
    Cloneable {
        private Object pf;
        private ArrayList aa;
        private int r3;
        private int ik;
        private int pd;
        private int ni;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.pf();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.aa = list;
            this.ik = index;
            this.pd = count;
            this.r3 = this.ik - 1;
            this.pf = null;
            this.ni = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.r3 == this.ik - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.pf;
        }

        @Override
        public boolean hasNext() {
            if (this.aa.getVersion() != this.ni) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.r3;
            if (this.r3 - this.ik < this.pd) {
                this.pf = this.aa.get_Item(this.r3);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.pf = null;
            this.r3 = this.ik - 1;
        }

        protected Object pf() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.pf = this.pf;
            arrayListEnumerator.aa = this.aa;
            arrayListEnumerator.r3 = this.r3;
            arrayListEnumerator.ik = this.ik;
            arrayListEnumerator.pd = this.pd;
            arrayListEnumerator.ni = this.ni;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

