/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.nr.iz;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.ka;
import com.aspose.slides.ms.System.pf;
import com.aspose.slides.ms.System.r2;
import com.aspose.slides.ms.System.rg;
import com.aspose.slides.ms.System.xy;
import com.aspose.slides.ms.System.yb;
import com.aspose.slides.ms.System.yl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@yl
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] pf;
    private int aa;
    private int r3;
    private final Object ik = new Object();
    static Object[] ni = new Object[0];

    public List() {
        this.pf = ni;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.pf = ni;
        this.pf(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.pf = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.pf = data;
        this.aa = size;
    }

    protected int getVersion() {
        return this.r3;
    }

    @Override
    public void addItem(T item) {
        if (this.aa == this.pf.length) {
            this.pf(1);
        }
        this.pf[this.aa++] = item;
        ++this.r3;
    }

    private void pf(int n) {
        int n10 = this.aa + n;
        if (n10 > this.pf.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void pf(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void pf(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.pf(new List<T>(collection));
        ++this.r3;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.r3;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return ka.pf(this.pf, 0, this.aa, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return ka.pf(this.pf, 0, this.aa, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.pf(index, count);
        return ka.pf(this.pf, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, this.pf.length);
        this.aa = 0;
        ++this.r3;
    }

    public <TOutput> List<TOutput> convertAll(xy<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.aa);
        for (int i = 0; i < this.aa; ++i) {
            list.pf[i] = converter.pf(this.pf[i]);
        }
        list.aa = this.aa;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, array, 0, this.aa);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, array, arrayIndex, this.aa);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.pf(index, count);
        com.aspose.slides.ms.System.ik.pf(this.pf, index, array, arrayIndex, count);
    }

    public boolean exists(yb<T> match) {
        List.pf(match);
        return this.pf(0, this.aa, match) != -1;
    }

    public T find(yb<T> match) {
        List.pf(match);
        int n = this.pf(0, this.aa, match);
        return (T)(n != -1 ? this.pf[n] : null);
    }

    static <T> void pf(yb<T> yb2) {
        if (yb2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(yb<T> match) {
        List.pf(match);
        return this.aa(match);
    }

    private List<T> aa(yb<T> yb2) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.aa; ++i) {
            if (!yb2.invoke(this.pf[i])) continue;
            list.addItem(this.pf[i]);
        }
        return list;
    }

    public int findIndex(yb<T> match) {
        List.pf(match);
        return this.pf(0, this.aa, match);
    }

    public int findIndex(int startIndex, yb<T> match) {
        List.pf(match);
        this.aa(startIndex);
        return this.pf(startIndex, this.aa - startIndex, match);
    }

    public int findIndex(int startIndex, int count, yb<T> match) {
        List.pf(match);
        this.pf(startIndex, count);
        return this.pf(startIndex, count, match);
    }

    private int pf(int n, int n10, yb<T> yb2) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!yb2.invoke(this.pf[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(yb<T> match) {
        List.pf(match);
        int n = this.aa(0, this.aa, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(yb<T> match) {
        List.pf(match);
        return this.aa(0, this.aa, match);
    }

    public int findLastIndex(int startIndex, yb<T> match) {
        List.pf(match);
        this.aa(startIndex);
        return this.aa(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, yb<T> match) {
        List.pf(match);
        int n = startIndex - count + 1;
        this.pf(n, count);
        return this.aa(n, count, match);
    }

    private int aa(int n, int n10, yb<T> yb2) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!yb2.invoke(this.pf[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(pf<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.aa; ++i) {
            action.invoke(this.pf[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.pf(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.ik.pf(this.pf, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.ik.pf(this.pf, item, 0, this.aa);
    }

    public int indexOf(T item, int index) {
        this.aa(index);
        return com.aspose.slides.ms.System.ik.pf(this.pf, item, index, this.aa - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.ik.pf(this.pf, item, index, count);
    }

    private void aa(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.aa) {
            com.aspose.slides.ms.System.ik.pf(this.pf, n, this.pf, n + n10, this.aa - n);
        }
        this.aa += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.ik.pf(this.pf, this.aa, -n10);
        }
    }

    private void aa(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.aa(index);
        if (this.aa == this.pf.length) {
            this.pf(1);
        }
        this.aa(index, 1);
        this.pf[index] = item;
        ++this.r3;
    }

    void r3(int n) {
        Object[] objectArray = new Object[this.aa];
        this.copyToTArray(objectArray, 0);
        this.pf(this.aa);
        this.aa(n, objectArray.length);
        com.aspose.slides.ms.System.ik.pf(objectArray, 0, this.pf, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.aa(index);
        if (collection == this) {
            this.r3(index);
        } else {
            this.pf(index, collection);
        }
        ++this.r3;
    }

    private void pf(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.aa == 0) {
            return -1;
        }
        return ka.pf(this.pf, item, this.aa - 1, this.aa);
    }

    public int lastIndexOf(T item, int index) {
        this.aa(index);
        return ka.pf(this.pf, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return ka.pf(this.pf, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(yb<T> match) {
        List.pf(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.aa && !match.invoke(this.pf[n]); ++n) {
        }
        if (n == this.aa) {
            return 0;
        }
        ++this.r3;
        for (n10 = n + 1; n10 < this.aa; ++n10) {
            if (match.invoke(this.pf[n10])) continue;
            this.pf[n++] = this.pf[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.ik.pf(this.pf, n, n10 - n);
        }
        this.aa = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.aa(index, -1);
        com.aspose.slides.ms.System.ik.pf(this.pf, this.aa, 1);
        ++this.r3;
    }

    public void removeRange(int index, int count) {
        this.pf(index, count);
        if (count > 0) {
            this.aa(index, -count);
            com.aspose.slides.ms.System.ik.pf(this.pf, this.aa, count);
            ++this.r3;
        }
    }

    public void reverse() {
        ka.pf(this.pf, 0, this.aa);
        ++this.r3;
    }

    public void reverse(int index, int count) {
        this.pf(index, count);
        ka.pf(this.pf, index, count);
        ++this.r3;
    }

    public void sort() {
        Arrays.sort(this.pf, 0, this.aa);
        ++this.r3;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.pf, 0, this.aa, comparer);
        ++this.r3;
    }

    @Override
    public void sort(r2<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.pf, 0, this.aa, new ka.pf<T>(comparison));
        ++this.r3;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.pf(index, count);
        Arrays.sort(this.pf, index, index + count, comparer);
        ++this.r3;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.aa) {
            return Arrays.copyOf(this.pf, this.aa, a.getClass());
        }
        System.arraycopy(this.pf, 0, a, 0, this.aa);
        if (a.length > this.aa) {
            a[this.aa] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.aa);
    }

    public boolean trueForAll(yb<T> match) {
        List.pf(match);
        for (int i = 0; i < this.aa; ++i) {
            if (match.invoke(this.pf[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.pf.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.pf = Arrays.copyOf(this.pf, value);
    }

    @Override
    public int size() {
        return this.aa;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.aa & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.pf[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.aa(index);
        if ((long)index == (long)this.aa) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.pf[index] = value;
        ++this.r3;
    }

    public void copyTo(ik array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ik() > 1 || array.aa(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf), 0, array, arrayIndex, this.aa);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.ik;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.aa == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.aa; ++i) {
                if (this.pf[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.aa; ++i) {
            if (!this.pf[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.aa; ++i) {
                if (this.pf[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.aa; ++i) {
            if (!this.pf[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.aa];
        System.arraycopy(this.pf, 0, objectArray, 0, this.aa);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.aa;
        this.addItem(t);
        return n != this.aa;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.aa;
        this.removeItem(o);
        return n != this.aa;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.aa; ++i) {
                if (this.pf[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.aa; ++i) {
            if (!o.equals(this.pf[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> pf;
        private int aa;

        public ListInternalized() {
            this.pf = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.pf = list;
        }

        @Override
        protected int getVersion() {
            return this.aa;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.pf(collection);
            ++this.aa;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.aa;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return ka.pf(this.pf.toArray(), 0, this.pf.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return ka.pf(this.pf.toArray(), 0, this.pf.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.pf(index, count);
            return ka.pf(this.pf.toArray(), index, count, item, comparer);
        }

        @Override
        private void pf(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(xy<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.pf.size());
            for (int i = 0; i < this.pf.size(); ++i) {
                list.pf[i] = converter.pf(this.get_Item(i));
            }
            list.aa = this.pf.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), 0, array, 0, this.pf.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), 0, array, arrayIndex, this.pf.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.pf(index, count);
            com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(yb<T> match) {
            ListInternalized.aa(match);
            return this.pf(0, this.pf.size(), match) != -1;
        }

        @Override
        private int pf(int n, int n10, yb<T> yb2) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!yb2.invoke(this.pf.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void aa(yb<T> yb2) {
            if (yb2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(yb<T> match) {
            ListInternalized.aa(match);
            int n = this.pf(0, this.pf.size(), match);
            return n != -1 ? (T)this.pf.get(n) : null;
        }

        @Override
        public List<T> findAll(yb<T> match) {
            ListInternalized.aa(match);
            return this.r3(match);
        }

        private List<T> r3(yb<T> yb2) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!yb2.invoke(this.pf.get(i))) continue;
                list.addItem(this.pf.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(yb<T> match) {
            ListInternalized.aa(match);
            return this.pf(0, this.pf.size(), match);
        }

        @Override
        public int findIndex(int startIndex, yb<T> match) {
            ListInternalized.aa(match);
            this.pf(startIndex);
            return this.pf(startIndex, this.pf.size() - startIndex, match);
        }

        @Override
        private void pf(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, yb<T> match) {
            ListInternalized.aa(match);
            this.pf(startIndex, count);
            return this.pf(startIndex, count, match);
        }

        @Override
        public T findLast(yb<T> match) {
            ListInternalized.aa(match);
            int n = this.aa(0, this.pf.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int aa(int n, int n10, yb<T> yb2) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!yb2.invoke(this.pf.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(yb<T> match) {
            ListInternalized.aa(match);
            return this.aa(0, this.pf.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, yb<T> match) {
            ListInternalized.aa(match);
            this.pf(startIndex);
            return this.aa(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, yb<T> match) {
            ListInternalized.aa(match);
            int n = startIndex - count + 1;
            this.pf(n, count);
            return this.aa(n, count, match);
        }

        @Override
        public void forEach(pf<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.pf.size(); ++i) {
                action.invoke(this.pf.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.pf(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.pf.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.pf(index);
            return com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), item, index, this.pf.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.ik.pf(this.pf.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.pf.size() == 0) {
                return -1;
            }
            return ka.pf(this.pf.toArray(), item, this.pf.size() - 1, this.pf.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.pf(index);
            return ka.pf(this.pf.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return ka.pf(this.pf.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.pf.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.pf.size());
        }

        @Override
        public boolean trueForAll(yb<T> match) {
            ListInternalized.aa(match);
            for (int i = 0; i < this.pf.size(); ++i) {
                if (match.invoke(this.pf.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.pf.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.pf.size(); ++i) {
                this.pf.add(null);
            }
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public T get_Item(int index) {
            return this.pf.get(index);
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ik() > 1 || array.aa(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf.toArray()), 0, array, arrayIndex, this.pf.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.pf.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.pf.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.pf.size(); ++i) {
                    if (this.pf.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.pf.size(); ++i) {
                if (!this.pf.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.pf.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.aa;
            return this.pf.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.aa;
            return this.pf.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.pf.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.aa;
            return this.pf.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.aa;
            return this.pf.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.aa;
            return this.pf.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.aa;
            return this.pf.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.pf.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.aa;
            return this.pf.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.aa;
            this.pf.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.aa;
            return this.pf.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.pf.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.pf.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.pf.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.pf.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.pf.add(item);
            ++this.aa;
        }

        @Override
        public void clear() {
            this.pf.clear();
            ++this.aa;
        }

        @Override
        public void insertItem(int index, T item) {
            this.pf.add(index, item);
            ++this.aa;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.pf.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.pf.add(n++, e);
                }
            }
            ++this.aa;
        }

        @Override
        public int removeAll(yb<T> match) {
            ListInternalized.aa(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.pf.size() && !match.invoke(this.pf.get(n)); ++n) {
            }
            if (n == this.pf.size()) {
                return 0;
            }
            ++this.aa;
            for (n10 = n + 1; n10 < this.pf.size(); ++n10) {
                if (match.invoke(this.pf.get(n10))) continue;
                this.pf.set(n++, this.pf.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.pf.remove(this.pf.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.pf.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.pf.remove(index);
            ++this.aa;
        }

        @Override
        public void removeRange(int index, int count) {
            this.pf(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.pf.remove(index);
                }
                ++this.aa;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.pf(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.pf.get(n);
                this.pf.set(n, this.pf.get(i));
                this.pf.set(i, t);
            }
            ++this.aa;
        }

        @Override
        public void sort() {
            Collections.sort(this.pf, null);
            ++this.aa;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.pf, comparer);
            ++this.aa;
        }

        @Override
        public void sort(final r2<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.pf, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.pf(o12, o22);
                }
            });
            ++this.aa;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.pf(index, count);
            java.util.List<T> list = this.pf.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.pf.set(index + i, list.get(i));
            }
            ++this.aa;
        }

        @Override
        public void set_Item(int index, T value) {
            this.pf(index);
            if ((long)index == (long)this.pf.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.pf.set(index, value);
            ++this.aa;
        }

        @Override
        private void pf(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @yl
    public static class EnumeratorJava<T>
    extends iz<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> aa = new List();
        private int r3;
        private int ik;
        private T pd;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.aa = l;
            this.ik = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void pf() {
            if (this.ik != this.aa.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.r3 < 0 || this.r3 >= this.aa.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.ik != this.aa.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.pd = this.aa.get_Item(this.r3++);
            return this.pd;
        }

        @Override
        public boolean hasNext() {
            if (this.ik == this.aa.getVersion()) {
                if (this.r3 < 0) {
                    return false;
                }
                return this.r3 < this.aa.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.pf();
            this.r3 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.aa = this.aa;
            that.r3 = this.r3;
            that.ik = this.ik;
            that.pd = this.pd;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean pf(EnumeratorJava enumeratorJava) {
            return rg.pf(enumeratorJava.aa, this.aa) && enumeratorJava.r3 == this.r3 && enumeratorJava.ik == this.ik && rg.pf(enumeratorJava.pd, this.pd);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (rg.aa(null, obj)) {
                return false;
            }
            if (rg.aa(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.pf((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.aa != null ? this.aa.hashCode() : 0;
            n = 31 * n + this.r3;
            n = 31 * n + this.ik;
            n = 31 * n + (this.pd != null ? this.pd.hashCode() : 0);
            return n;
        }
    }

    @yl
    public static class Enumerator<T>
    extends iz<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> aa = new List();
        private int r3;
        private int ik;
        private T pd;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.aa = l;
            this.ik = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void pf() {
            if (this.ik != this.aa.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ik == this.aa.getVersion()) {
                if (this.r3 < 0) {
                    return false;
                }
                if (this.r3 < this.aa.size()) {
                    this.pd = this.aa.get_Item(this.r3++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.r3 = this.aa.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.pf();
            this.r3 = 0;
        }

        @Override
        public T next() {
            if (this.r3 < 0 || this.r3 >= this.aa.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.pd;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.aa = this.aa;
            that.r3 = this.r3;
            that.ik = this.ik;
            that.pd = this.pd;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean pf(Enumerator enumerator) {
            return rg.pf(enumerator.aa, this.aa) && enumerator.r3 == this.r3 && enumerator.ik == this.ik && rg.pf(enumerator.pd, this.pd);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (rg.aa(null, obj)) {
                return false;
            }
            if (rg.aa(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.pf((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.aa != null ? this.aa.hashCode() : 0;
            n = 31 * n + this.r3;
            n = 31 * n + this.ik;
            n = 31 * n + (this.pd != null ? this.pd.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.pf = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.pf != 0;
        }

        @Override
        public int nextIndex() {
            return this.pf;
        }

        @Override
        public int previousIndex() {
            return this.pf - 1;
        }

        public T previous() {
            int n = this.pf - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.pf;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.pf = n;
            this.aa = n;
            return objectArray[this.aa];
        }

        public void set(T e) {
            if (this.aa < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.aa, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.pf;
                List.this.add(n, e);
                this.pf = n + 1;
                this.aa = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int pf;
        int aa = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pf != List.this.aa;
        }

        @Override
        public T next() {
            int n = this.pf;
            if (n >= List.this.aa) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.pf;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.pf = n + 1;
            this.aa = n;
            return (T)objectArray[this.aa];
        }

        @Override
        public void remove() {
            if (this.aa < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.aa);
                this.pf = this.aa;
                this.aa = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

