/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.yl;

@yl
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> pf;
    private IGenericEqualityComparer<TKey> aa;
    private int r3;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.aa = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.r3 = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.pf = new Dictionary(this.aa);
        }
    }

    public boolean containsKey(TKey key2) {
        if (this.pf != null) {
            return this.pf.containsKey(key2);
        }
        return this.pf(key2) >= 0;
    }

    private int pf(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.aa.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key2) {
        Object object = null;
        if (this.pf != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.pf.tryGetValue(key2, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.pf(key2);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.aa;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.pf != null && ((Dictionary.KeyCollection)this.pf.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.pf.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key2) {
        if (this.pf != null) {
            return this.pf.get_Item(key2);
        }
        int n = this.pf(key2);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.aa.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.pf != null) {
            if (!this.pf.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.pf.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.pf != null) {
            this.pf.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.pf != null && this.pf.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.pf == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.aa.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.pf != null) {
            this.pf.addItem(TKey, item);
        } else if (this.r3 != -1 && this.size() > this.r3) {
            this.pf = new Dictionary(this.aa);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.pf.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.pf != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.pf.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.pf != null) {
            this.pf.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.pf.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.pf;
    }
}

