/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.ka;
import com.aspose.slides.ms.System.yl;
import java.util.Arrays;

@yl
public class Stack
implements ICollection,
IEnumerable,
gd {
    private Object[] pf;
    private int aa = -1;
    private int r3;
    private int ik;
    private int pd;

    private void pf(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, objectArray, 0, this.r3);
        this.ik = n;
        this.pf = objectArray;
    }

    public Stack() {
        this.pf = new Object[16];
        this.ik = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.ik = initialCapacity;
        this.pf = new Object[this.ik];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.r3;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.pd;
        for (int i = 0; i < this.r3; ++i) {
            this.pf[i] = null;
        }
        this.r3 = 0;
        this.aa = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.ik.pf(this.pf));
        stack.aa = this.aa;
        stack.r3 = this.r3;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.r3 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.r3; ++i) {
                if (this.pf[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.r3; ++i) {
                if (!obj.equals(this.pf[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ik array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ik() > 1 || array.pd() > 0 && index >= array.pd() || this.r3 > array.pd() - index) {
            throw new ArgumentException();
        }
        for (int i = this.aa; i != -1; --i) {
            array.r3(this.pf[i], this.r3 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.aa == -1) {
            throw new InvalidOperationException();
        }
        return this.pf[this.aa];
    }

    public Object pop() {
        if (this.aa == -1) {
            throw new InvalidOperationException();
        }
        ++this.pd;
        Object object = this.pf[this.aa];
        this.pf[this.aa] = null;
        --this.r3;
        --this.aa;
        if (this.r3 <= this.ik / 4 && this.r3 > 16) {
            this.pf(this.ik / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.pd;
        if (this.ik == this.r3) {
            this.pf(this.ik * 2);
        }
        ++this.r3;
        ++this.aa;
        this.pf[this.aa] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.r3) {
            a = Arrays.copyOf(this.pf, this.r3, a.getClass());
            ka.pf(a);
            return a;
        }
        System.arraycopy(this.pf, 0, a, 0, this.r3);
        if (a.length > this.r3) {
            a[this.r3] = null;
        }
        ka.pf(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    gd,
    Cloneable {
        private Stack pf;
        private int aa;
        private int r3;

        Enumerator(Stack s) {
            this.pf = s;
            this.aa = s.pd;
            this.r3 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.pf();
        }

        @Override
        public Object next() {
            if (this.aa != this.pf.pd || this.r3 == -2 || this.r3 == -1 || this.r3 > this.pf.r3) {
                throw new InvalidOperationException();
            }
            return this.pf.pf[this.r3];
        }

        @Override
        public boolean hasNext() {
            if (this.aa != this.pf.pd) {
                throw new InvalidOperationException();
            }
            switch (this.r3) {
                case -2: {
                    this.r3 = this.pf.aa;
                    return this.r3 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.r3;
            return this.r3 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.aa != this.pf.pd) {
                throw new InvalidOperationException();
            }
            this.r3 = -2;
        }

        protected Object pf() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.pf = this.pf;
            enumerator.aa = this.aa;
            enumerator.r3 = this.r3;
            return enumerator;
        }
    }

    @yl
    private static class SyncStack
    extends Stack {
        private final Stack pf;

        SyncStack(Stack s) {
            this.pf = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.pf;
            synchronized (stack) {
                return this.pf.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.pf;
            synchronized (stack) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.pf;
            synchronized (stack) {
                return Stack.sync((Stack)this.pf.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.pf;
            synchronized (stack) {
                return this.pf.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int index) {
            Stack stack = this.pf;
            synchronized (stack) {
                this.pf.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.pf;
            synchronized (stack) {
                return new Enumerator(this.pf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.pf;
            synchronized (stack) {
                return this.pf.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.pf;
            synchronized (stack) {
                return this.pf.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.pf;
            synchronized (stack) {
                this.pf.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.pf;
            synchronized (stack) {
                return this.pf.toArray(a);
            }
        }
    }
}

