/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.exceptions;

import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.internal.b9.ow;
import com.aspose.slides.internal.m4.aa;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.wo;
import com.aspose.slides.ms.System.yl;

@yl
public class FileNotFoundException
extends IOException {
    private String pf;

    public FileNotFoundException() {
        super("Unable to find the specified file.");
    }

    public FileNotFoundException(String message) {
        super(message);
    }

    public FileNotFoundException(String message, Throwable innerException) {
        super(message, innerException);
    }

    public FileNotFoundException(String message, String fileName) {
        super(message);
        this.pf = fileName;
    }

    public FileNotFoundException(String message, String fileName, Throwable innerException) {
        super(message, innerException);
        this.pf = fileName;
    }

    public String getFileName() {
        return this.pf;
    }

    @Override
    public String getMessage() {
        if (super.getMessage() == null && this.pf != null) {
            String string = wo.pf(aa.ik(), wo.pf(new String[]{"Could not load file or assembly '{0}' or one of", " its dependencies. The system cannot find the", " file specified."}), this.pf);
            return string;
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        ow ow2 = new ow("com.aspose.slides.exceptions.FileNotFoundException");
        ow2.pf(": {0}", new Object[]{this.getMessage()});
        if (this.pf != null && this.pf.length() > 0) {
            ow2.pf(hn.pf);
            ow2.pf("File name: '{0}'", new Object[]{this.pf});
        }
        if (this.getCause() != null) {
            ow2.pf(" ---> {0}", new Object[]{this.getCause().getMessage()});
        }
        if (this.getStackTrace() != null) {
            for (StackTraceElement stackTraceElement : this.getStackTrace()) {
                ow2.pf(hn.pf);
                ow2.pf(stackTraceElement.toString());
            }
        }
        return ow2.toString();
    }
}

