/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;
import com.aspose.slides.ms.System.yn;
import com.aspose.slides.ms.System.zh;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@a9
public class ArrayList
implements IList,
List {
    private Object[] b6;
    private int t8;
    private int sj;
    private static Object[] ma = new Object[0];

    protected int getVersion() {
        return this.sj;
    }

    public ArrayList() {
        this.b6 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.b6 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.b6("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.b6 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.b6 = null;
    }

    private ArrayList(ma array, int index, int count) {
        this.b6 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.ma.b6(array, index, com.aspose.slides.ms.System.ma.b6(this.b6), 0, count);
        this.t8 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.t8) {
            ArrayList.b6("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.b6[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.t8) {
            ArrayList.b6("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.b6[index] = value;
        ++this.sj;
    }

    @Override
    public int size() {
        return this.t8;
    }

    public int getCapacity() {
        return this.b6.length;
    }

    public void setCapacity(int value) {
        if (value < this.t8) {
            ArrayList.b6("Capacity", (Object)value, "Must be more than count.");
        }
        this.b6 = value > 0 ? Arrays.copyOf(this.b6, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void b6(int n) {
        int n10;
        if (n <= this.b6.length) {
            return;
        }
        int n11 = n10 = this.b6.length == 0 ? 4 : this.b6.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void b6(int n, int n10) {
        if (n10 > 0) {
            if (this.t8 + n10 > this.b6.length) {
                int n11;
                int n12 = n11 = this.b6.length > 0 ? this.b6.length << 1 : 1;
                while (n11 < this.t8 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.ma.b6(this.b6, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.ma.b6(this.b6, n, objectArray, n + n10, this.t8 - n);
                this.b6 = objectArray;
            } else {
                com.aspose.slides.ms.System.ma.b6(this.b6, n, this.b6, n + n10, this.t8 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.ma.b6(this.b6, n13, this.b6, n, this.t8 - n13);
            com.aspose.slides.ms.System.ma.b6(this.b6, this.t8 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.b6.length <= this.t8) {
            this.b6(this.t8 + 1);
        }
        this.b6[this.t8] = value;
        ++this.sj;
        return this.t8++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, this.t8);
        this.t8 = 0;
        ++this.sj;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.t8) > -1;
    }

    boolean b6(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.t8 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.t8) {
            ArrayList.b6("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.b6("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.t8 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.ma.b6(this.b6, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.t8 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return yn.b6(this.b6, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.t8) {
            ArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.b6(index, 1);
        this.b6[index] = value;
        ++this.t8;
        ++this.sj;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.t8) {
            ArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.b6.length < this.t8 + n) {
                this.b6(this.t8 + n);
            }
            if (index < this.t8) {
                com.aspose.slides.ms.System.ma.b6(this.b6, index, this.b6, index + n, this.t8 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.ma.b6(this.b6, 0, this.b6, index, index);
                com.aspose.slides.ms.System.ma.b6(this.b6, index + n, this.b6, index << 1, this.t8 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.ma.b6(this.b6), index);
            }
            this.t8 += c.size();
            ++this.sj;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.t8) {
            ArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.b6.length < this.t8 + n) {
                this.b6(this.t8 + n);
            }
            if (index < this.t8) {
                com.aspose.slides.ms.System.ma.b6(this.b6, index, this.b6, index + n, this.t8 - index);
            }
            com.aspose.slides.ms.System.ma.b6(c).copyTo(com.aspose.slides.ms.System.ma.b6(this.b6), index);
            this.t8 += c.length;
            ++this.sj;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.sj;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.t8) {
            ArrayList.b6("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.b6(index, -1);
        --this.t8;
        ++this.sj;
    }

    public void removeRange(int index, int count) {
        ArrayList.b6(index, count, this.t8);
        this.b6(index, -count);
        this.t8 -= count;
        ++this.sj;
    }

    public void reverse() {
        yn.b6(this.b6, 0, this.t8);
        ++this.sj;
    }

    public void reverse(int index, int count) {
        ArrayList.b6(index, count, this.t8);
        yn.b6(this.b6, index, count);
        ++this.sj;
    }

    public void copyTo(ma array) {
        com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6), 0, array, 0, this.t8);
    }

    @Override
    public void copyTo(ma array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.t8);
    }

    public void copyTo(int index, ma array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ma() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.b6(index, count, this.t8);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.t8, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.t8, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return yn.b6(this.b6, 0, this.t8, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return yn.b6(this.b6, 0, this.t8, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return yn.b6(this.b6, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.b6(index, count, this.t8);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.t8) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.ma.b6(this.b6), index);
        ++this.sj;
    }

    public void trimToSize() {
        this.setCapacity(this.t8);
    }

    public void sort() {
        Arrays.sort(this.b6, 0, this.t8, Comparer.Default);
        ++this.sj;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.b6, 0, this.t8, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.b6(index, count, this.t8);
        Arrays.sort(this.b6, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.t8];
        this.copyTo(com.aspose.slides.ms.System.ma.b6(objectArray));
        return objectArray;
    }

    public ma toArray(zh type) {
        ma ma2 = com.aspose.slides.ms.System.ma.b6(type, this.t8);
        this.copyTo(ma2);
        return ma2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.ma.b6(this.b6), 0, this.t8);
    }

    static void b6(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.b6("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.b6("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void b6(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.ma.b6(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.t8, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List b6;
        private int t8;

        @Override
        protected int getVersion() {
            return this.b6 instanceof ArrayList ? ((ArrayList)this.b6).getVersion() : this.t8;
        }

        public ArrayListInternalized(List internal) {
            this.b6 = internal;
            if (internal instanceof ArrayList) {
                this.t8 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.b6.set(index, value);
            ++this.t8;
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.b6.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.b6.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.b6.size(); ++i) {
                this.b6.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.b6.size();
            this.b6.add(value);
            ++this.t8;
            return n;
        }

        @Override
        public void clear() {
            this.b6.clear();
            ++this.t8;
        }

        @Override
        public boolean contains(Object item) {
            return this.b6.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.b6.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.b6.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.b6.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.b6.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.b6.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return yn.b6(this.b6.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.b6.add(index, value);
            ++this.t8;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.b6.add(index++, e);
            }
            ++this.t8;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.b6.add(index++, object);
            }
            ++this.t8;
        }

        @Override
        public void removeItem(Object obj) {
            this.b6.remove(obj);
            ++this.t8;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.b6.remove(index);
            ++this.t8;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.b6.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.b6.remove(index);
            }
            ++this.t8;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.b6.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.b6.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.b6.size() - 1; n < i; ++n, --i) {
                Object e = this.b6.get(n);
                this.b6.set(n, this.b6.get(i));
                this.b6.set(i, e);
            }
            ++this.t8;
        }

        @Override
        public void copyTo(ma array) {
            com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6.toArray()), 0, array, 0, this.b6.size());
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.b6.size());
        }

        @Override
        public void copyTo(int index, ma array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ma() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.b6(index, count, this.b6.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.b6.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return yn.b6(this.b6.toArray(), 0, this.b6.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return yn.b6(this.b6.toArray(), 0, this.b6.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return yn.b6(this.b6.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.b6(index, count, this.b6.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.b6.set(index++, e);
            }
            ++this.t8;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.b6, null);
            ++this.t8;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.b6, comparer);
            ++this.t8;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.b6.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.b6.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.b6.set(i, list.get(i - index));
            }
            ++this.t8;
        }

        @Override
        public Object[] toArray() {
            return this.b6.toArray();
        }

        @Override
        public ma toArray(zh type) {
            ma ma2 = com.aspose.slides.ms.System.ma.b6(type, this.b6.size());
            this.copyTo(ma2);
            return ma2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.b6.size()];
            com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), 0, objectArray, 0, this.b6.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.b6.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.b6.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.t8;
            return this.b6.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.t8;
            return this.b6.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.b6.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.t8;
            return this.b6.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.t8;
            return this.b6.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.t8;
            return this.b6.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.t8;
            return this.b6.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.b6.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.t8;
            return this.b6.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.b6.add(index, element);
            ++this.t8;
        }

        @Override
        public Object remove(int index) {
            ++this.t8;
            return this.b6.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.b6.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.b6.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.b6.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.b6 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.b6 != 0;
        }

        @Override
        public int nextIndex() {
            return this.b6;
        }

        @Override
        public int previousIndex() {
            return this.b6 - 1;
        }

        public Object previous() {
            int n = this.b6 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b6;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.b6 = n;
            this.t8 = n;
            return objectArray[this.t8];
        }

        public void set(Object e) {
            if (this.t8 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).b6[this.t8] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.b6;
                ArrayList.this.add(n, e);
                this.b6 = n + 1;
                this.t8 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int b6;
        int t8 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.b6 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.b6;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b6;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.b6 = n + 1;
            this.t8 = n;
            return objectArray[this.t8];
        }

        @Override
        public void remove() {
            if (this.t8 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.t8);
                this.b6 = this.t8;
                this.t8 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @a9
    private static class ListWrapper
    implements IList {
        protected IList b6;

        public ListWrapper(IList innerList) {
            this.b6 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.b6.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.b6.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.b6.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.b6.addItem(value);
        }

        @Override
        public void clear() {
            this.b6.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.b6.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.b6.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.b6.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.b6.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.b6.removeAt(index);
        }

        @Override
        public void copyTo(ma array, int index) {
            this.b6.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.b6.iterator();
        }
    }

    @a9
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String b6() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.b6());
        }
    }

    @a9
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String b6() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.b6());
        }
    }

    @a9
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object t8;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.t8 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.t8;
            synchronized (object) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int index) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.iterator();
            }
        }
    }

    @a9
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int t8;
        private int sj;
        private int ma;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.t8 = index;
            this.sj = count;
            this.ma = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.sj) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.b6.get_Item(this.t8 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.sj) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.b6.set_Item(this.t8 + index, value);
        }

        @Override
        public int size() {
            this.b6();
            return this.sj;
        }

        @Override
        public int getCapacity() {
            return this.b6.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.sj) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void b6() {
            if (this.ma != this.b6.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.b6();
            this.b6.insertItem(this.t8 + this.sj, value);
            this.ma = this.b6.getVersion();
            return ++this.sj;
        }

        @Override
        public void clear() {
            this.b6();
            this.b6.removeRange(this.t8, this.sj);
            this.sj = 0;
            this.ma = this.b6.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.b6.b6(value, this.t8, this.sj);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.sj - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.sj) {
                RangedArrayList.b6("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.b6("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.sj - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.b6.indexOf(value, this.t8 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.t8;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.sj - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.b6("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.b6("count", (Object)count, "count is negative.");
            }
            if ((n = this.b6.lastIndexOf(value, this.t8 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.t8;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.b6();
            if (index < 0 || index > this.sj) {
                RangedArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.b6.insertItem(this.t8 + index, value);
            ++this.sj;
            this.ma = this.b6.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.b6();
            if (index < 0 || index > this.sj) {
                RangedArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.b6.insertRange(this.t8 + index, c);
            this.sj += c.size();
            this.ma = this.b6.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.b6();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.ma = this.b6.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.b6();
            if (index < 0 || index > this.sj) {
                RangedArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.b6.removeAt(this.t8 + index);
            --this.sj;
            this.ma = this.b6.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.b6();
            RangedArrayList.b6(index, count, this.sj);
            this.b6.removeRange(this.t8 + index, count);
            this.sj -= count;
            this.ma = this.b6.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.sj);
        }

        @Override
        public void reverse(int index, int count) {
            this.b6();
            RangedArrayList.b6(index, count, this.sj);
            this.b6.reverse(this.t8 + index, count);
            this.ma = this.b6.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.b6();
            if (index < 0 || index > this.sj) {
                RangedArrayList.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.b6.setRange(this.t8 + index, c);
            this.ma = this.b6.getVersion();
        }

        @Override
        public void copyTo(ma array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(ma array, int index) {
            this.copyTo(0, array, index, this.sj);
        }

        @Override
        public void copyTo(int index, ma array, int arrayIndex, int count) {
            RangedArrayList.b6(index, count, this.sj);
            this.b6.copyTo(this.t8 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.sj);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.b6(index, count, this.sj);
            return this.b6.iterator(this.t8 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.b6();
            this.b6.insertRange(this.sj, c);
            this.sj += c.size();
            this.ma = this.b6.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.sj, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.sj, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.b6(index, count, this.sj);
            return this.b6.binarySearch(this.t8 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.b6.deepClone(), this.t8, this.sj);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.b6(index, count, this.sj);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.sj, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.b6();
            RangedArrayList.b6(index, count, this.sj);
            this.b6.sort(this.t8 + index, count, comparer);
            this.ma = this.b6.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.sj];
            this.b6.copyTo(this.t8, com.aspose.slides.ms.System.ma.b6(objectArray), 0, this.sj);
            return objectArray;
        }

        @Override
        public ma toArray(zh elementType) {
            ma ma2 = com.aspose.slides.ms.System.ma.b6(elementType, this.sj);
            this.b6.copyTo(this.t8, ma2, 0, this.sj);
            return ma2;
        }
    }

    @a9
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String b6() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.b6());
        }
    }

    @a9
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String b6() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.b6());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.b6());
        }
    }

    @a9
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object t8;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.t8 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.t8;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.t8;
            synchronized (object) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.t8;
            synchronized (object) {
                this.b6.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int index) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, ma array, int arrayIndex, int count) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.t8;
            synchronized (object) {
                this.b6.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.t8;
            synchronized (object) {
                this.b6.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.t8;
            synchronized (object) {
                this.b6.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ma toArray(zh elementType) {
            Object object = this.t8;
            synchronized (object) {
                return this.b6.toArray(elementType);
            }
        }
    }

    @a9
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList b6;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.b6 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.b6.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public int getCapacity() {
            return this.b6.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.b6.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.b6.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.b6.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.b6.addItem(value);
        }

        @Override
        public void clear() {
            this.b6.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.b6.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.b6.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.b6.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.b6.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.b6.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.b6.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.b6.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.b6.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.b6.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.b6.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.b6.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.b6.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.b6.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.b6.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.b6.setRange(index, c);
        }

        @Override
        public void copyTo(ma array) {
            this.b6.copyTo(array);
        }

        @Override
        public void copyTo(ma array, int index) {
            this.b6.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ma array, int arrayIndex, int count) {
            this.b6.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.b6.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.b6.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.b6.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.b6.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.b6.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.b6.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.b6.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.b6.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.b6.trimToSize();
        }

        @Override
        public void sort() {
            this.b6.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.b6.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.b6.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.b6.toArray();
        }

        @Override
        public ma toArray(zh elementType) {
            return this.b6.toArray(elementType);
        }
    }

    @a9
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList b6;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.b6 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.b6.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public int getCapacity() {
            return this.b6.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.b6.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.b6.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.b6.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.b6.addItem(value);
        }

        @Override
        public void clear() {
            this.b6.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.b6.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.b6.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.b6.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.b6.size()) {
                ArrayListAdapter.b6("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.b6("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.b6.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.b6.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.b6.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.b6.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.b6("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.b6("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.b6("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.b6.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.b6.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.b6.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.b6.size()) {
                ArrayListAdapter.b6("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.b6.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.b6.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.b6.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            for (int i = 0; i < count; ++i) {
                this.b6.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.b6.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.b6.get_Item(i + index);
                this.b6.set_Item(i + index, this.b6.get_Item(index + count - i + index - 1));
                this.b6.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.b6.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.b6.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(ma array) {
            this.b6.copyTo(array, 0);
        }

        @Override
        public void copyTo(ma array, int index) {
            this.b6.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ma array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.b6("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.b6("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.b6("index", (Object)index, "Can't be less than zero.");
            }
            if (array.ma() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.zn() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.b6.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.sj(this.b6.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.b6.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            return new EnumeratorWithRange(this.b6.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.b6.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.b6.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.b6.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.b6);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.b6.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.b6(index, count, this.b6.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.b6(this.b6, index, index + count - 1, comparer);
        }

        private static void b6(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void b6(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.b6(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.b6(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.b6(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.b6(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.b6(iList, n12, n13);
            }
            ArrayListAdapter.b6(iList, n10 - 1, n12);
            ArrayListAdapter.b6(iList, n, n12 - 1, comparator);
            ArrayListAdapter.b6(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.b6.size()];
            this.b6.copyTo(com.aspose.slides.ms.System.ma.b6(objectArray), 0);
            return objectArray;
        }

        @Override
        public ma toArray(zh elementType) {
            ma ma2 = com.aspose.slides.ms.System.ma.b6(elementType, this.b6.size());
            this.b6.copyTo(ma2, 0);
            return ma2;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        n0,
        Cloneable {
            private int b6;
            private int t8;
            private int sj;
            private IEnumerator ma;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.t8 = 0;
                this.b6 = index;
                this.sj = count;
                this.ma = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.b6();
            }

            @Override
            public Object next() {
                return this.ma.next();
            }

            @Override
            public boolean hasNext() {
                if (this.t8 >= this.sj) {
                    return false;
                }
                ++this.t8;
                return this.ma.hasNext();
            }

            @Override
            public void reset() {
                this.t8 = 0;
                this.ma.reset();
                for (int i = 0; i < this.b6; ++i) {
                    this.ma.hasNext();
                }
            }

            protected Object b6() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.b6 = this.b6;
                enumeratorWithRange.t8 = this.t8;
                enumeratorWithRange.sj = this.sj;
                enumeratorWithRange.ma = this.ma;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    n0,
    Cloneable {
        private ArrayList t8;
        private Object sj;
        private int ma;
        private int zn;
        static Object b6 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.t8 = list;
            this.ma = -1;
            this.zn = list.getVersion();
            this.sj = b6;
        }

        @Override
        public Object deepClone() {
            return this.b6();
        }

        @Override
        public boolean hasNext() {
            if (this.zn != this.t8.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.ma < this.t8.size()) {
                this.sj = this.t8.get_Item(this.ma);
                return true;
            }
            this.sj = b6;
            return false;
        }

        @Override
        public Object next() {
            if (this.sj == b6) {
                if (this.ma == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.sj;
        }

        @Override
        public void reset() {
            if (this.zn != this.t8.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.sj = b6;
            this.ma = -1;
        }

        protected Object b6() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.t8 = this.t8;
            simpleEnumerator.sj = this.sj;
            simpleEnumerator.ma = this.ma;
            simpleEnumerator.zn = this.zn;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    n0,
    Cloneable {
        private Object b6;
        private ArrayList t8;
        private int sj;
        private int ma;
        private int zn;
        private int yc;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.b6();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.t8 = list;
            this.ma = index;
            this.zn = count;
            this.sj = this.ma - 1;
            this.b6 = null;
            this.yc = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.sj == this.ma - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.b6;
        }

        @Override
        public boolean hasNext() {
            if (this.t8.getVersion() != this.yc) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.sj;
            if (this.sj - this.ma < this.zn) {
                this.b6 = this.t8.get_Item(this.sj);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.b6 = null;
            this.sj = this.ma - 1;
        }

        protected Object b6() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.b6 = this.b6;
            arrayListEnumerator.t8 = this.t8;
            arrayListEnumerator.sj = this.sj;
            arrayListEnumerator.ma = this.ma;
            arrayListEnumerator.zn = this.zn;
            arrayListEnumerator.yc = this.yc;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

