/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;

@a9
public final class BitArray
implements ICollection,
n0 {
    private int[] b6;
    private int t8;
    private int sj = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.t8 = bits.t8;
        this.b6 = new int[(this.t8 + 31) / 32];
        if (this.b6.length == 1) {
            this.b6[0] = bits.b6[0];
        } else {
            ma.b6(bits.b6, 0, this.b6, 0, this.b6.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.t8 = values.length;
        this.b6 = new int[(this.t8 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.t8 = bytes.length * 8;
        this.b6 = new int[(this.t8 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.b6(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.t8 = n * 32;
        this.b6 = new int[n];
        ma.b6(values, 0, this.b6, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.t8 = length;
        this.b6 = new int[(this.t8 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.b6.length; ++i) {
                this.b6[i] = -1;
            }
        }
    }

    private byte b6(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.b6[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void b6(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.b6[n12] = this.b6[n12] & ~(255 << n11);
        int n13 = n10;
        this.b6[n13] = this.b6[n13] | (by2 & 0xFF) << n11;
        ++this.sj;
    }

    private void t8(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.t8 != this.t8) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.t8;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.t8;
    }

    public void setLength(int value) {
        if (this.t8 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.t8) {
            int n = (value + 31) / 32;
            int n10 = (this.t8 + 31) / 32;
            if (n > this.b6.length) {
                int[] nArray = new int[n];
                ma.b6(this.b6, 0, nArray, 0, this.b6.length);
                this.b6 = nArray;
            } else {
                ma.b6(ma.b6((Object)this.b6), n10, n - n10);
            }
            int n11 = this.t8 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.b6[n12] = this.b6[n12] & (1 << n11) - 1;
            }
        }
        this.t8 = value;
        ++this.sj;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(ma array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ma() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.zn() && this.t8 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = ma.b6(array);
        if (object instanceof Boolean[]) {
            if (array.zn() - index < this.t8) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.t8; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.zn() - index < this.t8) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.t8; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.t8 + 7) / 8;
            if (array.zn() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.b6(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.t8 + 7) / 8;
            if (array.zn() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.b6(i);
            }
        } else if (object instanceof Integer[]) {
            ma.b6(ma.b6((Object)this.b6), 0, array, index, (this.t8 + 31) / 32);
        } else if (object instanceof int[]) {
            ma.b6(ma.b6((Object)this.b6), 0, array, index, (this.t8 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.t8 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.b6[i] = ~this.b6[i];
        }
        ++this.sj;
        return this;
    }

    public BitArray and(BitArray value) {
        this.t8(value);
        int n = (this.t8 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.b6[n10] = this.b6[n10] & value.b6[i];
        }
        ++this.sj;
        return this;
    }

    public BitArray or(BitArray value) {
        this.t8(value);
        int n = (this.t8 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.b6[n10] = this.b6[n10] | value.b6[i];
        }
        ++this.sj;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.t8(value);
        int n = (this.t8 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.b6[n10] = this.b6[n10] ^ value.b6[i];
        }
        ++this.sj;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.t8) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.b6[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.t8) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.b6[n] = this.b6[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.b6[n] = this.b6[n] & ~(1 << (index & 0x1F));
        }
        ++this.sj;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.b6.length; ++i) {
                this.b6[i] = -1;
            }
        } else {
            ma.b6(ma.b6((Object)this.b6), 0, this.b6.length);
        }
        ++this.sj;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @a9
    private static class BitArrayEnumerator
    implements IEnumerator,
    n0,
    Cloneable {
        private BitArray b6;
        private boolean t8;
        private int sj;
        private int ma;

        @Override
        public Object deepClone() {
            return this.b6();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.sj = -1;
            this.b6 = ba2;
            this.ma = ba2.sj;
        }

        @Override
        public Object next() {
            if (this.sj == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.sj >= this.b6.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.t8;
        }

        @Override
        public boolean hasNext() {
            this.t8();
            if (this.sj < this.b6.size() - 1) {
                this.t8 = this.b6.get_Item(++this.sj);
                return true;
            }
            this.sj = this.b6.size();
            return false;
        }

        @Override
        public void reset() {
            this.t8();
            this.sj = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void t8() {
            if (this.ma != this.b6.sj) {
                throw new InvalidOperationException();
            }
        }

        protected Object b6() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.b6 = this.b6;
            bitArrayEnumerator.t8 = this.t8;
            bitArrayEnumerator.sj = this.sj;
            bitArrayEnumerator.ma = this.ma;
            return bitArrayEnumerator;
        }
    }
}

