/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.d1.dd;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.fx;
import com.aspose.slides.ms.System.h7;
import com.aspose.slides.ms.System.ky;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.p3;
import com.aspose.slides.ms.System.yn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@a9
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] b6;
    private int t8;
    private int sj;
    private final Object ma = new Object();
    static Object[] yc = new Object[0];

    public List() {
        this.b6 = yc;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.b6 = yc;
        this.b6(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.b6 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.b6 = data;
        this.t8 = size;
    }

    protected int getVersion() {
        return this.sj;
    }

    @Override
    public void addItem(T item) {
        if (this.t8 == this.b6.length) {
            this.b6(1);
        }
        this.b6[this.t8++] = item;
        ++this.sj;
    }

    private void b6(int n) {
        int n10 = this.t8 + n;
        if (n10 > this.b6.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void b6(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void b6(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.b6(new List<T>(collection));
        ++this.sj;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.sj;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return yn.b6(this.b6, 0, this.t8, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return yn.b6(this.b6, 0, this.t8, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.b6(index, count);
        return yn.b6(this.b6, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, this.b6.length);
        this.t8 = 0;
        ++this.sj;
    }

    public <TOutput> List<TOutput> convertAll(ky<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.t8);
        for (int i = 0; i < this.t8; ++i) {
            list.b6[i] = converter.b6(this.b6[i]);
        }
        list.t8 = this.t8;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, array, 0, this.t8);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, array, arrayIndex, this.t8);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.b6(index, count);
        com.aspose.slides.ms.System.ma.b6(this.b6, index, array, arrayIndex, count);
    }

    public boolean exists(fx<T> match) {
        List.b6(match);
        return this.b6(0, this.t8, match) != -1;
    }

    public T find(fx<T> match) {
        List.b6(match);
        int n = this.b6(0, this.t8, match);
        return (T)(n != -1 ? this.b6[n] : null);
    }

    static <T> void b6(fx<T> fx2) {
        if (fx2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(fx<T> match) {
        List.b6(match);
        return this.t8(match);
    }

    private List<T> t8(fx<T> fx2) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.t8; ++i) {
            if (!fx2.invoke(this.b6[i])) continue;
            list.addItem(this.b6[i]);
        }
        return list;
    }

    public int findIndex(fx<T> match) {
        List.b6(match);
        return this.b6(0, this.t8, match);
    }

    public int findIndex(int startIndex, fx<T> match) {
        List.b6(match);
        this.t8(startIndex);
        return this.b6(startIndex, this.t8 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, fx<T> match) {
        List.b6(match);
        this.b6(startIndex, count);
        return this.b6(startIndex, count, match);
    }

    private int b6(int n, int n10, fx<T> fx2) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!fx2.invoke(this.b6[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(fx<T> match) {
        List.b6(match);
        int n = this.t8(0, this.t8, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(fx<T> match) {
        List.b6(match);
        return this.t8(0, this.t8, match);
    }

    public int findLastIndex(int startIndex, fx<T> match) {
        List.b6(match);
        this.t8(startIndex);
        return this.t8(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, fx<T> match) {
        List.b6(match);
        int n = startIndex - count + 1;
        this.b6(n, count);
        return this.t8(n, count, match);
    }

    private int t8(int n, int n10, fx<T> fx2) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!fx2.invoke(this.b6[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(b6<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.t8; ++i) {
            action.invoke(this.b6[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.b6(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.ma.b6(this.b6, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.ma.b6(this.b6, item, 0, this.t8);
    }

    public int indexOf(T item, int index) {
        this.t8(index);
        return com.aspose.slides.ms.System.ma.b6(this.b6, item, index, this.t8 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.ma.b6(this.b6, item, index, count);
    }

    private void t8(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.t8) {
            com.aspose.slides.ms.System.ma.b6(this.b6, n, this.b6, n + n10, this.t8 - n);
        }
        this.t8 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.ma.b6(this.b6, this.t8, -n10);
        }
    }

    private void t8(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.t8(index);
        if (this.t8 == this.b6.length) {
            this.b6(1);
        }
        this.t8(index, 1);
        this.b6[index] = item;
        ++this.sj;
    }

    void sj(int n) {
        Object[] objectArray = new Object[this.t8];
        this.copyToTArray(objectArray, 0);
        this.b6(this.t8);
        this.t8(n, objectArray.length);
        com.aspose.slides.ms.System.ma.b6(objectArray, 0, this.b6, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.t8(index);
        if (collection == this) {
            this.sj(index);
        } else {
            this.b6(index, collection);
        }
        ++this.sj;
    }

    private void b6(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.t8 == 0) {
            return -1;
        }
        return yn.b6(this.b6, item, this.t8 - 1, this.t8);
    }

    public int lastIndexOf(T item, int index) {
        this.t8(index);
        return yn.b6(this.b6, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return yn.b6(this.b6, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(fx<T> match) {
        List.b6(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.t8 && !match.invoke(this.b6[n]); ++n) {
        }
        if (n == this.t8) {
            return 0;
        }
        ++this.sj;
        for (n10 = n + 1; n10 < this.t8; ++n10) {
            if (match.invoke(this.b6[n10])) continue;
            this.b6[n++] = this.b6[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.ma.b6(this.b6, n, n10 - n);
        }
        this.t8 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.t8(index, -1);
        com.aspose.slides.ms.System.ma.b6(this.b6, this.t8, 1);
        ++this.sj;
    }

    public void removeRange(int index, int count) {
        this.b6(index, count);
        if (count > 0) {
            this.t8(index, -count);
            com.aspose.slides.ms.System.ma.b6(this.b6, this.t8, count);
            ++this.sj;
        }
    }

    public void reverse() {
        yn.b6(this.b6, 0, this.t8);
        ++this.sj;
    }

    public void reverse(int index, int count) {
        this.b6(index, count);
        yn.b6(this.b6, index, count);
        ++this.sj;
    }

    public void sort() {
        Arrays.sort(this.b6, 0, this.t8);
        ++this.sj;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.b6, 0, this.t8, comparer);
        ++this.sj;
    }

    @Override
    public void sort(p3<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.b6, 0, this.t8, new yn.b6<T>(comparison));
        ++this.sj;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.b6(index, count);
        Arrays.sort(this.b6, index, index + count, comparer);
        ++this.sj;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.t8) {
            return Arrays.copyOf(this.b6, this.t8, a.getClass());
        }
        System.arraycopy(this.b6, 0, a, 0, this.t8);
        if (a.length > this.t8) {
            a[this.t8] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.t8);
    }

    public boolean trueForAll(fx<T> match) {
        List.b6(match);
        for (int i = 0; i < this.t8; ++i) {
            if (match.invoke(this.b6[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.b6.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.b6 = Arrays.copyOf(this.b6, value);
    }

    @Override
    public int size() {
        return this.t8;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.t8 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.b6[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.t8(index);
        if ((long)index == (long)this.t8) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b6[index] = value;
        ++this.sj;
    }

    public void copyTo(ma array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ma() > 1 || array.t8(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6), 0, array, arrayIndex, this.t8);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.ma;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.t8 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.t8; ++i) {
                if (this.b6[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.t8; ++i) {
            if (!this.b6[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.t8; ++i) {
                if (this.b6[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.t8; ++i) {
            if (!this.b6[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.t8];
        System.arraycopy(this.b6, 0, objectArray, 0, this.t8);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.t8;
        this.addItem(t);
        return n != this.t8;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.t8;
        this.removeItem(o);
        return n != this.t8;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.t8; ++i) {
                if (this.b6[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.t8; ++i) {
            if (!o.equals(this.b6[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> b6;
        private int t8;

        public ListInternalized() {
            this.b6 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.b6 = list;
        }

        @Override
        protected int getVersion() {
            return this.t8;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.b6(collection);
            ++this.t8;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.t8;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return yn.b6(this.b6.toArray(), 0, this.b6.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return yn.b6(this.b6.toArray(), 0, this.b6.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.b6(index, count);
            return yn.b6(this.b6.toArray(), index, count, item, comparer);
        }

        @Override
        private void b6(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(ky<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.b6.size());
            for (int i = 0; i < this.b6.size(); ++i) {
                list.b6[i] = converter.b6(this.get_Item(i));
            }
            list.t8 = this.b6.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), 0, array, 0, this.b6.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), 0, array, arrayIndex, this.b6.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.b6(index, count);
            com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(fx<T> match) {
            ListInternalized.t8(match);
            return this.b6(0, this.b6.size(), match) != -1;
        }

        @Override
        private int b6(int n, int n10, fx<T> fx2) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!fx2.invoke(this.b6.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void t8(fx<T> fx2) {
            if (fx2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(fx<T> match) {
            ListInternalized.t8(match);
            int n = this.b6(0, this.b6.size(), match);
            return n != -1 ? (T)this.b6.get(n) : null;
        }

        @Override
        public List<T> findAll(fx<T> match) {
            ListInternalized.t8(match);
            return this.sj(match);
        }

        private List<T> sj(fx<T> fx2) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!fx2.invoke(this.b6.get(i))) continue;
                list.addItem(this.b6.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(fx<T> match) {
            ListInternalized.t8(match);
            return this.b6(0, this.b6.size(), match);
        }

        @Override
        public int findIndex(int startIndex, fx<T> match) {
            ListInternalized.t8(match);
            this.b6(startIndex);
            return this.b6(startIndex, this.b6.size() - startIndex, match);
        }

        @Override
        private void b6(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, fx<T> match) {
            ListInternalized.t8(match);
            this.b6(startIndex, count);
            return this.b6(startIndex, count, match);
        }

        @Override
        public T findLast(fx<T> match) {
            ListInternalized.t8(match);
            int n = this.t8(0, this.b6.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int t8(int n, int n10, fx<T> fx2) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!fx2.invoke(this.b6.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(fx<T> match) {
            ListInternalized.t8(match);
            return this.t8(0, this.b6.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, fx<T> match) {
            ListInternalized.t8(match);
            this.b6(startIndex);
            return this.t8(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, fx<T> match) {
            ListInternalized.t8(match);
            int n = startIndex - count + 1;
            this.b6(n, count);
            return this.t8(n, count, match);
        }

        @Override
        public void forEach(b6<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.b6.size(); ++i) {
                action.invoke(this.b6.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.b6(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.b6.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.b6(index);
            return com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), item, index, this.b6.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.ma.b6(this.b6.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.b6.size() == 0) {
                return -1;
            }
            return yn.b6(this.b6.toArray(), item, this.b6.size() - 1, this.b6.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.b6(index);
            return yn.b6(this.b6.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return yn.b6(this.b6.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.b6.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.b6.size());
        }

        @Override
        public boolean trueForAll(fx<T> match) {
            ListInternalized.t8(match);
            for (int i = 0; i < this.b6.size(); ++i) {
                if (match.invoke(this.b6.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.b6.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.b6.size(); ++i) {
                this.b6.add(null);
            }
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public T get_Item(int index) {
            return this.b6.get(index);
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ma() > 1 || array.t8(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6.toArray()), 0, array, arrayIndex, this.b6.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.b6.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.b6.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.b6.size(); ++i) {
                    if (this.b6.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.b6.size(); ++i) {
                if (!this.b6.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.b6.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.t8;
            return this.b6.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.t8;
            return this.b6.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.b6.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.t8;
            return this.b6.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.t8;
            return this.b6.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.t8;
            return this.b6.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.t8;
            return this.b6.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.b6.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.t8;
            return this.b6.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.t8;
            this.b6.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.t8;
            return this.b6.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.b6.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.b6.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.b6.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.b6.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.b6.add(item);
            ++this.t8;
        }

        @Override
        public void clear() {
            this.b6.clear();
            ++this.t8;
        }

        @Override
        public void insertItem(int index, T item) {
            this.b6.add(index, item);
            ++this.t8;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.b6.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.b6.add(n++, e);
                }
            }
            ++this.t8;
        }

        @Override
        public int removeAll(fx<T> match) {
            ListInternalized.t8(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.b6.size() && !match.invoke(this.b6.get(n)); ++n) {
            }
            if (n == this.b6.size()) {
                return 0;
            }
            ++this.t8;
            for (n10 = n + 1; n10 < this.b6.size(); ++n10) {
                if (match.invoke(this.b6.get(n10))) continue;
                this.b6.set(n++, this.b6.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.b6.remove(this.b6.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.b6.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b6.remove(index);
            ++this.t8;
        }

        @Override
        public void removeRange(int index, int count) {
            this.b6(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.b6.remove(index);
                }
                ++this.t8;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.b6(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.b6.get(n);
                this.b6.set(n, this.b6.get(i));
                this.b6.set(i, t);
            }
            ++this.t8;
        }

        @Override
        public void sort() {
            Collections.sort(this.b6, null);
            ++this.t8;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.b6, comparer);
            ++this.t8;
        }

        @Override
        public void sort(final p3<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.b6, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.b6(o12, o22);
                }
            });
            ++this.t8;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.b6(index, count);
            java.util.List<T> list = this.b6.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.b6.set(index + i, list.get(i));
            }
            ++this.t8;
        }

        @Override
        public void set_Item(int index, T value) {
            this.b6(index);
            if ((long)index == (long)this.b6.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b6.set(index, value);
            ++this.t8;
        }

        @Override
        private void b6(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @a9
    public static class EnumeratorJava<T>
    extends dd<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> t8 = new List();
        private int sj;
        private int ma;
        private T zn;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.t8 = l;
            this.ma = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void b6() {
            if (this.ma != this.t8.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.sj < 0 || this.sj >= this.t8.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.ma != this.t8.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.zn = this.t8.get_Item(this.sj++);
            return this.zn;
        }

        @Override
        public boolean hasNext() {
            if (this.ma == this.t8.getVersion()) {
                if (this.sj < 0) {
                    return false;
                }
                return this.sj < this.t8.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.b6();
            this.sj = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.t8 = this.t8;
            that.sj = this.sj;
            that.ma = this.ma;
            that.zn = this.zn;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean b6(EnumeratorJava enumeratorJava) {
            return h7.b6(enumeratorJava.t8, this.t8) && enumeratorJava.sj == this.sj && enumeratorJava.ma == this.ma && h7.b6(enumeratorJava.zn, this.zn);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (h7.t8(null, obj)) {
                return false;
            }
            if (h7.t8(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.b6((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.t8 != null ? this.t8.hashCode() : 0;
            n = 31 * n + this.sj;
            n = 31 * n + this.ma;
            n = 31 * n + (this.zn != null ? this.zn.hashCode() : 0);
            return n;
        }
    }

    @a9
    public static class Enumerator<T>
    extends dd<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> t8 = new List();
        private int sj;
        private int ma;
        private T zn;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.t8 = l;
            this.ma = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void b6() {
            if (this.ma != this.t8.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ma == this.t8.getVersion()) {
                if (this.sj < 0) {
                    return false;
                }
                if (this.sj < this.t8.size()) {
                    this.zn = this.t8.get_Item(this.sj++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.sj = this.t8.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.b6();
            this.sj = 0;
        }

        @Override
        public T next() {
            if (this.sj < 0 || this.sj >= this.t8.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.zn;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.t8 = this.t8;
            that.sj = this.sj;
            that.ma = this.ma;
            that.zn = this.zn;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean b6(Enumerator enumerator) {
            return h7.b6(enumerator.t8, this.t8) && enumerator.sj == this.sj && enumerator.ma == this.ma && h7.b6(enumerator.zn, this.zn);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (h7.t8(null, obj)) {
                return false;
            }
            if (h7.t8(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.b6((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.t8 != null ? this.t8.hashCode() : 0;
            n = 31 * n + this.sj;
            n = 31 * n + this.ma;
            n = 31 * n + (this.zn != null ? this.zn.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.b6 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.b6 != 0;
        }

        @Override
        public int nextIndex() {
            return this.b6;
        }

        @Override
        public int previousIndex() {
            return this.b6 - 1;
        }

        public T previous() {
            int n = this.b6 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b6;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.b6 = n;
            this.t8 = n;
            return objectArray[this.t8];
        }

        public void set(T e) {
            if (this.t8 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.t8, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.b6;
                List.this.add(n, e);
                this.b6 = n + 1;
                this.t8 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int b6;
        int t8 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.b6 != List.this.t8;
        }

        @Override
        public T next() {
            int n = this.b6;
            if (n >= List.this.t8) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b6;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.b6 = n + 1;
            this.t8 = n;
            return (T)objectArray[this.t8];
        }

        @Override
        public void remove() {
            if (this.t8 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.t8);
                this.b6 = this.t8;
                this.t8 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

