/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.d1.dd;
import com.aspose.slides.internal.d1.sj;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.h7;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.yn;
import java.util.Arrays;

@a9
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] b6;
    private int t8;
    private int sj;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.b6 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.t8 = collection.size();
            this.b6 = new Object[this.t8];
            collection.copyToTArray(this.b6, 0);
        }
    }

    public void clear() {
        if (this.b6 != null) {
            ma.b6(this.b6, 0, this.b6.length);
        }
        this.t8 = 0;
        ++this.sj;
    }

    public boolean contains(T item) {
        return this.b6 != null && ma.b6(this.b6, item, 0, this.t8) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.t8 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.b6 != null) {
            ma.b6(this.b6, 0, array, arrayIndex, this.t8);
            yn.b6(array, arrayIndex, this.t8);
        }
    }

    public T peek() {
        if (this.t8 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.b6[this.t8 - 1];
    }

    public T pop() {
        if (this.t8 == 0) {
            throw new InvalidOperationException();
        }
        ++this.sj;
        Object object = this.b6[--this.t8];
        this.b6[this.t8] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.b6 == null || this.t8 == this.b6.length) {
            if (this.b6 == null) {
                this.b6 = new Object[16];
            }
            this.b6 = Arrays.copyOf(this.b6, this.t8 == 0 ? 16 : 2 * this.t8);
        }
        ++this.sj;
        this.b6[this.t8++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.t8) {
            this.copyTo(ma.b6(array), 0);
            return array;
        }
        ma ma2 = ma.b6(com.aspose.slides.internal.d1.sj.b6(array.getClass().getComponentType()), this.t8);
        this.copyTo(ma2, 0);
        return (Object[])ma.b6(ma2);
    }

    public void trimExcess() {
        if (this.b6 != null && (double)this.t8 < (double)this.b6.length * 0.9) {
            this.b6 = Arrays.copyOf(this.b6, this.t8);
        }
        ++this.sj;
    }

    @Override
    public int size() {
        return this.t8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ma dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.b6 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.t8) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.t8 - idx > dest.zn()) {
                    throw new ArgumentException("idx");
                }
                ma.b6(ma.b6(this.b6), 0, dest, idx, this.t8);
                ma.t8(dest, idx, this.t8);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @a9
    public static class Enumerator<T>
    extends dd<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> t8;
        private int sj;
        private int ma;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.t8 = t;
            this.sj = -2;
            this.ma = ((Stack)t).sj;
        }

        @Override
        public void dispose() {
            this.sj = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.ma != ((Stack)this.t8).sj) {
                throw new IllegalStateException();
            }
            if (this.sj == -2) {
                this.sj = ((Stack)this.t8).t8;
            }
            return this.sj != -1 && --this.sj != -1;
        }

        @Override
        public T next() {
            if (this.sj < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.t8).b6[this.sj];
        }

        @Override
        public void reset() {
            if (this.ma != ((Stack)this.t8).sj) {
                throw new IllegalStateException();
            }
            this.sj = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.t8 = this.t8;
            that.sj = this.sj;
            that.ma = this.ma;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean b6(Enumerator enumerator) {
            return h7.b6(enumerator.t8, this.t8) && enumerator.sj == this.sj && enumerator.ma == this.ma;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (h7.t8(null, obj)) {
                return false;
            }
            if (h7.t8(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.b6((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.t8 != null ? this.t8.hashCode() : 0;
            n = 31 * n + this.sj;
            n = 31 * n + this.ma;
            return n;
        }
    }
}

