/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.b5.b6;
import com.aspose.slides.internal.b5.t8;
import com.aspose.slides.internal.d1.dd;
import com.aspose.slides.internal.d1.sj;
import com.aspose.slides.internal.d1.yc;
import com.aspose.slides.internal.jd.g1;
import com.aspose.slides.internal.jd.mr;
import com.aspose.slides.internal.jd.ol;
import com.aspose.slides.internal.jd.y1;
import com.aspose.slides.internal.p2.nn;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.h7;
import com.aspose.slides.ms.System.k8;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@a9
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
com.aspose.slides.internal.jd.dd,
ol,
n0,
Map {
    private IGenericEqualityComparer b6;
    private final Object t8 = new Object();
    private Bucket[] sj;
    private int ma;
    private volatile boolean zn;
    private ICollection yc;
    private float dd;
    private int p6;
    private y1 nn;
    private int ol;
    private ICollection dt;
    private volatile int nm;
    private static final yc ng = new yc("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", k8.b6("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.dd = 0.72f * loadFactor;
        double d = (float)capacity / this.dd;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.b5.b6.b6((int)d) : 11;
        this.sj = this.t8(n);
        this.p6 = (int)(this.dd * (float)n);
        this.zn = false;
    }

    protected Hashtable(y1 info, mr context) {
        this.nn = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.b6 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.b6 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.b6(key, value, true);
    }

    @Override
    public void clear() {
        if (this.ma != 0) {
            this.zn = true;
            for (int i = 0; i < this.sj.length; ++i) {
                this.sj[i].sj = 0;
                this.sj[i].b6 = null;
                this.sj[i].t8 = null;
            }
            this.ma = 0;
            this.ol = 0;
            this.ma();
            this.zn = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.sj;
        Hashtable hashtable = new Hashtable(this.ma, this.b6);
        hashtable.nm = this.nm;
        hashtable.dd = this.dd;
        hashtable.ma = 0;
        int n = this.sj.length;
        while (n > 0) {
            Object object = bucketArray[--n].b6;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].t8);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.sj;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.b6(key, this.sj.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.sj.length);
        do {
            bucketArray[n10].b6(bucket);
            if (bucket.b6 == null) {
                return false;
            }
            if ((long)(bucket.sj & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.b6, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.sj.length);
        } while (bucket.sj < 0 && ++n < this.sj.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.sj.length;
            while (--n >= 0) {
                if (this.sj[n].b6 == null || this.sj[n].b6 == this.sj || this.sj[n].t8 != null) continue;
                return true;
            }
        } else {
            int n = this.sj.length;
            while (--n >= 0) {
                Object object = this.sj[n].t8;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void sj(ma ma2, int n) {
        Bucket[] bucketArray = this.sj;
        int n10 = this.sj.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].b6;
            if (object == null || object == this.sj) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].t8);
            ma2.sj(dictionaryEntry.Clone(), n++);
        }
    }

    void b6(ma ma2, int n) {
        Bucket[] bucketArray = this.sj;
        int n10 = this.sj.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].b6;
            if (object == null || object == this.sj) continue;
            ma2.sj(object, n++);
        }
    }

    @Override
    public void copyTo(ma array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.ma() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.zn() - arrayIndex < this.ma) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.sj(array, arrayIndex);
    }

    void t8(ma ma2, int n) {
        Bucket[] bucketArray = this.sj;
        int n10 = this.sj.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].b6;
            if (object == null || object == this.sj) continue;
            ma2.sj(bucketArray[n10].t8, n++);
        }
    }

    private void t8() {
        int n = com.aspose.slides.internal.b5.b6.b6(this.sj.length * 2);
        this.b6(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.b6 != null) {
            return this.b6.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(y1 info, mr context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.b6("LoadFactor", this.dd);
        info.b6("Version", this.nm);
        if (this.b6 == null) {
            info.b6("Comparer", null, com.aspose.slides.internal.d1.sj.b6(Comparator.class));
            info.b6("HashCodeProvider", null, com.aspose.slides.internal.d1.sj.b6(IHashCodeProvider.class));
        } else if (this.b6 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.d1.sj.b6(this.b6, CompatibleComparer.class);
            info.b6("Comparer", objectArray.b6(), com.aspose.slides.internal.d1.sj.b6(Comparator.class));
            info.b6("HashCodeProvider", objectArray.t8(), com.aspose.slides.internal.d1.sj.b6(IHashCodeProvider.class));
        } else {
            info.b6("KeyComparer", this.b6, com.aspose.slides.internal.d1.sj.b6(IGenericEqualityComparer.class));
        }
        info.b6("HashSize", this.sj.length);
        objectArray = new Object[this.ma];
        Object[] objectArray2 = new Object[this.ma];
        this.b6(com.aspose.slides.ms.System.ma.b6(objectArray), 0);
        this.t8(com.aspose.slides.ms.System.ma.b6(objectArray2), 0);
        info.b6("Keys", objectArray, com.aspose.slides.internal.d1.sj.b6(Object[].class));
        info.b6("Values", objectArray2, com.aspose.slides.internal.d1.sj.b6(Object[].class));
    }

    private long b6(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void b6(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.ma >= this.p6) {
                this.t8();
            } else if (this.ol > this.p6 && this.ma > 100) {
                this.sj();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.b6(object, this.sj.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.sj.length);
            do {
                if (n10 == -1 && this.sj[n11].b6 == this.sj && this.sj[n11].sj < 0) {
                    n10 = n11;
                }
                if (this.sj[n11].b6 == null || this.sj[n11].b6 == this.sj && ((long)this.sj[n11].sj & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.zn = true;
                    this.sj[n11].t8 = object2;
                    this.sj[n11].b6 = object;
                    this.sj[n11].sj |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.ma;
                    this.ma();
                    this.zn = false;
                    break block12;
                }
                if ((long)(this.sj[n11].sj & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.sj[n11].b6, object)) {
                    if (bl2) {
                        throw new ArgumentException(k8.b6("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.sj[n11].b6, object));
                    }
                    this.zn = true;
                    this.sj[n11].t8 = object2;
                    this.ma();
                    this.zn = false;
                    break block12;
                }
                if (n10 == -1 && this.sj[n11].sj >= 0) {
                    this.sj[n11].sj = (int)((long)this.sj[n11].sj | Integer.MIN_VALUE);
                    ++this.ol;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.sj.length);
            } while (++n < this.sj.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.zn = true;
            this.sj[n10].t8 = object2;
            this.sj[n10].b6 = object;
            this.sj[n10].sj |= (int)(l11 & 0xFFFFFFFFL);
            ++this.ma;
            this.ma();
            this.zn = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (h7.t8(this.sj, item)) {
            return false;
        }
        if (this.b6 != null) {
            return this.b6.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.sj == null) {
            if (this.nn == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            g1 g12 = this.nn.ma();
            while (g12.hasNext()) {
                switch (ng.b6(g12.t8())) {
                    case 0: {
                        this.dd = this.nn.t8("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.nn.b6("HashSize");
                        break;
                    }
                    case 2: {
                        this.b6 = (IGenericEqualityComparer)this.nn.b6("KeyComparer", com.aspose.slides.internal.d1.sj.b6(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.nn.b6("Comparer", com.aspose.slides.internal.d1.sj.b6(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.nn.b6("HashCodeProvider", com.aspose.slides.internal.d1.sj.b6(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.nn.b6("Keys", com.aspose.slides.internal.d1.sj.b6(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.nn.b6("Values", com.aspose.slides.internal.d1.sj.b6(Object[].class));
                    }
                }
            }
            this.p6 = (int)(this.dd * (float)n);
            if (this.b6 == null && (comparator != null || iHashCodeProvider != null)) {
                this.b6 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.sj = this.t8(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.b6(objectArray[i], objectArray2[i], true);
            }
            this.nm = this.nn.b6("Version");
            this.nn = null;
        }
    }

    private void b6(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].b6 == null || bucketArray[n10].b6 == this.sj) {
                bucketArray[n10].t8 = object2;
                bucketArray[n10].b6 = object;
                bucketArray[n10].sj |= n;
                break;
            }
            if (bucketArray[n10].sj >= 0) {
                bucketArray[n10].sj = (int)((long)bucketArray[n10].sj | Integer.MIN_VALUE);
                ++this.ol;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void sj() {
        this.b6(this.sj.length);
    }

    private void b6(int n) {
        this.ol = 0;
        Bucket[] bucketArray = this.t8(n);
        for (int i = 0; i < this.sj.length; ++i) {
            Bucket bucket = this.sj[i].b6();
            if (bucket.b6 == null || bucket.b6 == this.sj) continue;
            this.b6(bucketArray, bucket.b6, bucket.t8, bucket.sj & Integer.MAX_VALUE);
        }
        this.zn = true;
        this.sj = bucketArray;
        this.p6 = (int)(this.dd * (float)n);
        this.ma();
        this.zn = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.b6(key, this.sj.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.sj.length);
        do {
            this.sj[n10].b6(bucket);
            if ((long)(bucket.sj & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.b6, key)) {
                this.zn = true;
                this.sj[n10].sj = (int)((long)this.sj[n10].sj & Integer.MIN_VALUE);
                this.sj[n10].b6 = this.sj[n10].sj != 0 ? this.sj : null;
                this.sj[n10].t8 = null;
                --this.ma;
                this.ma();
                this.zn = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.sj.length);
        } while (bucket.sj < 0 && ++n < this.sj.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] b6() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.ma];
        int n = 0;
        Bucket[] bucketArray = this.sj;
        int n10 = this.sj.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].b6;
            if (object == null || object == this.sj) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].t8);
        }
        return keyValuePairsArray;
    }

    private void ma() {
        ++this.nm;
    }

    private Bucket[] t8(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.ma;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.b6;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.sj;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.b6(key, this.sj.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.sj.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.nm;
                bucketArray[n10].b6(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.p2.nn.t8(1);
            } while (this.zn || n11 != this.nm);
            if (bucket.b6 == null) break;
            if ((long)(bucket.sj & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.b6, key)) {
                return bucket.t8;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.sj.length);
        } while (bucket.sj < 0 && ++n < this.sj.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.b6(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.yc == null) {
            this.yc = new KeyCollection(this);
        }
        return this.yc;
    }

    @Override
    public Object getSyncRoot() {
        return this.t8;
    }

    @Override
    public ICollection getValues() {
        if (this.dt == null) {
            this.dt = new ValueCollection(this);
        }
        return this.dt;
    }

    @Override
    public boolean isEmpty() {
        return this.ma == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        ma ma2 = com.aspose.slides.ms.System.ma.b6(objectArray);
        this.getKeys().copyTo(ma2, 0);
        return new ReadOnlyItemCollection(ma2);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        ma ma2 = com.aspose.slides.ms.System.ma.b6(objectArray);
        this.getValues().copyTo(ma2, 0);
        return new ReadOnlyItemCollection(ma2);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.b6();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].b6(), keyValuePairsArray[i].t8());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.ma.b6(entryArray));
    }

    public int getVersion() {
        return this.nm;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new t8(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private ma t8;

        ReadOnlyItemCollection(ma items) {
            this.t8 = items;
        }

        @Override
        public int size() {
            return this.t8.size();
        }

        @Override
        public boolean isEmpty() {
            return this.t8.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.t8.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.t8.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            ma ma2 = com.aspose.slides.ms.System.ma.b6(objectArray);
            this.t8.copyTo(ma2, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.t8.copyTo(com.aspose.slides.ms.System.ma.b6(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @a9
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable b6;

        SyncHashtable(Hashtable table) {
            super(false);
            this.b6 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.b6.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.b6.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.b6.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int arrayIndex) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.b6.iterator();
        }

        @Override
        public void getObjectData(y1 info, mr context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.b6("ParentTable", this.b6, com.aspose.slides.internal.d1.sj.b6(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] b6() {
            return this.b6.b6();
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.b6.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.b6.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.b6.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.getValues();
            }
        }
    }

    @a9
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable b6;

        ValueCollection(Hashtable hashtable) {
            this.b6 = hashtable;
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ma() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.zn() - arrayIndex < this.b6.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.b6.t8(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.b6, 2);
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }
    }

    @a9
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable b6;

        KeyCollection(Hashtable hashtable) {
            this.b6 = hashtable;
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ma() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.zn() - arrayIndex < this.b6.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.b6.b6(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.b6, 1);
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }
    }

    @a9
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int b6;
        private boolean t8;
        private Object sj;
        private Object ma;
        private int zn;
        private Hashtable yc;
        private int dd;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.yc = hashtable;
            this.b6 = hashtable.sj.length;
            this.dd = hashtable.nm;
            this.t8 = false;
            this.zn = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.dd != this.yc.nm) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.b6 > 0) {
                --this.b6;
                Object object = ((Hashtable)this.yc).sj[this.b6].b6;
                if (object == null || object == this.yc.sj) continue;
                this.sj = object;
                this.ma = ((Hashtable)this.yc).sj[this.b6].t8;
                this.t8 = true;
                return true;
            }
            this.t8 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.dd != this.yc.nm) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.t8 = false;
            this.b6 = this.yc.sj.length;
            this.sj = null;
            this.ma = null;
        }

        @Override
        public Object next() {
            if (!this.t8) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.zn == 1) {
                return this.sj;
            }
            if (this.zn == 2) {
                return this.ma;
            }
            return new DictionaryEntry(this.sj, this.ma);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.t8) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.sj, this.ma);
        }

        @Override
        public Object getKey() {
            if (!this.t8) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.sj;
        }

        @Override
        public Object getValue() {
            if (!this.t8) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.ma;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object b6;
        private Object t8;

        public KeyValuePairs(Object key, Object value) {
            this.t8 = value;
            this.b6 = key;
        }

        public Object b6() {
            return this.b6;
        }

        public Object t8() {
            return this.t8;
        }
    }

    private static class Bucket
    extends dd<Bucket> {
        public Object b6;
        public Object t8;
        public int sj;

        public void b6(Bucket bucket) {
            bucket.b6 = this.b6;
            bucket.t8 = this.t8;
            bucket.sj = this.sj;
        }

        public Bucket b6() {
            Bucket bucket = new Bucket();
            this.b6(bucket);
            return bucket;
        }

        public Object clone() {
            return this.b6();
        }

        private boolean t8(Bucket bucket) {
            return h7.b6(bucket.b6, this.b6) && h7.b6(bucket.t8, this.t8) && bucket.sj == this.sj;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (h7.t8(null, obj)) {
                return false;
            }
            if (h7.t8(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.t8((Bucket)obj);
        }

        public int hashCode() {
            int n = this.b6 != null ? this.b6.hashCode() : 0;
            n = 31 * n + (this.t8 != null ? this.t8.hashCode() : 0);
            n = 31 * n + this.sj;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.b6();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.b6((Bucket)object);
        }
    }

    @a9
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator b6;
        private IHashCodeProvider t8;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.b6 = comparer;
            this.t8 = hashCodeProvider;
        }

        public int b6(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.b6 != null) {
                return this.b6.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.d1.sj.b6(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.b6(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.t8 != null) {
                return this.t8.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator b6() {
            return this.b6;
        }

        IHashCodeProvider t8() {
            return this.t8;
        }
    }
}

