/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;
import com.aspose.slides.ms.System.yn;
import java.util.Arrays;

@a9
public class Stack
implements ICollection,
IEnumerable,
n0 {
    private Object[] b6;
    private int t8 = -1;
    private int sj;
    private int ma;
    private int zn;

    private void b6(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, objectArray, 0, this.sj);
        this.ma = n;
        this.b6 = objectArray;
    }

    public Stack() {
        this.b6 = new Object[16];
        this.ma = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.ma = initialCapacity;
        this.b6 = new Object[this.ma];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.sj;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.zn;
        for (int i = 0; i < this.sj; ++i) {
            this.b6[i] = null;
        }
        this.sj = 0;
        this.t8 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.ma.b6(this.b6));
        stack.t8 = this.t8;
        stack.sj = this.sj;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.sj == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.sj; ++i) {
                if (this.b6[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.sj; ++i) {
                if (!obj.equals(this.b6[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ma array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ma() > 1 || array.zn() > 0 && index >= array.zn() || this.sj > array.zn() - index) {
            throw new ArgumentException();
        }
        for (int i = this.t8; i != -1; --i) {
            array.sj(this.b6[i], this.sj - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.t8 == -1) {
            throw new InvalidOperationException();
        }
        return this.b6[this.t8];
    }

    public Object pop() {
        if (this.t8 == -1) {
            throw new InvalidOperationException();
        }
        ++this.zn;
        Object object = this.b6[this.t8];
        this.b6[this.t8] = null;
        --this.sj;
        --this.t8;
        if (this.sj <= this.ma / 4 && this.sj > 16) {
            this.b6(this.ma / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.zn;
        if (this.ma == this.sj) {
            this.b6(this.ma * 2);
        }
        ++this.sj;
        ++this.t8;
        this.b6[this.t8] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.sj) {
            a = Arrays.copyOf(this.b6, this.sj, a.getClass());
            yn.b6(a);
            return a;
        }
        System.arraycopy(this.b6, 0, a, 0, this.sj);
        if (a.length > this.sj) {
            a[this.sj] = null;
        }
        yn.b6(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    n0,
    Cloneable {
        private Stack b6;
        private int t8;
        private int sj;

        Enumerator(Stack s) {
            this.b6 = s;
            this.t8 = s.zn;
            this.sj = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.b6();
        }

        @Override
        public Object next() {
            if (this.t8 != this.b6.zn || this.sj == -2 || this.sj == -1 || this.sj > this.b6.sj) {
                throw new InvalidOperationException();
            }
            return this.b6.b6[this.sj];
        }

        @Override
        public boolean hasNext() {
            if (this.t8 != this.b6.zn) {
                throw new InvalidOperationException();
            }
            switch (this.sj) {
                case -2: {
                    this.sj = this.b6.t8;
                    return this.sj != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.sj;
            return this.sj != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.t8 != this.b6.zn) {
                throw new InvalidOperationException();
            }
            this.sj = -2;
        }

        protected Object b6() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.b6 = this.b6;
            enumerator.t8 = this.t8;
            enumerator.sj = this.sj;
            return enumerator;
        }
    }

    @a9
    private static class SyncStack
    extends Stack {
        private final Stack b6;

        SyncStack(Stack s) {
            this.b6 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.b6;
            synchronized (stack) {
                return this.b6.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.b6;
            synchronized (stack) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.b6;
            synchronized (stack) {
                return Stack.sync((Stack)this.b6.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.b6;
            synchronized (stack) {
                return this.b6.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int index) {
            Stack stack = this.b6;
            synchronized (stack) {
                this.b6.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.b6;
            synchronized (stack) {
                return new Enumerator(this.b6);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.b6;
            synchronized (stack) {
                return this.b6.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.b6;
            synchronized (stack) {
                return this.b6.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.b6;
            synchronized (stack) {
                this.b6.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.b6;
            synchronized (stack) {
                return this.b6.toArray(a);
            }
        }
    }
}

