/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzTS;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZRQ;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZRQ zzZXP;

    BorderCollection(zzZRQ parent) {
        this.zzZXP = parent;
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzZXP.getPossibleBorderKeys().zzZ(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzZXP.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzZXP, borderKey);
            this.zzZXP.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzZXP.getPossibleBorderKeys().zzD3().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzZXP.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzZXP.getPossibleBorderKeys().zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTm(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzZXP.getPossibleBorderKeys().zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTm(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        BorderCollection borderCollection = this;
        return borderCollection.get(0).zzxd().zzUo();
    }

    public final void setColor(Color value) throws Exception {
        zzTS zzTS2 = zzTS.zzZ(value);
        BorderCollection borderCollection = this;
        Iterator iterator = borderCollection.zzZXP.getPossibleBorderKeys().zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTm(n)) continue;
            borderCollection.getByBorderType(n).zzx(zzTS2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzZXP.getPossibleBorderKeys().zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTm(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzZXP.getPossibleBorderKeys().zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTm(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzZ(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzTm(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ
    implements Iterator<Border> {
        private BorderCollection zzZXz;
        private int zzZXy;

        zzZ(BorderCollection borderCollection) {
            this.zzZXz = borderCollection;
            this.zzZXy = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZXy >= this.zzZXz.getCount() - 1) {
                return false;
            }
            ++this.zzZXy;
            return true;
        }

        private Border zzwW() {
            try {
                return this.zzZXz.get(this.zzZXy);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzwW();
        }
    }
}

