/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz80;
import com.aspose.words.internal.zzX;
import com.aspose.words.zzB6;
import com.aspose.words.zzC9;
import com.aspose.words.zzDR;
import com.aspose.words.zzEC;
import com.aspose.words.zzIM;
import com.aspose.words.zzJ7;
import com.aspose.words.zzJA;
import com.aspose.words.zzK2;
import com.aspose.words.zzM5;
import com.aspose.words.zzZRH;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzM5 zzZUR;

    ChartSeriesCollection(zzM5 dmlChart) {
        this.zzZUR = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUR.zzkr().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUR.zzkr().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZUR.zzkr().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZUR.zzkr().clear();
        this.zzZ1(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zzt6().zzZ(ChartSeriesCollection.zzR(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzt6().zzZ(ChartSeriesCollection.zzY(xValues));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        double[] dArray = values;
        zz80[] zz80Array = zz80.zzZ(dates);
        String string = seriesName;
        ChartSeriesCollection chartSeriesCollection = this;
        if (zz80Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz80Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz80Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = chartSeriesCollection.zzZ(string, dArray);
        chartSeries.zzt6().zzZ(ChartSeriesCollection.zzZ(zz80Array));
        if (!chartSeriesCollection.zzZUR.zzkl()) {
            chartSeriesCollection.zzZ1(true);
        }
        return chartSeries;
    }

    private void zzZ1(boolean bl) {
        zzZRH zzZRH2 = zzX.zzZ((Object)this.zzZUR, zzZRH.class);
        if (zzZRH2 != null && zzZRH2.zzlm().zztS()) {
            zzZRH2.zzlm().zzud().zzN(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZUR.zzlp() != 15) {
            this.zzZUR.zzT(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zztc().zztn().zzN(3, this.zzZUR.zzko());
        chartSeries.zzt6().zzZ(ChartSeriesCollection.zzY(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzt2().zzZ(ChartSeriesCollection.zzY(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZUR);
        chartSeries.setName(string);
        ChartSeries chartSeries2 = chartSeries;
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeries2.zztc().zztn().zzN(5, new zzJA());
        switch (chartSeriesCollection.zzZUR.zzlp()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                break;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                ChartSeriesCollection.zzU(chartSeries2);
                break;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries2, 1);
                ChartSeriesCollection.zzU(chartSeries2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeries chartSeries3 = chartSeries2;
                zzJA zzJA2 = new zzJA();
                zzJA2.zzY(new zzDR());
                zzC9 zzC92 = new zzC9();
                zzC92.setValue(1);
                zzJA2.zzmb().zzY(new zzB6(zzC92));
                zzJA2.zzmb().zzYX(19050.0);
                chartSeries3.zztc().zztn().zzN(5, zzJA2);
            }
        }
        chartSeries.setIndex(this.zzZUR.zzkr().size());
        chartSeries.zzSU(chartSeries.getIndex());
        chartSeries.zzt4().zzZ(ChartSeriesCollection.zzY(dArray));
        chartSeries.zzt5().zzZ(chartSeries.zzt4().zzje());
        this.zzZUR.zzT(chartSeries);
        return chartSeries;
    }

    private static void zzU(ChartSeries chartSeries) {
        zzJA zzJA2 = new zzJA();
        zzJA2.zzY(new zzDR());
        zzJA2.zzmb().zzY(new zzEC());
        zzJA2.zzmb().setEndCap(0);
        zzJA2.zzmb().zzYX(19050.0);
        chartSeries.zztc().zztn().zzN(5, zzJA2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzte().zzN(0, n);
        chartSeries.zztc().zztn().zzN(4, chartMarker);
    }

    private static zzIM zzY(double[] dArray) {
        int n = 0;
        zzIM zzIM2 = new zzIM(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzIM2.zzX(new zzK2(n, d, "General"));
            }
            ++n;
        }
        zzIM2.zzQE(dArray.length);
        zzIM2.zzel();
        return zzIM2;
    }

    private static zzIM zzZ(zz80[] zz80Array) {
        int n = 0;
        zzIM zzIM2 = new zzIM(2, false);
        zz80[] zz80Array2 = zz80Array;
        int n2 = zz80Array.length;
        for (int i = 0; i < n2; ++i) {
            zz80 zz802 = zz80Array2[i];
            zzIM2.zzX(new zzK2(n++, zz802.zzCU(), "m/d/yyyy"));
        }
        zzIM2.zzQE(zz80Array.length);
        zzIM2.zzel();
        return zzIM2;
    }

    private static zzIM zzR(String[] stringArray) {
        int n = 0;
        zzIM zzIM2 = new zzIM(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzIM2.zzX(new zzJ7(n++, string));
        }
        zzIM2.zzQE(stringArray.length);
        zzIM2.zzel();
        return zzIM2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUR.zzkr().size();
    }
}

