/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz1Z;
import com.aspose.words.internal.zz6R;
import com.aspose.words.internal.zz6T;
import com.aspose.words.internal.zz6U;
import com.aspose.words.internal.zzIP;
import com.aspose.words.internal.zzIR;
import com.aspose.words.internal.zzIT;
import com.aspose.words.internal.zzRH;
import com.aspose.words.internal.zzV0;
import com.aspose.words.internal.zzX;
import com.aspose.words.internal.zzZQG;
import com.aspose.words.zz12;
import com.aspose.words.zzNZ;
import com.aspose.words.zzYOK;
import com.aspose.words.zzYY2;
import com.aspose.words.zzZ7Q;
import com.aspose.words.zzZ7R;
import com.aspose.words.zzZ7S;
import com.aspose.words.zzZ7T;
import com.aspose.words.zzZA9;
import com.aspose.words.zzZAC;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ(zz6R zz6R2, zz6R zz6R3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        Object object;
        Object object2;
        zzX.zzZ((Object)zz6R2, "srcStream");
        zzX.zzZ((Object)zz6R3, "dstStream");
        zzX.zzZ((Object)certificateHolder, "certHolder");
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            object2 = digitalSignature;
            object = signOptions;
            ((DigitalSignature)object2).setComments(((SignOptions)object).getComments());
            ((DigitalSignature)object2).zzC(((SignOptions)object).zzlR());
            ((DigitalSignature)object2).zzR(((SignOptions)object).zzZfZ());
            ((DigitalSignature)object2).setImageBytes(((SignOptions)object).getSignatureLineImage());
            ((DigitalSignature)object2).zzQ(((SignOptions)object).zzZfY());
        }
        if (zz12.zz6(zz6R2)) {
            DigitalSignatureUtil.zzZ(zz6R2, zz6R3, digitalSignature, true);
            return;
        }
        zz12 zz122 = new zz12();
        zz6R zz6R4 = zz6R2;
        zz12 zz123 = zz122;
        FileFormatInfo fileFormatInfo = zz122.zzY(zz6R4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRH zzRH2 = new zzRH(zz6R2);
                int n = fileFormatInfo.zzZU0() == 1 ? 1 : 2;
                zzYY2.zzZ(zzRH2, digitalSignature, n);
                zz6R3.setLength(0L);
                zzRH2.zzP(zz6R3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string;
                    String string2 = string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignature digitalSignature2 = digitalSignature;
                    object2 = zz6R3;
                    object = fileFormatInfo.zzZTZ();
                    zz6T zz6T2 = DigitalSignatureUtil.zzZ((zzRH)object, string2);
                    zz6T zz6T3 = new zz6T();
                    DigitalSignatureUtil.zzZ((zz6R)zz6T2, (zz6R)zz6T3, digitalSignature2, false);
                    zzRH zzRH3 = zzNZ.zzY(zz6T3, string2);
                    zzRH3.zzP((zz6R)object2);
                    return;
                }
                DigitalSignatureUtil.zzZ(zz6R2, zz6R3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignature digitalSignature3 = digitalSignature;
                object2 = zz6R3;
                object = zz6R2;
                zzZAC zzZAC2 = new zzZAC((zz6R)object);
                zzZA9 zzZA92 = new zzZA9(zzZAC2);
                zzZA92.zzY(digitalSignature3);
                ((zz6R)object2).setLength(0L);
                zzZAC2.zzX((zz6R)object2, "application/vnd.oasis.opendocument.text");
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ((zz6R)zz6R.zzY(srcStream), (zz6R)zz6R.zzY(dstStream), certHolder, signOptions);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzX.zzZ(srcFileName, "srcFileName");
        zzX.zzZ(dstFileName, "dstFileName");
        zz6U zz6U2 = zzX.zzZ(srcFileName, 3, 1);
        try {
            zz6U zz6U3 = zzX.zzZ(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzZ((zz6R)zz6U2, (zz6R)zz6U3, certHolder, signOptions);
            }
            finally {
                zz6U3.close();
            }
            return;
        }
        finally {
            zz6U2.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zz1Z zz1Z2 = zz6R.zzY(dstStream);
        zz6T zz6T2 = zz6R.zzY(srcStream);
        DigitalSignatureUtil.zzZ((zz6R)zz6T2, (zz6R)zz1Z2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zz6U zz6U2 = zzX.zzZ(srcFileName, 3, 1);
        try {
            zz6U zz6U3 = zzX.zzZ(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzW(zz6U2, zz6U3);
            }
            finally {
                zz6U3.close();
            }
            return;
        }
        finally {
            zz6U2.close();
        }
    }

    private static void zzW(zz6R zz6R2, zz6R zz6R3) throws Exception {
        zz12 zz122 = new zz12();
        zz6R zz6R4 = zz6R2;
        zz12 zz123 = zz122;
        FileFormatInfo fileFormatInfo = zz122.zzY(zz6R4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRH zzRH2 = new zzRH(zz6R2);
                zzRH2.zzQB().remove("_xmlsignatures");
                zzRH2.zzQB().remove("_signatures");
                zz6R3.zzu(0L);
                zzRH2.zzP(zz6R3);
                zz6R3.setLength(zz6R3.getPosition());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzIT zzIT2 = new zzIT(zz6R2);
                zzIR zzIR2 = zzIT2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzIR2 != null) {
                    for (zzIP zzIP2 : zzIR2.zzKe()) {
                        String string = zzIR2.zzZ(zzIP2);
                        zzIT2.zzKf().remove(string);
                    }
                    zzIT2.zzKf().remove(zzIR2.getName());
                    zzIP zzIP3 = zzIT2.zzKe().zzZc("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzIT2.zzKe().remove(zzIP3.getId());
                    zzIT2.zzKh();
                }
                zz6R3.zzu(0L);
                zzIT2.zzP(zz6R3);
                zz6R3.setLength(zz6R3.getPosition());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzW(zz6R.zzY(srcStream), zz6R.zzY(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zz6U zz6U2 = zzX.zzZ(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzb(zz6U2);
            return digitalSignatureCollection;
        }
        finally {
            zz6U2.close();
        }
    }

    private static DigitalSignatureCollection zzb(zz6R zz6R2) throws Exception {
        if (zz12.zz6(zz6R2)) {
            zz6R zz6R3 = zz6R2;
            zz6R3.zzu(0L);
            zzIT zzIT2 = new zzIT(zz6R3);
            DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
            zzIR zzIR2 = zzIT2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
            if (zzIR2 != null) {
                for (zzIP zzIP2 : zzIR2.zzKe()) {
                    String string = zzIR2.zzZ(zzIP2);
                    zzIR zzIR3 = zzIT2.zzZh(string);
                    zzIR zzIR4 = zzIT2.zzZ(zzIR3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                    zzZQG zzZQG2 = zzV0.zzz(zzIR4.zzKc().toArray());
                    zzYOK.zzZ(zzIR3.zzVg(), zzZQG2, new zzZ7T(zzIT2), digitalSignatureCollection, null);
                }
            }
            return digitalSignatureCollection;
        }
        zz12 zz122 = new zz12();
        zz6R zz6R4 = zz6R2;
        zz12 zz123 = zz122;
        FileFormatInfo fileFormatInfo = zz122.zzY(zz6R4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zz6R2);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzb(zz6R.zzY(stream));
    }

    static zz6T zzZ(zzRH zzRH2, String string) throws Exception {
        zzNZ zzNZ2 = new zzNZ(zzRH2);
        if (zzNZ2.zzmp()) {
            zz6T zz6T2 = zzNZ2.zzVg(string);
            return zz6T2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    private static void zzZ(zz6R zz6R2, zz6R zz6R3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzIT zzIT2 = new zzIT(zz6R2);
        zzZ7S zzZ7S2 = bl ? new zzZ7Q(zzIT2) : new zzZ7R(zzIT2);
        zzZ7S2.zzY(digitalSignature);
        zz6R3.setLength(0L);
        zzIT2.zzP(zz6R3);
    }
}

