/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zz27;
import com.aspose.words.internal.zz6R;
import com.aspose.words.internal.zz6S;
import com.aspose.words.internal.zz6T;
import com.aspose.words.internal.zz70;
import com.aspose.words.internal.zz82;
import com.aspose.words.internal.zz9U;
import com.aspose.words.internal.zz9V;
import com.aspose.words.internal.zzB7;
import com.aspose.words.internal.zzBO;
import com.aspose.words.internal.zzYC;
import com.aspose.words.internal.zzYO;
import com.aspose.words.internal.zzYP;
import com.aspose.words.zz35;
import com.aspose.words.zz3A;
import com.aspose.words.zz7;
import com.aspose.words.zz95;
import com.aspose.words.zzD9;
import com.aspose.words.zzDX;
import com.aspose.words.zzE3;
import com.aspose.words.zzFV;
import com.aspose.words.zzI9;
import com.aspose.words.zzMJ;
import com.aspose.words.zzX;
import com.aspose.words.zzYJ;
import com.aspose.words.zzYP1;
import com.aspose.words.zzYRK;
import com.aspose.words.zzYU3;
import com.aspose.words.zzYUL;
import com.aspose.words.zzYV7;
import com.aspose.words.zzYVK;
import com.aspose.words.zzYXX;
import com.aspose.words.zzYZ2;
import com.aspose.words.zzZ09;
import com.aspose.words.zzZ74;
import com.aspose.words.zzZ7Y;
import com.aspose.words.zzZ82;
import com.aspose.words.zzZH2;
import com.aspose.words.zzZL;
import com.aspose.words.zzZOI;
import com.aspose.words.zzZOL;
import com.aspose.words.zzZPV;
import com.aspose.words.zzZRN;
import com.aspose.words.zzZRP;
import com.aspose.words.zzZUA;
import com.aspose.words.zzZUW;
import com.aspose.words.zzZWG;
import com.aspose.words.zzZZN;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzZOI,
zzZOL,
zzZRP {
    private Document zzZp4;
    private Node zzZnA;
    private Node zzZnz;
    private zzZ09 zzZny;
    private Font zzZnx;
    private zz82<zzZ09> zzZnw;
    private zzYU3 zzZnv = zzYU3.zzZ99();
    private zzYJ zzZVX = new zzYJ();
    private RowFormat zzZnu;
    private CellFormat zzZVW;
    private zz82<zzYUL> zzZnt;
    private int zzZns = 0;
    private int zzZnr = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzR(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzR(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzR(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYP1.zzwV(headerFooterType), 0, 0);
    }

    private void zzR(int n, int n2, int n3, int n4) {
        this.zzZp4.ensureMinimum();
        Section section = (Section)this.zzZp4.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYP1.zzwU(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZp4, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZp4));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzY(paragraph, n2);
    }

    final void zzY(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz3J().isRemoved() ? zzZH2.zzT(this.zzZp4, fieldName) : zzZH2.zzS(this.zz3J(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZPV zzZPV2 = field.getFormat().zzZWm();
        Inline inline = zzZPV2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZWn(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZL.zzX(this.zzZp4, bookmarkName) : zzZL.zzW(this.zzZp4, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZz3() == 6) {
            this.zzZ((Paragraph)node.zzZzh(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzX.zzC(node);
            if (paragraph == null) {
                return false;
            }
            this.zzZ(paragraph, paragraph.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ3(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzY(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzY(cell.getLastParagraph(), -1);
        }
    }

    private void zzZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZz3() == 6) {
            this.zz6(node);
        } else if (zzX.zzN(node)) {
            Paragraph paragraph = zzX.zzC(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zz6(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzZz3() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zz6(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zz3U();
            return;
        }
        if (!this.zz3V()) {
            this.zz3U();
        }
    }

    private boolean zz3V() {
        Node node = this.zz3J();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz3J(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zzZWn(), true);
            return true;
        }
        return false;
    }

    private void zz3U() {
        this.zzZ(this.getCurrentParagraph().zzZqv(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ3(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz3M() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz3J().zzZ4(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZza();
                this.zzY(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzH(text, false);
    }

    public void writeln(String text) {
        this.zzH(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYV7 zzYV72 = new zzYV7(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZp4, this.zz3R(), this.zz3S());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz3J(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYV72.dispose();
        }
        if (this.getDocument().zz4j()) {
            zzX.zzX(paragraph, this.getDocument().zz4o());
        }
        return this.getCurrentParagraph();
    }

    public void insertStyleSeparator() {
        zzYVK.zzY(this);
    }

    public void insertBreak(int breakType) {
        this.zzn(breakType, true);
    }

    final void zzn(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXs(bl)) {
                    this.zzSD(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXs(bl)) {
                    this.zzSD(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXs(bl)) {
                    this.zzNl(1);
                }
                return;
            }
            case 5: {
                if (this.zzXs(bl)) {
                    this.zzNl(2);
                }
                return;
            }
            case 3: {
                if (this.zzXs(bl)) {
                    this.zzNl(0);
                }
                return;
            }
            case 6: {
                if (this.zzXs(bl)) {
                    this.zzNl(3);
                }
                return;
            }
            case 7: {
                if (this.zzXs(bl)) {
                    this.zzNl(4);
                }
                return;
            }
            case 8: {
                this.zzSD(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzBO.zzYI(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz27.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        com.aspose.words.internal.zzX.zzZ((Object)displayText, "displayText");
        com.aspose.words.internal.zzX.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz3A zz3A2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz3A2.zzY(documentBuilder.zzm(88, true));
        return zzX.zzZ(zz3A2.getStart(), zz3A2.getSeparator(), zz3A2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzNk(70);
        if (zzBO.zzYI(name)) {
            this.startBookmark(name);
        }
        this.zzSC(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzNj(70);
        String string = zzBO.zzYI(fieldValue) ? fieldValue : FormField.zzZ4G;
        Run run = new Run(this.zzZp4, string, this.zz3S());
        this.insertNode(run);
        this.zzm(70, true);
        if (zzBO.zzYI(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz7(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzNk(71);
        if (zzBO.zzYI(name)) {
            this.startBookmark(name);
        }
        this.zzSC(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzm(71, false);
        if (zzBO.zzYI(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz7(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzNk(83);
        if (zzBO.zzYI(name)) {
            this.startBookmark(name);
        }
        this.zzSC(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzm(83, false);
        if (zzBO.zzYI(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz7(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZp4, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzTX(footnoteType));
        if (zzBO.zzYI(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZp4);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzTW(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZp4, '\u0002', new zzZ09()) : new Run(this.zzZp4, footnote.getReferenceMark(), new zzZ09());
        inline.getFont().setStyleIdentifier(zzX.zzTX(footnoteType));
        paragraph.appendChild(inline);
        if (zzBO.zzYI(footnoteText)) {
            Node node = this.zz3J();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zz6(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zza(zz6R zz6R2) throws Exception {
        return this.zzZ(zz6R2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zza(zz6R.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz6R zz6R2, double d, double d2) throws Exception {
        return this.zzZ(zz6R2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz6R.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz6T zz6T2 = new zz6T();
        try {
            zzYC.zzZ(image, zz6T2);
            Shape shape = this.zzZ(zz6T2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz6T2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        com.aspose.words.internal.zzX.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzB7.zzYv(fileName);
        try {
            Shape shape = this.zzZ((zz6R)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz6R)object).close();
            }
        }
    }

    private Shape zzZ(zz6R zz6R2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz6R2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = com.aspose.words.internal.zzX.zzZ(zz6R2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz6R.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZp4.getCompatibilityOptions().getMswVersion() > 12 || this.zzZp4.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZp4, 0);
            zzD9 zzD92 = new zzD9();
            zzD92.zzZ(zzFV.zzSY("rect"));
            zzD92.zzZ(new zzMJ());
            zzDX zzDX2 = new zzDX();
            zzDX2.zzY(new zzE3(shape.getId(), ""));
            zzDX2.zzZ(new zzI9());
            zzD92.zzZ(zzDX2);
            shape.zzLR(75);
            shape.zzX(zzD92);
        } else {
            shape = new Shape((DocumentBase)this.zzZp4, 75);
        }
        shape.zzR(this.zz3S());
        if (shape.getImageData().zzZY(imageBytes)) {
            imageBytes = shape.getImageData().zzZ(imageBytes, new zzYXX(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzz(width, height);
        return shape;
    }

    private Shape zzO(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz6T zz6T2 = new zz6T();
        try {
            zzYC.zzZ(bufferedImage, zz6T2);
            byArray = com.aspose.words.internal.zzX.zzZ(zz6T2);
        }
        finally {
            zz6T2.close();
        }
        return this.zzZl(byArray);
    }

    private Shape zzZl(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZp4, 1);
        shape.zzLR(75);
        shape.zzR(this.zz3S());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzz(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        BufferedImage bufferedImage = presentation;
        boolean bl = asIcon;
        String string = progId;
        zz6T zz6T2 = zz6R.zzY(stream);
        DocumentBuilder documentBuilder = this;
        zzZ82 zzZ822 = zzZ82.zzLb(string);
        Shape shape = bufferedImage != null ? documentBuilder.zzO(bufferedImage) : documentBuilder.zzZl(zzZ7Y.zzZ(zzZ822, bl));
        shape.zzLR(-2);
        shape.getOleFormat().setProgId(zzZ822.zzYpU);
        shape.getOleFormat().zzY(zzZ7Y.zzZ(zz6T2, string, bl));
        return shape;
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ82 zzZ822 = zzZ82.zzLa(zz6S.zzXG(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ822);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ82 zzZ822 = zzZ82.zzLb(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ822);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ82 zzZ822) throws Exception {
        Shape shape = bufferedImage != null ? this.zzO(bufferedImage) : this.zzZl(zzZ7Y.zzZ(zzZ822, bl2));
        shape.zzLR(-2);
        shape.getOleFormat().setProgId(zzZ822.zzYpU);
        shape.getOleFormat().zzY(zzZ7Y.zzZ(string, bl, bl2, zzZ822));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZUA zzZUA2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzO(bufferedImage);
        shape.zzLR(201);
        shape.getOleFormat().zzY(zzZUA2.zzZO8());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZUW zzZUW2 = new zzZUW();
        zzZUW2.zzWz(useBuilderFormatting);
        zzZUW2.zzWy(useBuilderFormatting);
        this.zzZ(html, zzZUW2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzX.zzZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzX.zzZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZRN zzZRN2 = new zzZRN();
        return zzZRN2.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRK(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRK(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZp4, 75);
        shape.zzR(this.zz3S());
        boolean bl = true;
        Shape shape2 = shape;
        if (!shape2.isSignatureLine()) {
            shape2.setShapeAttr(1983, true);
            shape2.setShapeAttr(1922, zz70.zzcR.toString("B").toUpperCase());
        }
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzz(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public void insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzB(this.zzZp4);
        this.insertNode(shape);
    }

    private void zzZ(String string, zzZUW zzZUW2) throws Exception {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (((DocumentBuilder)object2).zz3J().getParentNode().getNodeType() == 28) {
            object = (StructuredDocumentTag)((DocumentBuilder)object2).zz3J().getParentNode();
            switch (((StructuredDocumentTag)object).getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        if (bl) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSE(documentBuilder.getDocument().toString(70)));
            return;
        }
        object = this;
        zzZUW zzZUW3 = zzZUW2;
        object2 = string;
        zzZWG zzZWG2 = new zzZWG((String)object2, zzZUW3, (DocumentBuilder)object);
        zzZWG2.read();
    }

    private static String zzSE(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zz3M() == null) {
            this.startTable();
        }
        if (this.zz3M().zzZaz() == 1) {
            this.zz3M().zzZaC();
        }
        if (this.zz3M().zzZaz() == 3) {
            this.zz3M().zzZaA();
        }
        return this.zz3M().zzZaB();
    }

    public Table startTable() {
        this.zzZnt.push(new zzYUL(this));
        return this.zz3M().startTable();
    }

    public Table endTable() {
        if (this.zz3M() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz3M().endTable();
        this.zzZnt.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz3M() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz3M().endRow();
        if (this.zzZnx != null && this.zzZnx.getHidden()) {
            row.zz3I().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZp4, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZp4, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZp4);
        this.zzZnr = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZnr == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZp4, this.zzZnr);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZp4, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return new zz95(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZp4;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZp4) {
            return;
        }
        this.zzZp4 = value;
        this.zz6(null);
        this.zzZny = new zzZ09();
        this.zzZnw = null;
        this.zzZnx = null;
        this.zzZnt = new zz82();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZnx == null) {
            this.zzZnx = new Font(this, this.getDocument());
        }
        return this.zzZnx;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZnu == null) {
            this.zzZnu = new RowFormat(this);
        }
        return this.zzZnu;
    }

    public CellFormat getCellFormat() {
        if (this.zzZVW == null) {
            this.zzZVW = new CellFormat(this);
        }
        return this.zzZVW;
    }

    public void pushFont() {
        this.zz3K().push(this.zz3S());
    }

    public void popFont() {
        zz82<zzZ09> zz822 = this.zz3K();
        if (zz822.size() > 0) {
            this.zzZ((zzZ09)this.zz3K().pop(), false);
        }
    }

    private zz3A zzZ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzNk(88);
        zz35 zz352 = new zz35();
        zz352.setTarget(string2);
        zz352.setScreenTip(string3);
        if (bl) {
            zz352.setSubAddress(string);
        } else {
            zz352.setAddress(zz9U.zzYp(string));
            zz352.setSubAddress(zz9U.zzYo(string));
        }
        this.zzSC(zz352.toString());
        FieldSeparator fieldSeparator = this.zzNj(88);
        return new zz3A(fieldStart, fieldSeparator, null);
    }

    final zz3A zzS(String string, String string2, String string3) {
        boolean bl = zz9U.zzYg(string);
        String string4 = bl ? zz9U.zzYo(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    final FieldEnd zz3T() {
        return this.zzm(88, true);
    }

    final zzZ09 zz3S() {
        return (zzZ09)this.zzZny.zzy3();
    }

    final zzZ74 zz3R() {
        return (zzZ74)this.getCurrentParagraph().zzZQH().zzy3();
    }

    final zzYU3 zz3Q() {
        return (zzYU3)this.zz3I().zzy3();
    }

    final zzYJ zz3P() {
        return (zzYJ)this.zzvU().zzy3();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz3J(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz3J().getNodeType() == 8;
    }

    private void zzH(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYP1.zzHO(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSB(string2.substring(n, n + n2));
                }
                switch (this.zzZns) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSD(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSB(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzSD(String string) {
        Run run = new Run(this.zzZp4, string, this.zz3S());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zz3M() != null && this.zz3M().zzZaz() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz3J().getParentNode().insertBefore(node, this.zz3J());
    }

    final void zzNm(int n) {
        this.zzXs(true);
        this.zzNl(n);
    }

    private void zzNl(int n) {
        this.insertParagraph();
        zzYV7 zzYV72 = new zzYV7(this.getDocument());
        try {
            zzYZ2 zzYZ22 = (zzYZ2)this.getCurrentSection().zzZvr().zzy3();
            Section section = new Section(this.zzZp4, zzYZ22);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZp4));
            this.zzZp4.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYV72.dispose();
        }
    }

    final FieldStart zzNk(int n) {
        return zzX.zzZ(n, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzSC(String string) {
        return zzX.zzY(string, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzm(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zz3S(), this.zz3J(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzNj(int n) {
        return zzX.zzY(n, this.zz3S(), this.zz3J(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zz7(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZp4, new zzZZN(), this.zz3S());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzXs(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz3M() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ3(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSB(String string) {
        boolean bl;
        block4: {
            String string2 = string;
            DocumentBuilder documentBuilder = this;
            boolean bl2 = documentBuilder.getFont().getBidi();
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl3;
                char c = string2.charAt(i);
                int n = zz9V.zzw(c);
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = n == 3 || n == 4;
                if ((!bl2 || !bl4) && (bl2 || !bl3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            zzYP zzYP10 = new zzYP(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYO zzYO2 : zzYP10.zzK(this.getParagraphFormat().getBidi())) {
                zz7 zz710 = zz7.zzZp(zzYO2.zzYt());
                zzZ09 zzZ092 = this.zz3S();
                zzZ092.zzT(265, zz710);
                if (zzYO2.zzYq()) {
                    zzZ092.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZp4, zzYO2.getText(), zzZ092);
                this.insertNode(run);
            }
            return;
        }
        this.zzSD(string);
    }

    final void zzZ(zzZ09 zzZ092, boolean bl) {
        this.zzZny = bl ? (zzZ09)zzZ092.zzy3() : zzZ092;
    }

    final void zz3O() {
        this.zzZny.clear();
    }

    final void zz3N() {
        if (this.zz3L() != null) {
            zzYJ zzYJ2 = this.zz3L().zzvU();
            zzYJ zzYJ3 = this.zzZVX = (zzYJ)zzYJ2.zzy3();
            zzYJ zzYJ4 = zzYJ2;
            for (int n : zzYJ.zzZVE.zzD2()) {
                if (zzYJ4.contains(n)) {
                    Border border = new Border();
                    border.zzU((Border)zzYJ4.get(n));
                    zzYJ3.set(n, border);
                    continue;
                }
                zzYJ3.remove(n);
            }
        }
    }

    final boolean zzau() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzNi(int n) {
        this.zzZns = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz3J();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz3J();
        }
        return (Paragraph)this.zz3J().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYUL zz3M() {
        zz82<zzYUL> zz822 = this.zzZnt;
        if (zz822.size() > 0) {
            return (zzYUL)this.zzZnt.peek();
        }
        return null;
    }

    private Cell zz3L() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZWD();
    }

    private zz82<zzZ09> zz3K() {
        if (this.zzZnw == null) {
            this.zzZnw = new zz82();
        }
        return this.zzZnw;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZny.zzTA(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZny.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZy(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZy(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZny.zzT(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZql()) {
            this.getCurrentParagraph().zzZqv().zzT(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZny.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZny.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZql()) {
            this.getCurrentParagraph().zzZqv().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz3I().zzTA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz3I().zzTz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz3I().zzTy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz3I().zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz3I().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz3I().clear();
        zzYU3.zzZ99().zzY(this.zz3I());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzvU().zzTA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzvU().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzvU().zzTy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = com.aspose.words.internal.zzX.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zz3L() != null ? this.zz3L().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzvU().zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzvU().clear();
    }

    private Node zz3J() {
        Node node = this.zzZnA != null && this.zzZnA.getParentNode() == null ? this.zzZnz : this.zzZnA;
        if (node != null && node.zzZz3() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zz6(Node node) {
        this.zzZnA = node;
        if (this.zzZnA != null) {
            this.zzZnz = this.zzZnA.getParentNode();
        }
    }

    private zzYU3 zz3I() {
        if (this.zz3M() != null && this.zz3M().zzZaz() == 1) {
            return this.zzZnv;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz3I();
        }
        return this.zzZnv;
    }

    private zzYJ zzvU() {
        if (this.zz3M() != null && this.zz3M().zzZaz() != 3) {
            return this.zzZVX;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZWD().zzvU();
        }
        return this.zzZVX;
    }
}

