/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz6R;
import com.aspose.words.internal.zz6U;
import com.aspose.words.internal.zzBO;
import com.aspose.words.internal.zzRI;
import com.aspose.words.internal.zzU;
import com.aspose.words.internal.zzX;
import com.aspose.words.zz12;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZ7t = new HashMap();
    private static HashMap<Integer, Integer> zzZ7s = new HashMap();
    private static HashMap<Integer, Integer> zzZ7r = new HashMap();
    private static HashMap<Integer, Integer> zzZ7q = new HashMap();
    private static HashMap<Integer, Integer> zzZ7p = new HashMap();
    private static HashMap<Integer, Integer> zzZ7o = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzX.zzZ(fileName, "fileName");
        zz6U zz6U2 = zzX.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz5(zz6U2);
            return fileFormatInfo;
        }
        finally {
            ((zz6R)zz6U2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz5(zzU.zzZ(stream));
    }

    static FileFormatInfo zz5(zz6R zz6R2) throws Exception {
        if (zz6R2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz12 zz122 = new zz12();
            zz6R zz6R3 = zz6R2;
            zz12 zz123 = zz122;
            return zz122.zzY(zz6R3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzKv(zzRI.zzh(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzKA(zzRI.zzh(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzRI.zzXF(FileFormatUtil.zzKx(loadFormat));
        if (zzBO.zzYI(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzKv(FileFormatUtil.zzKw(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzKA(FileFormatUtil.zzKx(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzRI.zzXF(FileFormatUtil.zzKw(saveFormat));
        if (zzBO.zzYI(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzKA(zzRI.zzg(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        return "." + zzRI.zzXF(zzX.zzZ(zzZ7r, Integer.valueOf(n), Integer.valueOf(0)));
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzKB(int n) {
        return zzRI.toString(FileFormatUtil.zzKw(n));
    }

    static int zzKA(int n) {
        return zzX.zzZ(zzZ7p, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzKz(int n) {
        return zzX.zzZ(zzZ7o, Integer.valueOf(n), Integer.valueOf(1));
    }

    static boolean zzKy(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzKx(int n) {
        return zzX.zzZ(zzZ7t, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzKw(int n) {
        return zzX.zzZ(zzZ7s, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzKv(int n) {
        return zzX.zzZ(zzZ7q, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzQ(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzX.zzY(zzZ7p, Integer.valueOf(n), Integer.valueOf(n2));
            zzX.zzY(zzZ7s, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZ7q.containsKey(n)) {
                zzX.zzY(zzZ7q, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzX.zzY(zzZ7t, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzX.zzY(zzZ7o, Integer.valueOf(n), Integer.valueOf(n4));
            zzX.zzY(zzZ7r, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzQ(11, 10, 10, 1);
        FileFormatUtil.zzQ(11, 0, 0, 1);
        FileFormatUtil.zzQ(12, 11, 11, 1);
        FileFormatUtil.zzQ(13, 20, 20, 1);
        FileFormatUtil.zzQ(13, 0, 254, 1);
        FileFormatUtil.zzQ(14, 21, 21, 1);
        FileFormatUtil.zzQ(15, 22, 22, 1);
        FileFormatUtil.zzQ(16, 23, 23, 1);
        FileFormatUtil.zzQ(18, 24, 24, 1);
        FileFormatUtil.zzQ(19, 25, 25, 1);
        FileFormatUtil.zzQ(20, 26, 26, 1);
        FileFormatUtil.zzQ(21, 27, 27, 1);
        FileFormatUtil.zzQ(24, 30, 30, 1);
        FileFormatUtil.zzQ(17, 31, 31, 1);
        FileFormatUtil.zzQ(25, 50, 50, 1);
        FileFormatUtil.zzQ(26, 45, 255, 1);
        FileFormatUtil.zzQ(27, 51, 51, 1);
        FileFormatUtil.zzQ(28, 0, 52, 1);
        FileFormatUtil.zzQ(22, 60, 60, 1);
        FileFormatUtil.zzQ(23, 61, 61, 1);
        FileFormatUtil.zzQ(31, 40, 255, 1);
        FileFormatUtil.zzQ(38, 47, 255, 1);
        FileFormatUtil.zzQ(39, 48, 255, 1);
        FileFormatUtil.zzQ(32, 41, 255, 1);
        FileFormatUtil.zzQ(33, 46, 255, 1);
        FileFormatUtil.zzQ(35, 42, 255, 1);
        FileFormatUtil.zzQ(34, 44, 255, 1);
        FileFormatUtil.zzQ(29, 52, 255, 1);
        FileFormatUtil.zzQ(30, 70, 62, 1);
        FileFormatUtil.zzQ(36, 71, 255, 1);
        FileFormatUtil.zzQ(8, 100, 255, 1);
        FileFormatUtil.zzQ(9, 105, 255, 1);
        FileFormatUtil.zzQ(6, 101, 255, 6);
        FileFormatUtil.zzQ(7, 102, 255, 7);
        FileFormatUtil.zzQ(5, 104, 255, 5);
        FileFormatUtil.zzQ(4, 0, 255, 4);
        FileFormatUtil.zzQ(3, 0, 255, 3);
        FileFormatUtil.zzQ(37, 72, 255, 1);
        FileFormatUtil.zzQ(2, 103, 255, 2);
    }
}

