/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zz1J;
import com.aspose.words.internal.zz27;
import com.aspose.words.internal.zz80;
import com.aspose.words.internal.zzBO;
import com.aspose.words.internal.zzQM;
import com.aspose.words.internal.zzX;
import com.aspose.words.zzYP1;
import com.aspose.words.zzZ09;
import com.aspose.words.zzZF0;
import com.aspose.words.zzZP4;
import com.aspose.words.zzZZN;

public class FormField
extends SpecialChar {
    private zzZZN zzZ4I;
    private Field zzZ4H;
    static String zzZ4G = zz27.zzV('\u2002', 5);
    private static final zz1J zzVN = new zz1J("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZN formFieldPr, zzZ09 runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ4I = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZP4 zzZP42) {
        FormField formField = (FormField)super.zzZ(bl, zzZP42);
        ((FormField)super.zzZ(bl, zzZP42)).zzZ4I = (zzZZN)this.zzZ4I.zzy3();
        formField.zzZ4H = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZzh().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVN.zzWQ(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzBO.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZzg().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzQM.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYP1.zzY((zz80)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ4I.getName();
    }

    public void setName(String value) throws Exception {
        zzX.zzZ((Object)value, "value");
        this.zzZ4I.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZ4I.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZRY() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ4H == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ4H = fieldChar.getField();
            }
        }
        return this.zzZ4H;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz27.equals(string, zzZ4G)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZRX();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzX.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzQM.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQC(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ4I.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ4I.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ4I.zzZRT();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ4I.zzWH(value);
    }

    public String getHelpText() {
        return this.zzZ4I.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ4I.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ4I.zzZRU();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ4I.zzWI(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ4I.zzZRV();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ4I.zzWJ(value);
    }

    public String getEntryMacro() {
        return this.zzZ4I.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ4I.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ4I.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ4I.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ4I.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ4I.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ4I.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ4I.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ4I.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ4I.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ4I.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ4I.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzFw(21);
            zzZF0.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZzg());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ4I.zzZRS();
    }

    public void setMaxLength(int value) {
        this.zzZ4I.zzJW(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ4I.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZN zzZZN2 = this.zzZ4I;
        if (zzZZN2.contains(21070)) {
            return this.zzZ4I.zzZRM();
        }
        return this.zzZ4I.zzZRN();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ4I.zzJT(value);
    }

    final String zzZRX() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQC(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzBO.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZN zzZZN2 = this.zzZ4I;
        if (zzZZN2.contains(21010)) {
            return this.zzZ4I.zzZRO();
        }
        return this.zzZ4I.zzZRP();
    }

    public void setChecked(boolean value) {
        this.zzZ4I.zzWE(value);
    }

    public boolean getDefault() {
        return this.zzZ4I.zzZRP();
    }

    public void setDefault(boolean value) {
        this.zzZ4I.zzWF(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ4I.zzZRR();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ4I.zzWG(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ4I.zzZRQ();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ4I.zzJV(zzX.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZZN zzZRW() {
        return this.zzZ4I;
    }
}

