/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.internal.zz27;
import com.aspose.words.internal.zz82;
import com.aspose.words.zzX;
import com.aspose.words.zzYSL;
import com.aspose.words.zzZP4;
import com.aspose.words.zzZQN;
import com.aspose.words.zzZWH;

public abstract class Node
implements Cloneable {
    private Node zzYC1;
    private Node zzYC0;
    private Node zzYBZ;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzY(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYC1 == null) {
            return null;
        }
        if (this.zzYC1.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYC1;
    }

    final CompositeNode zzZzh() {
        if (zzX.zzF(this.getParentNode())) {
            return this.getParentNode().zzZzh();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYC1 == null) {
            return null;
        }
        return this.zzYC1.getDocument();
    }

    final Document zzZzg() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZzf() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz5p();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYBZ;
    }

    final Node zzZze() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzX.zzN(node)) {
        }
        return node;
    }

    final Node zzZzd() {
        Node node = zzX.zzW(this.getPreviousSibling(), false);
        if (node == null && zzX.zzF(this.getParentNode())) {
            node = this.getParentNode().zzZzd();
        }
        return node;
    }

    final Node zzZzc() {
        Node node = zzX.zzX(this.getNextSibling(), false);
        if (node == null && zzX.zzF(this.getParentNode())) {
            node = this.getParentNode().zzZzc();
        }
        return node;
    }

    final CompositeNode zzZzb() {
        Node node = this;
        while ((node = node.zzZzd()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZza() {
        Node node = this;
        while ((node = node.zzZzc()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYC0;
    }

    final Node zzZz9() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzX.zzN(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZz8() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZz7() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzP(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZz6() {
        return this.zzYC0;
    }

    final void zzZ7(Node node) {
        this.zzYC0 = node;
    }

    final Node zzZz5() {
        return this.zzYBZ;
    }

    final void zzZ6(Node node) {
        this.zzYBZ = node;
    }

    final Node zzZz4() {
        Node node = this;
        if (node.zzYC0 != null) {
            node = this;
            return node.zzYC0;
        }
        return this.getParentNode();
    }

    final int zzZz3() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzX.zzH(this);
        boolean bl2 = zzX.zzL(this);
        boolean bl3 = zzX.zzI(this);
        boolean bl4 = zzX.zzJ(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZz3() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZz3() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZP4 zzZP42) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYC1 != null) {
            node.zzYC1 = this.getDocument().zz48();
        }
        node.zzYC0 = null;
        node.zzYBZ = null;
        if (zzZP42 != null) {
            zzZP42.zzT(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzV(StringBuilder stringBuilder) {
        com.aspose.words.internal.zzX.zzY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZ5(Node node) {
        this.zzYC1 = node != null ? node : this.getDocument().zz48();
    }

    final void zzY(DocumentBase documentBase) {
        this.zzYC1 = documentBase != null ? documentBase.zz48() : null;
    }

    final boolean zzZ4(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzFw(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzFv(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzU2(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZQN zzZQN2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZQN2 = new zzZWH();
                break;
            }
            case 70: {
                zzZQN2 = new zzYSL();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQN zzZQN3 = zzZQN2;
        return zzZQN2.zzZl(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZQN zzZQN2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZQN2 = new zzZWH((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZQN2 = new zzYSL((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQN zzZQN3 = zzZQN2;
        return zzZQN2.zzZl(this);
    }

    final Node zzFu(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzM(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZ3(Node node) {
        zz82<Node> zz822;
        Node node2 = node;
        Node node3 = this;
        if (node3 == null || node2 == null) {
            return false;
        }
        zz82<Node> zz823 = Node.zzZ2(node3);
        Node node4 = Node.zzZ(zz823, zz822 = Node.zzZ2(node2));
        if (node4 != null) {
            zz82<Node> zz824 = zz823;
            if (zz824.size() == 0 || (zz824 = zz822).size() == 0) {
                zz824 = zz822;
                boolean bl = zz824.size() > 0;
                return bl;
            }
            Object e = zz823.peek();
            Object e2 = zz822.peek();
            for (Node node5 : ((CompositeNode)node4).getChildNodes()) {
                if (node5 == e) {
                    return true;
                }
                if (node5 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    static Node zzH(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zz82<Node> zz822 = Node.zzZ2(node);
        zz82<Node> zz823 = Node.zzZ2(node2);
        return Node.zzZ(zz822, zz823);
    }

    private static zz82<Node> zzZ2(Node node) {
        zz82<Node> zz822 = new zz82<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz822.push(node2);
        }
        return zz822;
    }

    private static Node zzZ(zz82<Node> zz822, zz82<Node> zz823) {
        Node node = null;
        while (zz822.peek() == zz823.peek()) {
            node = (Node)zz822.pop();
            zz823.pop();
            zz82<Node> zz824 = zz822;
            if (zz824.size() != 0 && (zz824 = zz823).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = Node.nodeTypeToString(this.getNodeType());
        Node node = this;
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null && node2.getParentNode() != null; node2 = node2.getParentNode()) {
            int n = 0;
            for (Node node3 = node2.getParentNode().getFirstChild(); node3 != null && node3 != node2; node3 = node3.getNextSibling()) {
                ++n;
            }
            com.aspose.words.internal.zzX.zzZ(stringBuilder, "{0}{1}", node2 == node ? "" : ".", n);
        }
        objectArray[1] = zz27.trim(stringBuilder.toString());
        return zz27.trim(zz27.format("{0} {1}", objectArray));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

