/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzX;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzZEV;
import com.aspose.words.zzZFC;
import com.aspose.words.zzZFI;
import com.aspose.words.zzZP3;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZP3,
Iterable<T> {
    private CompositeNode zzYBR;
    private DocumentBase zzZY8;
    private boolean zzZbj;
    private int zzYBQ;
    private int zzYBP;
    private Node zzYBO;
    private int zzZG;
    private zzZFC zzYBN;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZEV(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZEV(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZFC matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYBR = container;
        this.zzZY8 = container.getDocument();
        this.zzYBN = matcher;
        this.zzZbj = isDeep;
        this.invalidate();
    }

    public Node get(int index) {
        try {
            Node node;
            Node node2;
            block7: {
                boolean bl;
                int n;
                this.zzZyY();
                if (index < 0 && (index = this.getCount() + index) < 0) {
                    return null;
                }
                if (this.zzYBP == index) {
                    return this.zzYBO;
                }
                int n2 = n = index - this.zzYBP;
                Node node3 = this.zzYBO;
                NodeCollection nodeCollection = this;
                boolean bl2 = bl = n2 > 0;
                if (n2 < 0) {
                    n2 = -n2;
                }
                Node node4 = node3;
                for (int i = 0; i < n2; ++i) {
                    Ref<Node> ref = new Ref<Node>(node4);
                    nodeCollection.zzZ(ref, bl);
                    node4 = ref.get();
                    if (node4 != null) continue;
                    node2 = null;
                    break block7;
                }
                node2 = node = node4;
            }
            if (node2 != null) {
                this.zzYBP = index;
                this.zzYBO = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZbj) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYBR.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZbj) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYBR.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZyZ();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZFI(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzZyZ() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzX.zzZ(arrayList, node);
        }
        return arrayList;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) throws Exception {
        return this.zzZ(curNode, true);
    }

    private Node zzZ(Ref<Node> ref, boolean bl) throws Exception {
        Node node;
        ref.get();
        do {
            Node node2;
            NodeCollection nodeCollection;
            boolean bl2;
            Node node3;
            node = ref.get();
            if (this.zzZbj) {
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                node2 = bl2 ? node3.nextPreOrder(nodeCollection.zzYBR) : node3.previousPreOrder(nodeCollection.zzYBR);
            } else if (this.zzYBN.zzrZ()) {
                Node node4;
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                if (bl2) {
                    node4 = node3 == nodeCollection.zzYBR ? nodeCollection.zzYBR.zzr6() : node3.zzZzc();
                } else {
                    Node node5 = node4 = node3 == nodeCollection.zzYBR ? nodeCollection.zzYBR.zzr5() : node3.zzZzd();
                }
                if (node4 == nodeCollection.zzYBR.getNextSibling() || node4 == nodeCollection.zzYBR.getPreviousSibling()) {
                    node4 = null;
                }
                node2 = node4;
            } else {
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                node2 = bl2 ? (node3 == nodeCollection.zzYBR ? nodeCollection.zzYBR.getFirstChild() : node3.getNextSibling()) : (node3 == nodeCollection.zzYBR ? nodeCollection.zzYBR.getLastChild() : node3.getPreviousSibling());
            }
            ref.set(node2);
        } while (ref.get() != null && !this.zzYBN.zzf(ref.get()));
        return node;
    }

    private void zzZyY() {
        if (this.zzYBQ != this.zzZyX()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.zzYBQ = this.zzZyX();
        this.zzYBP = -1;
        this.zzYBO = this.zzYBR;
        this.zzZG = -1;
    }

    private int zzZyX() {
        if (this.zzZY8 != null) {
            return this.zzZY8.zz49();
        }
        return 0;
    }

    public int getCount() {
        this.zzZyY();
        if (this.zzZG == -1) {
            this.zzZG = zzZFI.zzZ(this);
        }
        return this.zzZG;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYBR;
    }
}

