/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz6S;
import com.aspose.words.internal.zzRI;

public abstract class SaveOptions {
    private boolean zzY7C = false;
    private boolean zzY7B = true;
    private boolean zzF3;
    private String zzY7A;
    private boolean zzY7z;
    private boolean zzY7y = false;
    private boolean zzY7x = true;
    private int zzY7w = 1;
    private int zzYUh = 0;
    private int zzE7 = 0;
    private String zzY7v = "";
    private boolean zzY7u = true;
    private boolean zzY7t = true;
    private boolean zzY7s;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZNB() {
        return false;
    }

    boolean zzZTu() {
        return true;
    }

    final boolean zzZiZ() {
        return this.zzY7B;
    }

    public String getTempFolder() {
        return this.zzY7A;
    }

    public void setTempFolder(String value) {
        this.zzY7A = value;
    }

    public boolean getPrettyFormat() {
        return this.zzF3;
    }

    public void setPrettyFormat(boolean value) {
        this.zzF3 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzY7z;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzY7z = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzY7y;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzY7y = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzY7x;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzY7x = value;
    }

    public int getColorMode() {
        return this.zzE7;
    }

    public void setColorMode(int value) {
        this.zzE7 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY7w;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY7w = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYUh;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYUh = value;
    }

    public String getDefaultTemplate() {
        return this.zzY7v;
    }

    public void setDefaultTemplate(String value) {
        this.zzY7v = value;
    }

    public boolean getUpdateFields() {
        return this.zzY7u;
    }

    public void setUpdateFields(boolean value) {
        this.zzY7u = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzY7s;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzY7s = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzY7C;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzY7C = value;
    }

    final boolean zzZiY() {
        return this.zzY7t;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzKA(zzRI.zzg(zz6S.zzXG(fileName))));
    }
}

