/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Story;
import com.aspose.words.internal.zzX;
import com.aspose.words.zzYZ2;
import com.aspose.words.zzZOG;
import com.aspose.words.zzZP4;

public final class Section
extends CompositeNode<Node>
implements zzZOG {
    private zzYZ2 zzYuU;
    private PageSetup zzY6T;
    private HeaderFooterCollection zzY6S;

    public Section(DocumentBase doc) {
        this(doc, new zzYZ2());
    }

    Section(DocumentBase doc, zzYZ2 sectPr) {
        super(doc);
        this.zzYuU = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzY6S == null) {
            this.zzY6S = new HeaderFooterCollection(this);
        }
        return this.zzY6S;
    }

    public final PageSetup getPageSetup() {
        if (this.zzY6T == null) {
            this.zzY6T = new PageSetup(this, this.getDocument().zz40(), this.getDocument().getStyles(), new zzZ(this));
        }
        return this.zzY6T;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZr4();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzSQ(!value);
    }

    final zzYZ2 zzZvr() {
        return this.zzYuU;
    }

    final void zzY(zzYZ2 zzYZ22) {
        this.zzYuU = zzYZ22;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZP4 zzZP42) {
        zzYZ2 zzYZ22;
        Section section = (Section)super.zzZ(bl, zzZP42);
        section.zzYuU = zzYZ22 = (zzYZ2)this.zzYuU.zzy3();
        section.zzY6T = null;
        section.zzY6S = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzW(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzW(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzAl(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzg(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzAl(n) == null;
            }
        }
        return false;
    }

    private void zzW(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYuU.zzTA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz40().zzZqq.zzTz(key);
        }
        return zzYZ2.zzT9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYuU.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz40().zzZqq.zzT(key, value);
            return;
        }
        this.zzYuU.zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYuU.clear();
    }

    final boolean zzZij() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZii() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzZ
    implements zzZOG {
        private Section zzYuE;

        zzZ(Section section) {
            this.zzYuE = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZih().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZih().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZih().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZOG zzZih() {
            Document document = zzX.zzZ((Object)this.zzYuE.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYuE;
        }
    }
}

