/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zz80;
import com.aspose.words.internal.zzMM;
import com.aspose.words.internal.zzMN;
import com.aspose.words.internal.zzMU;
import com.aspose.words.internal.zzZF;
import com.aspose.words.zzX;
import com.aspose.words.zzYJ;
import com.aspose.words.zzYU3;
import com.aspose.words.zzYU9;
import com.aspose.words.zzYUC;
import com.aspose.words.zzYUF;
import com.aspose.words.zzZLN;
import com.aspose.words.zzZP4;
import com.aspose.words.zzZYA;
import com.aspose.words.zzZZM;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzXYw;
    private zzYU3 zzZnv;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        return (Row)this.zzr4();
    }

    public Row getLastRow() {
        return (Row)this.zzr3();
    }

    public RowCollection getRows() {
        if (this.zzXYw == null) {
            this.zzXYw = new RowCollection(this);
        }
        return this.zzXYw;
    }

    final boolean zzZaL() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZP4 zzZP42) {
        Table table = (Table)super.zzZ(bl, zzZP42);
        if (this.zzZnv != null) {
            table.zzZnv = (zzYU3)this.zzZnv.zzy3();
        }
        table.zzXYw = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXD(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzvU().zzuX();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZza();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZza();
        }
        return n;
    }

    final zzZLN zzZaK() {
        zzYU9 zzYU92 = new zzYU9(this);
        return zzYU92.zzZ9y();
    }

    final void zzZaJ() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZno()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzvW()) {
                switch (cell2.zzvU().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzvU().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cell cell3;
                            cell.zzvU().setWidth(cell.zzvU().getWidth() + cell2.zzvU().getWidth());
                            cell.zzvU().zzTa(cell.zzvU().zzuX() + cell2.zzvU().zzuX());
                            if (cell2.zzvU().getWidth() != 0 && cell.zzvU().getPreferredWidth().zzzY() && cell2.zzvU().getPreferredWidth().zzzY()) {
                                int n = cell.zzvU().getPreferredWidth().zzZp0() + cell2.zzvU().getPreferredWidth().zzZp0();
                                cell.zzvU().setPreferredWidth(PreferredWidth.zzCx(n));
                            }
                            if ((Cell)(cell3 = cell2).zzZza() == null || ((Cell)(cell3 = cell2).zzZza()).zzvU().getHorizontalMerge() != 2) {
                                Object object = cell2.zzvU().zzTA(3140);
                                if (object != null) {
                                    cell.zzvU().zzT(3140, object);
                                } else {
                                    cell.zzvU().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzvU().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZaI() {
        this.zzyQ(0);
        if (this.zzZaF()) {
            this.zzyQ(1);
        }
    }

    private void zzyQ(int n) {
        Object object;
        if (this.getFirstRow() == null) {
            return;
        }
        zzYUC zzYUC2 = new zzYUC(this, n == 1);
        if (zzYUC2.zzuE().length == 0) {
            return;
        }
        zzMN zzMN2 = new zzMN();
        zzMM zzMM2 = new zzMM();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYUC2.zzD((Row)compositeNode);
            zzMN zzMN3 = new zzMN();
            zzMM<Object> zzMM3 = new zzMM<Object>();
            int n2 = zzYUC2.zzZe0();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n3 = zzYUC2.zzZ9W();
                if (Table.zzY((Cell)object2, n) != 0) {
                    boolean bl;
                    int n4 = zzMN2.get(n2);
                    if (zzMN.zzXf(n4)) {
                        n4 = 1;
                    }
                    if (n4 != n3 && n4 != ((Cell)object2).zzvU().zzuX()) {
                        ((Cell)object2).zzvU().zzZ(3030, 1, n);
                    }
                    if (bl = !((Row)compositeNode).zz3I().zzWT(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n5 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        ((Row)compositeNode2).zz3I().zzT(4120, new zzZYA(0, n5));
                    }
                    zzMN3.set(n2, n3);
                    zzMM3.set(n2, object2);
                }
                n2 += ((Cell)object2).zzvU().zzuX();
                object = object2;
                object2 = (Cell)((Node)object).zzZza();
            }
            object2 = zzMM3.zzNj();
            while (((zzMM.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzMM.zzZ)object2).zzNh();
                if (Table.zzY(cell, n) != 2 || zzMM2.get(((zzMM.zzZ)object2).zzNl()) != null) continue;
                cell.zzvU().zzZ(3030, 1, n);
            }
            object2 = zzMM2.zzNj();
            while (((zzMM.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzMM.zzZ)object2).zzNh();
                if (Table.zzY(cell, n) != 1 || zzMM3.get(((zzMM.zzZ)object2).zzNl()) != null) continue;
                cell.zzvU().zzZ(3030, 0, n);
            }
            zzMN2 = zzMN3;
            zzMM2 = zzMM3;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZza();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (Table.zzY((Cell)compositeNode, n) == 1) {
                ((Cell)compositeNode).zzvU().zzZ(3030, 0, n);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZza();
        }
    }

    final void zzZaH() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZaK();
            }
            this.setAllowAutoFit(bl);
        }
    }

    private static int zzY(Cell cell, int n) {
        return (Integer)cell.zzvU().zzXU(3030, n);
    }

    final int zz50() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYJ zzYJ2 = row.getFirstCell().zzvU();
        boolean bl = this.isNested();
        zzYJ zzYJ3 = zzYJ2;
        zzYU3 zzYU32 = row.zz3I();
        return zzYU32.zzZEn() - zzYU32.zzY(zzYJ3, bl);
    }

    @Override
    final boolean zzg(Node node) {
        return zzX.zzJ(node);
    }

    final boolean isNested() {
        if (this.zzZzh() == null) {
            return false;
        }
        return this.zzZzh().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzyN(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzt(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzyN(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        if (value != this.getAllowAutoFit()) {
            this.zzZaD();
        }
        this.zzt(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzyN(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzt(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzyN(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzt(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzyN(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzt(4020, com.aspose.words.internal.zzX.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzyN(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzt(4320, com.aspose.words.internal.zzX.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzyN(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzt(4300, com.aspose.words.internal.zzX.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzyN(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzt(4310, com.aspose.words.internal.zzX.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzyN(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzt(4290, com.aspose.words.internal.zzX.zzU(value));
    }

    public boolean getAllowCellSpacing() {
        return this.getFirstRow().hasAttribute(4290);
    }

    public void setAllowCellSpacing(boolean value) throws Exception {
        if (value) {
            if (!this.getAllowCellSpacing()) {
                this.zzt(4290, 7);
                return;
            }
        } else {
            this.zzyP(4290);
        }
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzyN(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzt(4340, com.aspose.words.internal.zzX.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzyN(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzt(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXG(this.zzZSf(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZSf();
        Table table = this;
        table.zzt(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzJF(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzze(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYU3 zzYU32 = table.getFirstRow().zz3I();
            table.zzt(4160, 2);
            table.zzt(4190, 0);
            table.zzt(4210, 180);
            table.zzt(4270, 180);
            table.zzt(4350, false);
            int n = (Integer)zzYU32.zzTz(4010);
            if (n == 2) {
                table.zzt(4180, 3);
            } else if (n == 1) {
                table.zzt(4180, 2);
            }
            table.zzyP(4010);
            if (zzYU32.contains(4340)) {
                int n2 = (Integer)zzYU32.zzTA(4340);
                table.zzt(4170, n2 - 1);
            }
            table.zzyP(4340);
            return;
        }
        Table table = this;
        zzYU3 zzYU33 = table.getFirstRow().zz3I();
        int n = (Integer)zzYU33.zzTz(4180);
        if (n == 3) {
            table.zzt(4010, 2);
        } else if (n == 2) {
            table.zzt(4010, 1);
        }
        table.zzyP(4170);
        table.zzyP(4160);
        table.zzyP(4150);
        table.zzyP(4190);
        table.zzyP(4210);
        table.zzyP(4270);
        table.zzyP(4350);
        table.zzyP(4180);
        table.zzyP(4200);
    }

    public String getTitle() {
        return (String)this.zzyN(5000);
    }

    public void setTitle(String value) throws Exception {
        com.aspose.words.internal.zzX.zzZ((Object)value, "value");
        this.zzt(5000, value);
    }

    public String getDescription() {
        return (String)this.zzyN(5010);
    }

    public void setDescription(String value) throws Exception {
        com.aspose.words.internal.zzX.zzZ((Object)value, "value");
        this.zzt(5010, value);
    }

    public double getDistanceLeft() {
        int n = (Integer)this.zzyN(4210);
        return (double)n / 20.0;
    }

    public double getDistanceRight() {
        int n = (Integer)this.zzyN(4270);
        return (double)n / 20.0;
    }

    public double getDistanceTop() {
        int n = (Integer)this.zzyN(4220);
        return (double)n / 20.0;
    }

    public double getDistanceBottom() {
        int n = (Integer)this.zzyN(4280);
        return (double)n / 20.0;
    }

    public int getRelativeHorizontalAlignment() {
        return (Integer)this.zzyN(4180);
    }

    public int getRelativeVerticalAlignment() {
        return (Integer)this.zzyN(4200);
    }

    public int getHorizontalAnchor() {
        return (Integer)this.zzyN(4150);
    }

    public int getVerticalAnchor() {
        return (Integer)this.zzyN(4160);
    }

    public double getAbsoluteHorizontalDistance() {
        int n = (Integer)this.zzyN(4170);
        return (double)n / 20.0;
    }

    public double getAbsoluteVerticalDistance() {
        int n = (Integer)this.zzyN(4190);
        return (double)n / 20.0;
    }

    public boolean getAllowOverlap() {
        return (Boolean)this.zzyN(4350);
    }

    final int zzZSf() {
        return (Integer)this.zzyN(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz3I().isFloating();
    }

    final zzYU3 zz3I() {
        if (this.zzZnv == null) {
            this.zzZnv = new zzYU3();
        }
        return this.zzZnv;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYU3.zzZVE.zzD3().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzvU().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZza();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzvU().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZza();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzvU().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZza();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzvU().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZza();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzvU().remove(3110);
                            }
                            if (bl) {
                                cell.zzvU().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZza();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZza();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzvU().remove(3120);
                            }
                            if (bl3) {
                                cell.zzvU().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZza();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZza();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZno()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            WordAttrCollection wordAttrCollection = row.zz3I();
            for (int n : zzYU3.zzZVE.zzD2()) {
                wordAttrCollection.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                wordAttrCollection = cell.zzvU();
                for (int n : zzYJ.zzZVE.zzD2()) {
                    wordAttrCollection.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZza();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZza();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZza();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZza();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            WordAttrCollection wordAttrCollection = row.zz3I();
            wordAttrCollection.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                wordAttrCollection = cell.zzvU();
                wordAttrCollection.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZza();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZza();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzyP(4230);
                table.zzyO(3020);
                table.zzZaK();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzt(4230, PreferredWidth.fromPercent(100.0));
                table.zzyO(3020);
                table.zzZaK();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                table.zzZaD();
                Table table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    CompositeNode compositeNode;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        Object object = cell.zzvU().zzTA(3010);
                        int n = object == null ? 0 : (Integer)object;
                        if (n <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzzY()) {
                            n = preferredWidth.zzZp0();
                            cell.zzvU().setWidth(n);
                        }
                        if (n <= 0) {
                            n = 360 * cell.zzvU().zzuX();
                            cell.zzvU().zzT(3010, n);
                        }
                        cell.zzvU().setPreferredWidth(PreferredWidth.zzCx(n));
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZza();
                    }
                    compositeNode = row;
                    row = (Row)compositeNode.zzZza();
                }
                table.zzZaE();
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZaG() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzvU().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZaF() {
        for (Row row : this.getRows()) {
            if (row.zz3I().hasRevisions()) {
                return true;
            }
            for (Cell cell : row.getCells()) {
                if (!cell.zzvU().hasRevisions()) continue;
                return true;
            }
        }
        return false;
    }

    final void zzyP(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz3I().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZza();
        }
    }

    final void zzt(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZno()) {
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object2 = row2.zz3I().get(4120);
                Object object3 = row2.zz3I().get(4240);
                Object object4 = row2.zz3I().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzyO(3060);
                if (object2 != null) {
                    row2.zz3I().zzT(4120, object2);
                }
                if (object3 != null) {
                    row2.zz3I().zzT(4240, object3);
                }
                if (object4 != null) {
                    row2.zz3I().zzT(4230, object4);
                }
            }
            row.zz3I().zzT(n, object);
        }
    }

    private void zzyO(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzvU().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZza();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZza();
        }
    }

    final void zzZaE() {
        zzYUF zzYUF2 = this.zz3I().zzZ8Z();
        if (zzYUF.zzZ(zzYUF2) && this.zz3I().zzTA(5103) != null) {
            return;
        }
        zzYUC zzYUC2 = new zzYUC(this, false);
        zzYUC zzYUC3 = new zzYUC(this, true);
        this.zz3I().zzT(5103, new zzMU(zzYUC2.zzuE()));
        for (Row row : this.getRows()) {
            zzYUC2.zzD(row);
            Table.zzZ(row.zz3I(), zzYUC2);
            for (Object object : row.getCells()) {
                ((Cell)object).zzvU().zzT(3900, zzYUC2.zzZ9W());
            }
        }
        if (zzZF.zzV(zzYUC2.zzuE(), zzYUC3.zzuE())) {
            zzYU3 zzYU32 = this.zz3I();
            zzYU32.remove(10010);
            return;
        }
        if (this.zz3I().zzZtn() == null) {
            this.zz3I().zzZ(new zzZZM(new zzYU3(), "", zz80.zziG));
        }
        this.zz3I().zzZ8W().zzT(5103, new zzMU(zzYUC3.zzuE()));
        for (Row row : this.getRows()) {
            zzYU3 zzYU33 = row.zz3I().zzZ8W();
            zzYUC3.zzD(row);
            Table.zzZ(zzYU33, zzYUC3);
            for (Cell cell : row.getCells()) {
                cell.zzvU().zzuZ().zzT(3900, zzYUC3.zzZ9W());
            }
        }
    }

    private static void zzZ(zzYU3 zzYU32, zzYUC zzYUC2) {
        zzYU32.zzT(5104, zzYUC2.zzZe0());
        zzYU32.zzT(5105, zzYUC2.zzZe1());
        zzYU32.zzyx(zzYUC2.zzZDU());
        zzYU32.zzGP(zzYUC2.zzZDT());
    }

    private void zzZaD() {
        if (this.zz3I().zzZ8Z() != null) {
            this.zz3I().remove(5106);
        }
    }

    private Object zzyN(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYU3.zzT9(n);
        }
        if (n == 4005) {
            if (row.zz3I() != null) {
                return row.zz3I().zzZSf();
            }
            return zzYU3.zzT9(4005);
        }
        return row.fetchRowAttr(n);
    }
}

