/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZBL;
import com.aspose.words.internal.zzZC9;
import com.aspose.words.internal.zzZCC;
import com.aspose.words.internal.zzZCD;
import com.aspose.words.internal.zzZCV;
import com.aspose.words.internal.zzZD8;
import com.aspose.words.internal.zzZD9;
import com.aspose.words.internal.zzZDB;
import com.aspose.words.internal.zzZRG;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZBM
extends CertPathBuilderSpi {
    private final zzZCD zzWZc;
    private zzZCV zzWXa;

    zzZBM(zzZCD zzZCD2) {
        this.zzWZc = zzZCD2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZD8 pkixParams;
        if (params instanceof zzZD8) {
            pkixParams = (zzZD8)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZD8.zzZ((PKIXBuilderParameters)params).zzYTO();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZD8.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZD9 zzZD92 = pkixParams.zzYTQ().zzYTH();
        try {
            collection = zzZCC.zzZ(zzZD92, pkixParams.zzYTQ().zzYTN());
            collection.addAll(zzZCC.zzZ(zzZD92, pkixParams.zzYTQ().getCertStores()));
        }
        catch (zzZCV zzZCV2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZCV2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWXa != null) {
            throw new CertPathBuilderException(this.zzWXa.getMessage(), this.zzWXa.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ(X509Certificate x509Certificate, zzZD8 zzZD82, List list) throws CertPathBuilderException {
        zzZBL zzZBL2;
        zzZC9 zzZC92;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZD82.zzYTP().contains(x509Certificate)) {
            return null;
        }
        if (zzZD82.getMaxPathLength() != -1 && list.size() - 1 > zzZD82.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZC92 = new zzZC9(this.zzWZc);
            zzZBL2 = new zzZBL(this.zzWZc);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZCC.zzZ(x509Certificate, zzZD82.zzYTQ().getTrustAnchors(), zzZD82.zzYTQ().getSigProvider()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZC92.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZCV("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZBL2.engineValidate(certPath, zzZD82);
                }
                catch (Exception exception) {
                    throw new zzZCV("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZDB> arrayList = new ArrayList<zzZDB>();
            arrayList.addAll(zzZD82.zzYTQ().zzYTN());
            try {
                arrayList.addAll(zzZCC.zzZ(x509Certificate.getExtensionValue(zzZRG.zzXrl.getId()), zzZD82.zzYTQ().zzYTM()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZCV("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZCC.zzZ(x509Certificate, zzZD82.zzYTQ().getCertStores(), arrayList));
            }
            catch (zzZCV zzZCV2) {
                throw new zzZCV("Cannot find issuer certificate for certificate in certification path.", zzZCV2);
            }
            if (hashSet.isEmpty()) {
                throw new zzZCV("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ(x509Certificate2, zzZD82, list);
            }
        }
        catch (zzZCV zzZCV3) {
            this.zzWXa = zzZCV3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

