/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzX;
import com.aspose.words.internal.zzZ3X;
import com.aspose.words.internal.zzZV3;
import com.aspose.words.internal.zzZVS;
import com.aspose.words.internal.zzZWA;
import com.aspose.words.internal.zzZWG;
import com.aspose.words.internal.zzZWH;
import com.aspose.words.internal.zzZWI;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class zzZWX
extends zzZWG
implements zzZWA {
    private static final char[] zzXD7 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int zzXD6;

    public zzZWX(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = zzX.zzK(byArray);
        this.zzXD6 = n;
    }

    @Override
    public final String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        zzZWI zzZWI2 = new zzZWI(byteArrayOutputStream);
        try {
            zzZWI2.zzX(this);
        }
        catch (IOException iOException) {
            throw new zzZWH("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i != byArray.length; ++i) {
            stringBuffer.append(zzXD7[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(zzXD7[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public final int intValue() {
        int n = 0;
        byte[] byArray = this.data;
        if (this.zzXD6 > 0 && this.data.length <= 4) {
            byArray = zzZWX.zzF(this.data, this.zzXD6);
        }
        for (int i = 0; i != byArray.length && i != 4; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public final byte[] zzZ13() {
        if (this.zzXD6 != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return zzX.zzK(this.data);
    }

    public final byte[] getBytes() {
        return zzZWX.zzF(this.data, this.zzXD6);
    }

    public final int zzZ12() {
        return this.zzXD6;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return this.zzXD6 ^ zzX.hashCode(this.getBytes());
    }

    @Override
    protected final boolean zzZ(zzZWG zzZWG2) {
        if (!(zzZWG2 instanceof zzZWX)) {
            return false;
        }
        zzZWX zzZWX2 = (zzZWX)zzZWG2;
        return this.zzXD6 == zzZWX2.zzXD6 && zzX.zzZ(this.getBytes(), zzZWX2.getBytes());
    }

    protected static byte[] zzF(byte[] byArray, int n) {
        byte[] byArray2 = zzX.zzK(byArray);
        if (n > 0) {
            int n2 = byArray.length - 1;
            byArray2[n2] = (byte)(byArray2[n2] & 255 << n);
        }
        return byArray2;
    }

    static zzZWX zzZ(int n, InputStream inputStream) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = inputStream.read();
        byte[] byArray = new byte[n - 1];
        if (byArray.length != 0) {
            if (zzZ3X.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n2 > 0 && n2 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n2)) {
                return new zzZV3(byArray, n2);
            }
        }
        return new zzZVS(byArray, n2);
    }

    @Override
    final zzZWG zzZ11() {
        return new zzZVS(this.data, this.zzXD6);
    }

    @Override
    final zzZWG zzZ10() {
        return new zzZV3(this.data, this.zzXD6);
    }

    @Override
    abstract void zzZ(zzZWI var1) throws IOException;
}

