/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz27;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXXQ = new ArrayList();
    private final Map<String, DataColumn> zzXMF = new HashMap<String, DataColumn>();
    private DataTable zzYId;

    DataColumnCollection(DataTable table) {
        this.zzYId = table;
    }

    public void add(DataColumn column) {
        if (zz27.zzX1(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.normalize(column.getColumnName());
        if (this.zzXMF.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZ(this.zzYId);
        column.setOrdinal(this.zzXXQ.size());
        this.zzXXQ.add(column);
        this.zzXMF.put(string, column);
        this.zzYId.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYId);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zz27.zzX1(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.normalize(columnName);
        DataColumn dataColumn = this.zzXMF.get(string);
        if (dataColumn != null) {
            int n = this.zzXXQ.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXXQ.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXXQ.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXXQ.remove(n);
            this.zzXMF.remove(DataColumnCollection.normalize(dataColumn.getColumnName()));
            this.zzYId.onDataColumnDeleted(dataColumn);
        }
    }

    public int getCount() {
        return this.zzXXQ.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXXQ.iterator();
    }

    public void clear() {
        this.zzXMF.clear();
        this.zzXXQ.clear();
    }

    final DataColumn[] zzZ5s() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXXQ);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXXQ.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXXQ.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.normalize(string);
            String string3 = DataColumnCollection.normalize(dataColumn.getColumnName());
            this.zzXMF.remove(string3);
            this.zzXMF.put(string2, dataColumn);
            return;
        }
    }

    private static String normalize(String columnName) {
        return Normalizer.normalize(columnName.toLowerCase(), Normalizer.Form.NFD);
    }
}

