/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXME;
    private DataTable zzXMD;
    private DataTable zzXMC;
    private String zz96;
    private String zz95;
    private String[] zzXMB;
    private String[] zzXMA;
    private DataColumn[] zzXMz;
    private DataColumn[] zzXMy;
    private UniqueConstraint zzXMx;
    private ForeignKeyConstraint zzXMw;
    private boolean zzXMv = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXME = relationName;
        this.zzXMD = parentTable;
        this.zzXMC = childTable;
        this.zz96 = parentTable.getTableName();
        this.zz95 = childTable.getTableName();
        this.zzXMB = parentColumnNames;
        this.zzXMA = childColumnNames;
        this.zzXMz = new DataColumn[this.zzXMB.length];
        for (n = 0; n < this.zzXMB.length; ++n) {
            this.zzXMz[n] = new DataColumn(this.zzXMB[n], this.zzXMD);
        }
        this.zzXMy = new DataColumn[this.zzXMA.length];
        for (n = 0; n < this.zzXMA.length; ++n) {
            this.zzXMy[n] = new DataColumn(this.zzXMA[n], this.zzXMC);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXME = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXMz = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXMy = childColumns;
        this.zzXMv = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXMy.length; ++n) {
            DataColumn dataColumn2 = childColumns[n];
            DataColumn dataColumn3 = parentColumns[n];
            if (dataColumn3.getDataType() == dataColumn2.getDataType()) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXMB = new String[this.zzXMz.length];
        for (n = 0; n < this.zzXMz.length; ++n) {
            this.zzXMB[n] = this.zzXMz[n].getColumnName();
        }
        this.zzXMA = new String[this.zzXMy.length];
        for (n = 0; n < this.zzXMy.length; ++n) {
            this.zzXMA[n] = this.zzXMy[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXME;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXMD != null) {
            return this.zzXMD;
        }
        return this.zzXMz[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXMC != null) {
            return this.zzXMC;
        }
        return this.zzXMy[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXMB;
    }

    public String[] getChildColumnNames() {
        return this.zzXMA;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXMz;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXMy;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXMx;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXMx = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXMw;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXMw = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXME.hashCode();
        n = n * 31 + this.zz96.hashCode();
        n = n * 31 + this.zz95.hashCode();
        for (int i = 0; i < this.zzXMB.length; ++i) {
            n = n * 31 + this.zzXMB[i].hashCode();
            n = n * 31 + this.zzXMA[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzZ5r() throws InvalidConstraintException, DataException {
        UniqueConstraint uniqueConstraint;
        Constraint constraint;
        ForeignKeyConstraint foreignKeyConstraint;
        block6: {
            ForeignKeyConstraint foreignKeyConstraint2;
            Constraint constraint2;
            DataRelation dataRelation;
            ConstraintCollection constraintCollection;
            block5: {
                if (!this.zzXMv) {
                    return;
                }
                constraintCollection = this.getChildTable().getConstraints();
                dataRelation = this;
                for (Constraint constraint3 : constraintCollection) {
                    if (!(constraint3 instanceof ForeignKeyConstraint)) continue;
                    constraint2 = (ForeignKeyConstraint)constraint3;
                    if (!DataRelation.zzZ(dataRelation.getChildColumns(), ((ForeignKeyConstraint)constraint2).getColumns()) || !DataRelation.zzZ(dataRelation.getParentColumns(), ((ForeignKeyConstraint)constraint2).getRelatedColumns())) continue;
                    foreignKeyConstraint2 = constraint2;
                    break block5;
                }
                foreignKeyConstraint2 = null;
            }
            foreignKeyConstraint = foreignKeyConstraint2;
            constraintCollection = this.getParentTable().getConstraints();
            dataRelation = this;
            for (Constraint constraint3 : constraintCollection) {
                if (!(constraint3 instanceof UniqueConstraint)) continue;
                constraint2 = (UniqueConstraint)constraint3;
                if (!DataRelation.zzZ(dataRelation.getParentColumns(), ((UniqueConstraint)constraint2).getColumns())) continue;
                constraint = constraint2;
                break block6;
            }
            constraint = uniqueConstraint = null;
        }
        if (constraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

