/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Glyph;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzY8i;

public class Cluster {
    private int[] zzVX;
    private Glyph[] zzXfs;

    public Cluster(int[] codepoints, Glyph[] glyphs) {
        this.zzVX = codepoints;
        this.zzXfs = glyphs;
    }

    public int[] getCodepoints() {
        return this.zzVX;
    }

    public int getCodepointsLength() {
        return this.getCodepoints().length;
    }

    public Glyph[] getGlyphs() {
        return this.zzXfs;
    }

    public float getWidth(int em, float fontSize) {
        float f = 0.0f;
        for (Glyph glyph : this.getGlyphs()) {
            float f2 = (float)em / fontSize;
            float f3 = (float)glyph.getAdvance() / f2;
            f += f3;
        }
        return f;
    }

    public static String getString(Cluster[] clusters) {
        StringBuilder stringBuilder = new StringBuilder(clusters.length);
        Cluster[] clusterArray = clusters;
        int n = clusters.length;
        for (int i = 0; i < n; ++i) {
            Cluster cluster = clusterArray[i];
            for (int n2 : cluster.getCodepoints()) {
                zz4M.zzXyV(stringBuilder, zzY8i.zzW99(n2));
            }
        }
        return stringBuilder.toString();
    }

    public Cluster deepClone() {
        int[] nArray = new int[this.getCodepoints().length];
        Glyph[] glyphArray = new Glyph[this.getGlyphs().length];
        System.arraycopy(this.getCodepoints(), 0, nArray, 0, this.getCodepoints().length);
        for (int i = 0; i < this.getGlyphs().length; ++i) {
            glyphArray[i] = this.getGlyphs()[i].deepClone();
        }
        return new Cluster(nArray, glyphArray);
    }
}

