/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzWEL;
import com.aspose.words.internal.zzWbf;
import com.aspose.words.internal.zzXD8;
import com.aspose.words.internal.zzY2T;
import com.aspose.words.internal.zzYDd;
import com.aspose.words.internal.zzYTZ;
import com.aspose.words.internal.zzYV3;
import com.aspose.words.internal.zzYl1;
import com.aspose.words.internal.zzYpJ;
import com.aspose.words.internal.zzZbC;
import com.aspose.words.internal.zzpI;
import com.aspose.words.zz0U;
import com.aspose.words.zzOq;
import com.aspose.words.zzPG;
import com.aspose.words.zzWG8;
import com.aspose.words.zzXdN;
import com.aspose.words.zzY9Y;
import com.aspose.words.zzYJS;
import com.aspose.words.zzhC;
import com.aspose.words.zzlr;
import com.aspose.words.zzqQ;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzAF(zzYpJ zzYpJ2, zzYpJ zzYpJ3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zz4M.zzXyV((Object)zzYpJ2, "srcStream");
        zz4M.zzXyV((Object)zzYpJ3, "dstStream");
        zz4M.zzXyV((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzXyV(zzYpJ2, zzYpJ3, certificateHolder, signOptions);
        zzYpJ3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzAF(zzYpJ.zzXyV(srcStream), (zzYpJ)zzYpJ.zzYD3(dstStream), certHolder, signOptions);
    }

    private static void zzXyV(zzYpJ zzYpJ2, zzYpJ zzYpJ3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYD3(digitalSignature);
        }
        if (zzhC.zzYJe(zzYpJ2)) {
            DigitalSignatureUtil.zzAF(zzYpJ2, zzYpJ3, digitalSignature, true);
            return;
        }
        zzhC zzhC2 = new zzhC();
        zzYpJ zzYpJ4 = zzYpJ2;
        zzhC zzhC3 = zzhC2;
        FileFormatInfo fileFormatInfo = zzhC2.zzXyV(zzYpJ4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYDd zzYDd2 = new zzYDd(zzYpJ2);
                int n = fileFormatInfo.zzXTN() == 1 ? 1 : 2;
                zzY9Y.zzAF(zzYDd2, digitalSignature, n);
                zzYpJ3.zz4M(0L);
                zzYDd2.zzYXB(zzYpJ3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzAF(fileFormatInfo.zzZLh(), zzYpJ3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzAF(zzYpJ2, zzYpJ3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzAF(zzYpJ2, zzYpJ3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zz4M.zzAF(srcFileName, "srcFileName");
        zz4M.zzAF(dstFileName, "dstFileName");
        try (zzYl1 zzYl12 = zz4M.zzXyV(srcFileName, 3, 1);){
            try (zzYl1 zzYl13 = zz4M.zzXyV(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzAF((zzYpJ)zzYl12, (zzYpJ)zzYl13, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzWEL zzWEL2 = zzYpJ.zzYD3(dstStream);
        zzYpJ zzYpJ2 = zzYpJ.zzXyV(srcStream);
        DigitalSignatureUtil.zzAF(zzYpJ2, (zzYpJ)zzWEL2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzYl1 zzYl12 = zz4M.zzXyV(srcFileName, 3, 1);){
            try (zzYl1 zzYl13 = zz4M.zzXyV(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXqe(zzYl12, zzYl13);
            }
            return;
        }
    }

    private static void zzXqe(zzYpJ zzYpJ2, zzYpJ zzYpJ3) throws Exception {
        zzhC zzhC2 = new zzhC();
        zzYpJ zzYpJ4 = zzYpJ2;
        zzhC zzhC3 = zzhC2;
        FileFormatInfo fileFormatInfo = zzhC2.zzXyV(zzYpJ4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYDd zzYDd2 = new zzYDd(zzYpJ2);
                zzYDd2.zzYyJ().zzWa1("_xmlsignatures");
                zzYDd2.zzYyJ().zzWa1("_signatures");
                zzYpJ3.zzZHB(0L);
                zzYDd2.zzYXB(zzYpJ3);
                zzYpJ zzYpJ5 = zzYpJ3;
                zzYpJ5.zz4M(zzYpJ5.zzX7I());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzpI zzpI2 = new zzpI(zzYpJ2);
                zzYTZ zzYTZ2 = zzpI2.zzAF(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzYTZ2 != null) {
                    for (zzWbf zzWbf2 : zzYTZ2.zzYVV()) {
                        String string = zzYTZ2.zzAF(zzWbf2);
                        zzpI2.zzYmL().remove(string);
                    }
                    zzpI2.zzYmL().remove(zzYTZ2.getName());
                    zzWbf zzWbf3 = zzpI2.zzYVV().zzYla("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzpI2.zzYVV().remove(zzWbf3.getId());
                    zzpI2.zzYZh();
                }
                zzYpJ3.zzZHB(0L);
                zzpI2.zzYXB(zzYpJ3);
                zzYpJ zzYpJ6 = zzYpJ3;
                zzYpJ6.zz4M(zzYpJ6.zzX7I());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXqe(zzYpJ.zzXyV(srcStream), zzYpJ.zzYD3(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzYl1 zzYl12 = zz4M.zzXyV(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzW99(zzYl12);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzW99(zzYpJ zzYpJ2) throws Exception {
        if (zzhC.zzYJe(zzYpJ2)) {
            return DigitalSignatureUtil.zzZ4o(zzYpJ2);
        }
        zzhC zzhC2 = new zzhC();
        zzYpJ zzYpJ3 = zzYpJ2;
        zzhC zzhC3 = zzhC2;
        FileFormatInfo fileFormatInfo = zzhC2.zzXyV(zzYpJ3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzYpJ2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzW99(zzYpJ.zzXyV(stream));
    }

    static zzZbC zzAF(zzYDd zzYDd2, String string) throws Exception {
        zz0U zz0U2 = new zz0U(zzYDd2);
        if (zz0U2.zzWCV()) {
            zzZbC zzZbC2 = zz0U2.zzXsU(string);
            return zzZbC2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzVd(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXD8.zzXyV("Unexpected digest algorithm: {0}.", n));
    }

    static String zzRB(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzVd(n);
    }

    private static void zzAF(zzYpJ zzYpJ2, zzYpJ zzYpJ3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzpI zzpI2 = new zzpI(zzYpJ2);
        zzWG8 zzWG82 = bl ? new zzlr(zzpI2) : new zzPG(zzpI2);
        zzWG82.zzXyV(digitalSignature);
        zzYpJ3.zz4M(0L);
        zzpI2.zzYXB(zzYpJ3);
    }

    private static void zzAF(zzYpJ zzYpJ2, zzYpJ zzYpJ3, DigitalSignature digitalSignature) throws Exception {
        zzYJS zzYJS2 = new zzYJS(zzYpJ2);
        zzqQ zzqQ2 = new zzqQ(zzYJS2);
        zzqQ2.zzXyV(digitalSignature);
        zzYpJ3.zz4M(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzYpJ zzYpJ4 = zzYpJ3;
        zzYJS zzYJS3 = zzYJS2;
        zzYJS3.zzAF(zzYpJ4, string, null);
    }

    private static void zzAF(zzYDd zzYDd2, zzYpJ zzYpJ2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZbC zzZbC2 = DigitalSignatureUtil.zzAF(zzYDd2, string);
        zzZbC zzZbC3 = new zzZbC();
        DigitalSignatureUtil.zzAF((zzYpJ)zzZbC2, (zzYpJ)zzZbC3, digitalSignature, false);
        zzYDd zzYDd3 = zz0U.zzYD3(zzZbC3, string);
        zzYDd3.zzYXB(zzYpJ2);
    }

    private static DigitalSignatureCollection zzZ4o(zzYpJ zzYpJ2) throws Exception {
        zzYpJ2.zzZHB(0L);
        zzpI zzpI2 = new zzpI(zzYpJ2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzYTZ zzYTZ2 = zzpI2.zzAF(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzYTZ2 != null) {
            for (zzWbf zzWbf2 : zzYTZ2.zzYVV()) {
                String string = zzYTZ2.zzAF(zzWbf2);
                zzYTZ zzYTZ3 = zzpI2.zzYJN(string);
                zzYTZ zzYTZ4 = zzpI2.zzAF(zzYTZ3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzY2T zzY2T2 = zzYV3.zzko(zzYTZ4.zzxQ().zzWQZ());
                zzOq.zzAF(zzYTZ3.zzYS5(), zzY2T2, new zzXdN(zzpI2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

