/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzYVi;
import com.aspose.words.internal.zzZKY;

public abstract class SaveOptions {
    private boolean zzm3 = true;
    private boolean zzWGZ = false;
    private boolean zzWYO = true;
    private boolean zzZ81;
    private String zzZyP;
    private boolean zzWca;
    private boolean zzYeA = false;
    private boolean zzWsu = true;
    private int zzHR = 1;
    private int zzXAX = 0;
    private String zzXGa = "";
    private boolean zzXEn = true;
    private boolean zzZSP = true;
    private boolean zzXDH;
    private boolean zzWm5;
    private int zzYEu = 0;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYAM() {
        return false;
    }

    boolean zzXSu() {
        return true;
    }

    final boolean zzZsw() {
        return this.zzWYO;
    }

    public String getTempFolder() {
        return this.zzZyP;
    }

    public void setTempFolder(String value) {
        this.zzZyP = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZ81;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZ81 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzWca;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzWca = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYeA;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYeA = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzWsu;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzWsu = value;
    }

    public int getDmlRenderingMode() {
        return this.zzHR;
    }

    public void setDmlRenderingMode(int value) {
        this.zzHR = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXAX;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXAX = value;
    }

    public String getDefaultTemplate() {
        return this.zzXGa;
    }

    public void setDefaultTemplate(String value) {
        this.zzXGa = value;
    }

    public boolean getUpdateFields() {
        return this.zzXEn;
    }

    public void setUpdateFields(boolean value) {
        this.zzXEn = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXDH;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXDH = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzWm5;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzWm5 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzWGZ;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzWGZ = value;
    }

    final boolean zzW6U() {
        return this.zzZSP;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXPz(zzZKY.zzWZX(zzYVi.zzY9L(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYEu;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYEu = value;
    }

    final boolean zzYji() {
        return this.zzm3;
    }
}

