/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXD8;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWyv;
import com.aspose.words.net.System.Data.zzYdl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzZVw;
    private final DataTable zzW73;
    private final AtomicInteger zzYUY;

    ConstraintCollection(DataTable table) {
        this.zzW73 = table;
        this.zzYUY = new AtomicInteger(1);
        this.zzZVw = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzXD8.zzY3q(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzZVw) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzZVw.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzYqP()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzYqP()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzAF(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzNY());
        }
        constraint.zzAF(this);
        this.zzZVw.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzW73.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzZVw.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzZVw.contains(cc);
    }

    public int getCount() {
        return this.zzZVw.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzZVw.iterator();
    }

    final DataTable getTable() {
        return this.zzW73;
    }

    final List<ForeignKeyConstraint> zzXA3() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzZVw) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzAF(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzZVw) {
            if (constraint instanceof UniqueConstraint) {
                this.zzAF((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzAF((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzAF(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzZVw) {
            if (constraint2.equals(null) || zzXD8.zzYdl(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzNY() {
        return "Constraint" + this.zzYUY.getAndIncrement();
    }

    private void zzAF(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzYdl zzYdl2 = this.zzW73.zzVP8().zzWyv(uniqueConstraint.getColumns());
        Map<String, Object> map = zzYdl2.zzXqe(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzXD8.zzXyV("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzAF(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzW73.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzW73.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzW73.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzW73.getTableName())) {
            return;
        }
        if (!ConstraintCollection.zzXyV(foreignKeyConstraint, dataRow)) {
            DataTable dataTable = foreignKeyConstraint.getRelatedTable();
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
            DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
            object = dataTable;
            if (!zzWyv.zzAF(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                    stringBuilder.append(zzXD8.zzXyV("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
                }
                throw new InvalidConstraintException(stringBuilder.toString());
            }
        }
    }

    private static boolean zzXyV(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) {
        boolean bl = false;
        for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
            Object object = dataRow.get(dataColumn);
            if (object == null || object == DBNull.Value) continue;
            bl = true;
            break;
        }
        return !bl;
    }
}

