/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXD8;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXS8 = new ArrayList();
    private final Map<String, DataColumn> zzWan = new HashMap<String, DataColumn>();
    private DataTable zzW73;

    DataColumnCollection(DataTable table) {
        this.zzW73 = table;
    }

    public void add(DataColumn column) {
        if (zzXD8.zzY3q(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzXxv(column.getColumnName());
        if (this.zzWan.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzXyV(this.zzW73);
        column.setOrdinal(this.zzXS8.size());
        this.zzXS8.add(column);
        this.zzWan.put(string, column);
        this.zzW73.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzW73);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXD8.zzY3q(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzXxv(columnName);
        DataColumn dataColumn = this.zzWan.get(string);
        if (dataColumn != null) {
            int n = this.zzXS8.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXS8.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXS8.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXS8.remove(n);
            this.zzWan.remove(DataColumnCollection.zzXxv(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzW73.getRows()) {
                dataRow.remove(n);
            }
            this.zzW73.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzXS8.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXS8.iterator();
    }

    public void clear() {
        this.zzWan.clear();
        this.zzXS8.clear();
    }

    final DataColumn[] zzXdb() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXS8);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzAF(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXS8.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXS8.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzXxv(string);
            String string3 = DataColumnCollection.zzXxv(dataColumn.getColumnName());
            this.zzWan.remove(string3);
            this.zzWan.put(string2, dataColumn);
            return;
        }
    }

    private static String zzXxv(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

