/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzuO;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYX6;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzYX6 zzW4f;

    BorderCollection(zzYX6 parent) {
        this.zzW4f = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzWCy.zzW3B(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzXx0().equals(brColl.zzXx0()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzW4f.getPossibleBorderKeys().zzWPL(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzW4f.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzW4f, borderKey);
            this.zzW4f.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzW4f.getPossibleBorderKeys().zzZrQ().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzW4f.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzW4f.getPossibleBorderKeys().zzZrQ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWZq(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzW4f.getPossibleBorderKeys().zzZrQ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWZq(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzXx0().zzXme();
    }

    public final void setColor(Color value) throws Exception {
        this.zzWhx(zzuO.zzD8(value));
    }

    private zzuO zzXx0() throws Exception {
        return this.get(0).zzXx0();
    }

    private void zzWhx(zzuO zzuO2) throws Exception {
        Iterator iterator = this.zzW4f.getPossibleBorderKeys().zzZrQ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWZq(n)) continue;
            this.getByBorderType(n).zzWhx(zzuO2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzW4f.getPossibleBorderKeys().zzZrQ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWZq(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzW4f.getPossibleBorderKeys().zzZrQ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWZq(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzWPL(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzWZq(int n) {
        return n != 6 && n != 7;
    }

    static final class zzWPL
    implements Iterator<Border> {
        private BorderCollection zzZ6j;
        private int zzXlm;

        zzWPL(BorderCollection borderCollection) {
            this.zzZ6j = borderCollection;
            this.zzXlm = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzXlm >= this.zzZ6j.getCount() - 1) {
                return false;
            }
            ++this.zzXlm;
            return true;
        }

        private Border zzl1() {
            try {
                return this.zzZ6j.get(this.zzXlm);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzl1();
        }
    }
}

