/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.zzJ3;
import com.aspose.words.zzWjH;
import com.aspose.words.zzWne;
import com.aspose.words.zzXHZ;
import com.aspose.words.zzXOZ;
import com.aspose.words.zzXuW;
import com.aspose.words.zzYBN;
import com.aspose.words.zzYGb;
import com.aspose.words.zzYkS;
import com.aspose.words.zzZm;

public class Cell
extends CompositeNode<Node>
implements zzJ3,
zzWne {
    private zzXHZ zzWML;
    private CellFormat zzqD;
    private ParagraphCollection zzR4;
    private TableCollection zzkR;

    public Cell(DocumentBase doc) {
        this(doc, new zzXHZ());
    }

    Cell(DocumentBase doc, zzXHZ cellPr) {
        super(doc);
        this.zzWML = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZ7E() {
        return (Cell)this.zzXgj();
    }

    public Row getParentRow() {
        return (Row)this.zzXuf();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzXiw() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzD8(this, true);
        }
        return -1;
    }

    final int zzYmp() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYmp();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzqD == null) {
            this.zzqD = new CellFormat(this);
        }
        return this.zzqD;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzR4 == null) {
            this.zzR4 = new ParagraphCollection(this);
        }
        return this.zzR4;
    }

    public TableCollection getTables() {
        if (this.zzkR == null) {
            this.zzkR = new TableCollection(this);
        }
        return this.zzkR;
    }

    final zzXHZ zzWRm() {
        return this.zzWML;
    }

    final void zzWPL(zzXHZ zzXHZ2) {
        this.zzWML = zzXHZ2;
    }

    @Override
    final Node zzWPL(boolean bl, zzYkS zzYkS2) {
        zzXHZ zzXHZ2;
        Cell cell = (Cell)super.zzWPL(bl, zzYkS2);
        zzXHZ zzXHZ3 = this.zzWML;
        cell.zzWML = zzXHZ2 = (zzXHZ)zzXHZ3.zzVT0();
        cell.zzqD = null;
        cell.zzR4 = null;
        cell.zzkR = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWPL(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzD8(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzYBN.zzZFp(this);
    }

    @Override
    final boolean zzWgK(Node node) {
        return zzYGb.zzZXg(node);
    }

    final int zzZsy() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzXgj();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWML.zzX1u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWML.zzX1u(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZm zzZm2 = zzWCy.zzWPL(object, zzZm.class);
        if (zzZm2 != null && zzZm2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYBG(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXHZ.zzYaq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWML.zzVR1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWML.clear();
    }

    private Object zzYBG(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWCy.zzWPL((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWPL(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXuW getInsertRevision() {
        Cell cell = this;
        return cell.zzWML.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXuW value) {
        Cloneable cloneable = this;
        zzXuW zzXuW2 = value;
        cloneable = cloneable.zzWML;
        ((zzWjH)cloneable).zzVR1(14, zzXuW2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXuW getDeleteRevision() {
        Cell cell = this;
        return cell.zzWML.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXuW value) {
        Cloneable cloneable = this;
        zzXuW zzXuW2 = value;
        cloneable = cloneable.zzWML;
        ((zzWjH)cloneable).zzVR1(12, zzXuW2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXOZ getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWML.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzXOZ value) {
        Cloneable cloneable = this;
        zzXOZ zzXOZ2 = value;
        cloneable = cloneable.zzWML;
        ((zzWjH)cloneable).zzVR1(13, zzXOZ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXOZ getMoveToRevision() {
        Cell cell = this;
        return cell.zzWML.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzXOZ value) {
        Cloneable cloneable = this;
        zzXOZ zzXOZ2 = value;
        cloneable = cloneable.zzWML;
        ((zzWjH)cloneable).zzVR1(15, zzXOZ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWML.remove(13);
        cell = this;
        cell.zzWML.remove(15);
    }

    final zzXHZ zzZUb(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXHZ zzXHZ2 = new zzXHZ();
        this.zzWPL(3120, zzXHZ2);
        this.zzWPL(3140, zzXHZ2);
        this.zzWPL(3110, zzXHZ2);
        this.zzWPL(3130, zzXHZ2);
        this.zzWPL(3090, zzXHZ2);
        this.zzWPL(3100, zzXHZ2);
        this.zzWPL(3070, zzXHZ2);
        this.zzWPL(3080, zzXHZ2);
        if (bl && (tableStyle = zzWCy.zzWPL((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzD8(this, zzXHZ2);
        }
        this.zzWML.zzD8((zzWjH)zzXHZ2);
        return zzXHZ2;
    }

    private void zzWPL(int n, zzXHZ zzXHZ2) {
        zzXHZ2.zzVR1(n, this.fetchInheritedCellAttr(n));
    }
}

