/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzlR;
import com.aspose.words.zzWXA;
import com.aspose.words.zzWo9;
import com.aspose.words.zzWto;
import com.aspose.words.zzWuk;
import com.aspose.words.zzWv1;
import com.aspose.words.zzX3l;
import com.aspose.words.zzXpo;
import com.aspose.words.zzY3m;
import com.aspose.words.zzYzX;
import com.aspose.words.zzZRN;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZRN zzYCf;

    ChartSeriesCollection(zzZRN dmlChart) {
        this.zzYCf = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYCf.zzYUT().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYCf.zzYUT().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYCf.zzYUT().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYCf.zzYUT().clear();
        this.zzVSA(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWPL(seriesName, values);
        chartSeries.zzXKI().zzVTQ(ChartSeriesCollection.zzW3B(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWPL(seriesName, yValues);
        chartSeries.zzXKI().zzVTQ(ChartSeriesCollection.zzVTQ(xValues));
        return chartSeries;
    }

    private ChartSeries zzWPL(String string, zzlR[] zzlRArray, double[] dArray) {
        if (zzlRArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzlRArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzlRArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWPL(string, dArray);
        chartSeries.zzXKI().zzVTQ(ChartSeriesCollection.zzWPL(zzlRArray));
        if (!this.zzYCf.zzZrN()) {
            this.zzVSA(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWPL(seriesName, zzlR.zzWPL(dates), values);
    }

    private void zzVSA(boolean bl) {
        zzYzX zzYzX2 = zzWCy.zzWPL((Object)this.zzYCf, zzYzX.class);
        if (zzYzX2 != null && zzYzX2.zzWJ3().zzW9j()) {
            zzYzX2.zzWJ3().zzZsH().zzWmq(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzYCf.zzYwY() != 15) {
            this.zzYCf.zzZMM(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWPL(seriesName, yValues);
        chartSeries.zzXlR().zzZBm().zzWmq(3, this.zzYCf.zzFp());
        chartSeries.zzXKI().zzVTQ(ChartSeriesCollection.zzVTQ(xValues));
        if (bubbleSizes != null) {
            chartSeries.zz9().zzVTQ(ChartSeriesCollection.zzVTQ(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWPL(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzYCf);
        chartSeries.setName(string);
        this.zzWgK(chartSeries);
        chartSeries.zzXyp(this.zzYCf.zzXzT().zzWao() + 1);
        chartSeries.zzX2z(this.zzYCf.zzXzT().zzZfU() + 1);
        chartSeries.zzZZk().zzVTQ(ChartSeriesCollection.zzVTQ(dArray));
        chartSeries.zzXJb().zzVTQ(chartSeries.zzZZk().zzVXH());
        this.zzYCf.zzjn().zzXZg();
        this.zzYCf.zzVOs(chartSeries);
        return chartSeries;
    }

    private void zzWgK(ChartSeries chartSeries) {
        chartSeries.zzXlR().zzZBm().zzWmq(5, new zzWuk());
        switch (this.zzYCf.zzYwY()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWPL(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWPL(chartSeries, 5);
                ChartSeriesCollection.zzX7t(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWPL(chartSeries, 1);
                ChartSeriesCollection.zzX7t(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzWPt(chartSeries);
            }
        }
    }

    private static void zzWPt(ChartSeries chartSeries) {
        zzWuk zzWuk2 = new zzWuk();
        zzWuk2.setOutline(new zzWto());
        zzX3l zzX3l2 = new zzX3l();
        zzX3l2.zzZWH(1);
        zzWuk2.getOutline().setFill(new zzWo9(zzX3l2));
        zzWuk2.getOutline().zzZKs(19050.0);
        chartSeries.zzXlR().zzZBm().zzWmq(5, zzWuk2);
    }

    private static void zzX7t(ChartSeries chartSeries) {
        zzWuk zzWuk2 = new zzWuk();
        zzWuk2.setOutline(new zzWto());
        zzWuk2.getOutline().setFill(new zzXpo());
        zzWuk2.getOutline().setEndCap(0);
        zzWuk2.getOutline().zzZKs(19050.0);
        chartSeries.zzXlR().zzZBm().zzWmq(5, zzWuk2);
    }

    private static void zzWPL(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZe8());
        chartMarker.zzWFt().zzWmq(0, n);
        chartSeries.zzXlR().zzZBm().zzWmq(4, chartMarker);
    }

    private static zzY3m zzVTQ(double[] dArray) {
        int n = 0;
        zzY3m zzY3m2 = new zzY3m(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzY3m2.zzX7t(new zzWXA(n, d, "General"));
            }
            ++n;
        }
        zzY3m2.zzYBR(dArray.length);
        zzY3m2.zzXJv();
        return zzY3m2;
    }

    private static zzY3m zzWPL(zzlR[] zzlRArray) {
        int n = 0;
        zzY3m zzY3m2 = new zzY3m(2, false);
        zzlR[] zzlRArray2 = zzlRArray;
        int n2 = zzlRArray.length;
        for (int i = 0; i < n2; ++i) {
            zzlR zzlR2 = zzlRArray2[i];
            zzY3m2.zzX7t(new zzWXA(n++, zzlR2.zzZ4q(), "m/d/yyyy"));
        }
        zzY3m2.zzYBR(zzlRArray.length);
        zzY3m2.zzXJv();
        return zzY3m2;
    }

    private static zzY3m zzW3B(String[] stringArray) {
        int n = 0;
        zzY3m zzY3m2 = new zzY3m(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzY3m2.zzX7t(new zzWv1(n++, string));
        }
        zzY3m2.zzYBR(stringArray.length);
        zzY3m2.zzXJv();
        return zzY3m2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYCf.zzYUT().size();
    }
}

