/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzlR;
import com.aspose.words.zzVS6;
import com.aspose.words.zzWRl;
import com.aspose.words.zzXOZ;
import com.aspose.words.zzZ0T;
import com.aspose.words.zzZl;
import com.aspose.words.zzZwv;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzVS6,
zzWRl {
    private int zzYdx;
    private boolean zzEU;
    private boolean zzYyo;
    private int zzYnt;
    private int zzYBO = -1;
    private String zzWiO = "";
    private String zzVWa = "";
    private zzlR zz94 = zzlR.zzYfe;
    private zzlR zzXNO = zzlR.zzYfe;
    private CommentCollection zzXaV;

    Comment(DocumentBase doc, zzZl runPr) {
        super(doc, runPr);
        this.zzYnt = doc.zzXcd();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzlR.zzYfe);
    }

    private Comment(DocumentBase doc, String author, String initial, zzlR dateTime) {
        this(doc, new zzZl());
        this.setAuthor(author);
        this.setInitial(initial);
        zzlR zzlR2 = dateTime;
        Comment comment = this;
        this.zz94 = zzlR2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzlR.zzWPL(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzYnt;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.zzYnt;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.zzYnt = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWrA();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        Comment comment = this;
        return comment.zzYBO;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.zzY3m(value);
    }

    public final String getInitial() {
        return this.zzWiO;
    }

    public final void setInitial(String value) {
        zzWCy.zzD8((Object)value, "Initial");
        this.zzWiO = value;
    }

    final zzlR zzZKK() {
        return this.zz94;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzlR.zzVR1(comment.zz94);
    }

    final void zzYbP(zzlR zzlR2) {
        this.zz94 = zzlR2;
    }

    public final void setDateTime(Date value) {
        zzlR zzlR2 = zzlR.zzWPL(value);
        Comment comment = this;
        this.zz94 = zzlR2;
    }

    final zzlR zzXUT() {
        return this.zzXNO;
    }

    final void zz8P(zzlR zzlR2) {
        this.zzXNO = zzlR2;
    }

    public final String getAuthor() {
        return this.zzVWa;
    }

    public final void setAuthor(String value) {
        zzWCy.zzD8((Object)value, "Author");
        this.zzVWa = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzWPL(String string, String string2, zzlR zzlR2, String string3) throws Exception {
        Comment comment;
        Comment comment2 = this;
        if (comment2.zzYBO != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment3 = new Comment(this.getDocument(), string, string2, zzlR2);
        comment3.setIdInternal(zzZ0T.zzWPL(this.getDocument()));
        comment3.zzY3m(this.zzYnt);
        comment3.setText(string3);
        ArrayList arrayList = this.getReplies().zzWrw();
        CompositeNode compositeNode = this.getParentNode();
        if (arrayList.size() > 0) {
            ArrayList arrayList2 = arrayList;
            comment = (Comment)arrayList2.get(arrayList2.size() - 1);
        } else {
            comment = this;
        }
        compositeNode.insertAfter(comment3, comment);
        zzZwv zzZwv2 = new zzZwv();
        if (zzZwv2.zzD8(this.getDocument(), this.zzYnt)) {
            this.zzWPL(zzZwv2.zzW8F(), new CommentRangeStart(this.getDocument(), comment3.getId()));
            this.zzWPL(zzZwv2.zzY32(), new CommentRangeEnd(this.getDocument(), comment3.getId()));
        }
        return comment3;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzWPL(author, initial, zzlR.zzWPL(dateTime), text);
    }

    private void zzWPL(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzWCy.zzWPL(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeStart2, (Node)object);
    }

    private void zzWPL(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzWCy.zzWPL(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzYnt) break;
            object = node;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeEnd2, (Node)object);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzZwv zzZwv2 = new zzZwv();
        if (zzZwv2.zzD8(this.getDocument(), reply.getId())) {
            zzZwv2.zzW8F().remove();
            zzZwv2.zzY32().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzWrw()) {
            this.removeReply(comment);
        }
    }

    @Override
    final int zzWPL(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentStart(this);
    }

    @Override
    final int zzD8(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzQH());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzQH(), '\u0005', new zzZl());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        Comment comment;
        block4: {
            block3: {
                if (this.getDocument() == null) break block3;
                comment = this;
                if (comment.zzYBO != -1) break block4;
            }
            return null;
        }
        for (Comment comment2 : this.getDocument().getChildNodes(19, true)) {
            comment = this;
            if (comment2.getId() != comment.zzYBO) continue;
            return comment2;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzXaV == null) {
            this.zzXaV = new CommentCollection(this.getDocument(), this);
        }
        return this.zzXaV;
    }

    public final boolean getDone() {
        return this.zzYyo;
    }

    public final void setDone(boolean value) {
        this.zzYyo = value;
    }

    final int zzYWu() {
        return this.zzYBO;
    }

    final void zzY3m(int n) {
        this.zzYBO = n;
        if (this.getDocument() != null) {
            this.getDocument().zzWrA();
        }
    }

    final int zzXpI() {
        return this.zzYdx;
    }

    final void zzWbt(int n) {
        this.zzYdx = n;
    }

    final boolean zzZkx() {
        return this.zzEU;
    }

    final void zzZ4Z(boolean bl) {
        this.zzEU = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXOZ getMoveFromRevision() {
        return this.zzXsC().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzXOZ value) {
        zzXOZ zzXOZ2 = value;
        zzZl zzZl2 = this.zzXsC();
        zzZl2.zzVR1(13, zzXOZ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXOZ getMoveToRevision() {
        return this.zzXsC().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzXOZ value) {
        zzXOZ zzXOZ2 = value;
        zzZl zzZl2 = this.zzXsC();
        zzZl2.zzVR1(15, zzXOZ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzXsC().remove(13);
        this.zzXsC().remove(15);
    }

    final String zzZOM() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWYJ(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

