/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.zzVSi;
import com.aspose.words.zzVW;
import com.aspose.words.zzWY2;
import com.aspose.words.zzWp;
import com.aspose.words.zzXG8;
import com.aspose.words.zzYGb;
import com.aspose.words.zzYkS;
import com.aspose.words.zzun;
import com.aspose.words.zzzF;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzun,
Iterable<T> {
    private Node zzWVA;
    private Node zzOR;
    private Node zzDa;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWG3() {
        return this.zzZiq() != null;
    }

    final boolean zzWkq() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWZE() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzXG8) {
                return true;
            }
            CompositeNode compositeNode = zzWCy.zzWPL((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWZE()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzWVA;
    }

    public Node getLastChild() {
        return this.zzOR;
    }

    final Node zzZiq() {
        return zzYGb.zzZMM(this.getFirstChild(), false);
    }

    final Node zzZR2() {
        return zzYGb.zzWgK(this.getLastChild(), false);
    }

    final CompositeNode zzZZU() {
        return (CompositeNode)zzYGb.zzZMM(this.getFirstChild(), true);
    }

    final CompositeNode zzYOv() {
        return (CompositeNode)zzYGb.zzWgK(this.getLastChild(), true);
    }

    final Node zzcy() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYGb.zzYju((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzog() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYGb.zzYju((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWPL(boolean bl, zzYkS zzYkS2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWPL(bl, zzYkS2);
        ((CompositeNode)super.zzWPL(bl, zzYkS2)).zzOR = null;
        compositeNode.zzWVA = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zz8P(node.zzWPL(true, zzYkS2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWYJ(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzWYJ(StringBuilder stringBuilder) {
        this.zzW3B(stringBuilder);
        zzWCy.zzD8(stringBuilder, this.zzMV());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzD8(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYGb.zzYlX(nodeType);
            Node node2 = node = bl ? this.zzZiq() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYbF() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzVW.zzZa5(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzVW.zzVTQ(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWY2(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzWPL(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzWPL(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWPL(oldChild, this, null, 1);
        if (documentBase.zzVQb() && zzVSi.zzX8(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWPL(nodeChangingArgs);
        }
        Node node = this.zzWam(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzD8(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzWp.zzZXg(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zz8P(Node node) {
        node.getParentNode();
        if (this.zzOR == null) {
            node.zzW45(null);
            node.zzWVX(null);
            this.zzWVA = node;
        } else {
            node.zzW45(this.zzOR);
            node.zzWVX(null);
            this.zzOR.zzWVX(node);
        }
        this.zzOR = node;
        node.zzY4Y(this);
        return node;
    }

    final void zzWPL(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzD8(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzD8(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYGb.zzYju(node3.getNodeType())) continue;
            if (zzYGb.zzFe(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzMV().length();
    }

    String zzMV() {
        return "";
    }

    final String zzXx1() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzW3B(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzW3B(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzWYJ(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWPL(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzD8(visitor));
    }

    abstract int zzWPL(DocumentVisitor var1) throws Exception;

    abstract int zzD8(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzWgK(Node var1);

    final Node zzWPL(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWtj(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzWgK(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzzF(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzzF)object).dispose();
            }
        }
        if ((object = documentBase.zzWPL(node, null, this, 0)) != null) {
            documentBase.zzWPL((NodeChangingArgs)object);
        }
        if (this.zzOR == null) {
            node.zzW45(null);
            node.zzWVX(null);
            this.zzWVA = node;
            this.zzOR = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzD8(node, node2);
            } else {
                this.zzZa5(node, this.zzWVA);
            }
        } else if (node2 != null) {
            this.zzZa5(node, node2);
        } else {
            this.zzD8(node, this.zzOR);
        }
        node.zzY4Y(this);
        if (object != null) {
            documentBase.zzD8((NodeChangingArgs)object);
        }
        if (documentBase.zzVQb()) {
            zzVSi.zzWPL(node, compositeNode, node3);
        }
        return node;
    }

    private void zzD8(Node node, Node node2) {
        Node node3 = node2.zzWS7();
        node.zzW45(node2);
        node.zzWVX(node3);
        node2.zzWVX(node);
        if (node3 == null) {
            this.zzOR = node;
            return;
        }
        node3.zzW45(node);
    }

    private void zzZa5(Node node, Node node2) {
        Node node3 = node2.zzCE();
        node.zzW45(node3);
        node.zzWVX(node2);
        node2.zzW45(node);
        if (node3 == null) {
            this.zzWVA = node;
            return;
        }
        node3.zzWVX(node);
    }

    private Node zzWam(Node node) {
        if (node == this.zzWVA) {
            if (this.zzWVA == this.zzOR) {
                this.zzWVA = null;
                this.zzOR = null;
            } else {
                this.zzWVA = node.zzWS7();
                this.zzWVA.zzW45(null);
            }
        } else {
            Node node2 = node.zzCE();
            Node node3 = node.zzWS7();
            node2.zzWVX(node3);
            if (node3 == null) {
                this.zzOR = node2;
            } else {
                node3.zzW45(node2);
            }
        }
        node.zzWVX(null);
        node.zzW45(null);
        node.zzY4Y(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzDa = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzDa;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

