/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzW2r;
import com.aspose.words.internal.zzW67;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzWDR;
import com.aspose.words.internal.zzWEm;
import com.aspose.words.internal.zzXPD;
import com.aspose.words.internal.zzXo1;
import com.aspose.words.internal.zzYVE;
import com.aspose.words.internal.zzYjS;
import com.aspose.words.internal.zzYmA;
import com.aspose.words.internal.zzZ8z;
import com.aspose.words.internal.zzcL;
import com.aspose.words.zzVWc;
import com.aspose.words.zzWDc;
import com.aspose.words.zzWOB;
import com.aspose.words.zzWkd;
import com.aspose.words.zzYB0;
import com.aspose.words.zzYVw;
import com.aspose.words.zzYn3;
import com.aspose.words.zzYvJ;
import com.aspose.words.zzZAi;
import com.aspose.words.zzZD9;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWPL(zzYjS zzYjS2, zzYjS zzYjS3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWCy.zzD8((Object)zzYjS2, "srcStream");
        zzWCy.zzD8((Object)zzYjS3, "dstStream");
        zzWCy.zzD8((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzD8(zzYjS2, zzYjS3, certificateHolder, signOptions);
        zzYjS3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWPL(zzYjS.zzD8(srcStream), (zzYjS)zzYjS.zzZa5(dstStream), certHolder, signOptions);
    }

    private static void zzD8(zzYjS zzYjS2, zzYjS zzYjS3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZa5(digitalSignature);
        }
        if (zzYVw.zzYFp(zzYjS2)) {
            DigitalSignatureUtil.zzWPL(zzYjS2, zzYjS3, digitalSignature, true);
            return;
        }
        zzYVw zzYVw2 = new zzYVw();
        zzYjS zzYjS4 = zzYjS2;
        zzYVw zzYVw3 = zzYVw2;
        FileFormatInfo fileFormatInfo = zzYVw2.zzD8(zzYjS4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzW67 zzW672 = new zzW67(zzYjS2);
                int n = fileFormatInfo.zzWey() == 1 ? 1 : 2;
                zzYvJ.zzWPL(zzW672, digitalSignature, n);
                zzYjS3.zzZXg(0L);
                zzW672.zzVd(zzYjS3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWPL(fileFormatInfo.zzYMN(), zzYjS3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWPL(zzYjS2, zzYjS3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWPL(zzYjS2, zzYjS3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWCy.zzWPL(srcFileName, "srcFileName");
        zzWCy.zzWPL(dstFileName, "dstFileName");
        try (zzXPD zzXPD2 = zzWCy.zzD8(srcFileName, 3, 1);){
            try (zzXPD zzXPD3 = zzWCy.zzD8(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWPL((zzYjS)zzXPD2, (zzYjS)zzXPD3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZ8z zzZ8z2 = zzYjS.zzZa5(dstStream);
        zzYjS zzYjS2 = zzYjS.zzD8(srcStream);
        DigitalSignatureUtil.zzWPL(zzYjS2, (zzYjS)zzZ8z2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXPD zzXPD2 = zzWCy.zzD8(srcFileName, 3, 1);){
            try (zzXPD zzXPD3 = zzWCy.zzD8(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzVTQ(zzXPD2, zzXPD3);
            }
            return;
        }
    }

    private static void zzVTQ(zzYjS zzYjS2, zzYjS zzYjS3) throws Exception {
        zzYVw zzYVw2 = new zzYVw();
        zzYjS zzYjS4 = zzYjS2;
        zzYVw zzYVw3 = zzYVw2;
        FileFormatInfo fileFormatInfo = zzYVw2.zzD8(zzYjS4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzW67 zzW672 = new zzW67(zzYjS2);
                zzW672.zzcw().zzZaE("_xmlsignatures");
                zzW672.zzcw().zzZaE("_signatures");
                zzYjS3.zzZKr(0L);
                zzW672.zzVd(zzYjS3);
                zzYjS zzYjS5 = zzYjS3;
                zzYjS5.zzZXg(zzYjS5.zzYDd());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYVE zzYVE2 = new zzYVE(zzYjS2);
                zzcL zzcL2 = zzYVE2.zzWPL(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzcL2 != null) {
                    for (zzWDR zzWDR2 : zzcL2.zzXy6()) {
                        String string = zzcL2.zzWPL(zzWDR2);
                        zzYVE2.zzZqM().remove(string);
                    }
                    zzYVE2.zzZqM().remove(zzcL2.getName());
                    zzWDR zzWDR3 = zzYVE2.zzXy6().zzZKs("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYVE2.zzXy6().remove(zzWDR3.getId());
                    zzYVE2.zz1A();
                }
                zzYjS3.zzZKr(0L);
                zzYVE2.zzVd(zzYjS3);
                zzYjS zzYjS6 = zzYjS3;
                zzYjS6.zzZXg(zzYjS6.zzYDd());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzVTQ(zzYjS.zzD8(srcStream), zzYjS.zzZa5(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXPD zzXPD2 = zzWCy.zzD8(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYBC(zzXPD2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYBC(zzYjS zzYjS2) throws Exception {
        if (zzYVw.zzYFp(zzYjS2)) {
            return DigitalSignatureUtil.zz0m(zzYjS2);
        }
        zzYVw zzYVw2 = new zzYVw();
        zzYjS zzYjS3 = zzYjS2;
        zzYVw zzYVw3 = zzYVw2;
        FileFormatInfo fileFormatInfo = zzYVw2.zzD8(zzYjS3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzYjS2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYBC(zzYjS.zzD8(stream));
    }

    static zzWEm zzWPL(zzW67 zzW672, String string) throws Exception {
        zzVWc zzVWc2 = new zzVWc(zzW672);
        if (zzVWc2.zzYL9()) {
            zzWEm zzWEm2 = zzVWc2.zzZxg(string);
            return zzWEm2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZ2c(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzW2r.zzD8("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYsF(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZ2c(n);
    }

    private static void zzWPL(zzYjS zzYjS2, zzYjS zzYjS3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYVE zzYVE2 = new zzYVE(zzYjS2);
        zzYn3 zzYn32 = bl ? new zzWDc(zzYVE2) : new zzWkd(zzYVE2);
        zzYn32.zzD8(digitalSignature);
        zzYjS3.zzZXg(0L);
        zzYVE2.zzVd(zzYjS3);
    }

    private static void zzWPL(zzYjS zzYjS2, zzYjS zzYjS3, DigitalSignature digitalSignature) throws Exception {
        zzWOB zzWOB2 = new zzWOB(zzYjS2);
        zzZAi zzZAi2 = new zzZAi(zzWOB2);
        zzZAi2.zzD8(digitalSignature);
        zzYjS3.zzZXg(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzYjS zzYjS4 = zzYjS3;
        zzWOB zzWOB3 = zzWOB2;
        zzWOB3.zzWPL(zzYjS4, string, null);
    }

    private static void zzWPL(zzW67 zzW672, zzYjS zzYjS2, DigitalSignature digitalSignature, String string) throws Exception {
        zzWEm zzWEm2 = DigitalSignatureUtil.zzWPL(zzW672, string);
        zzWEm zzWEm3 = new zzWEm();
        DigitalSignatureUtil.zzWPL((zzYjS)zzWEm2, (zzYjS)zzWEm3, digitalSignature, false);
        zzW67 zzW673 = zzVWc.zzZa5(zzWEm3, string);
        zzW673.zzVd(zzYjS2);
    }

    private static DigitalSignatureCollection zz0m(zzYjS zzYjS2) throws Exception {
        zzYjS2.zzZKr(0L);
        zzYVE zzYVE2 = new zzYVE(zzYjS2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzcL zzcL2 = zzYVE2.zzWPL(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzcL2 != null) {
            for (zzWDR zzWDR2 : zzcL2.zzXy6()) {
                String string = zzcL2.zzWPL(zzWDR2);
                zzcL zzcL3 = zzYVE2.zzXG6(string);
                zzcL zzcL4 = zzYVE2.zzWPL(zzcL3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzYmA zzYmA2 = zzXo1.zzz4(zzcL4.zzYFS().zzVPm());
                zzYB0.zzWPL(zzcL3.zzZsk(), zzYmA2, new zzZD9(zzYVE2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

