/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzMq;
import com.aspose.words.internal.zzPo;
import com.aspose.words.internal.zzW2r;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzWEm;
import com.aspose.words.internal.zzWWV;
import com.aspose.words.internal.zzWrj;
import com.aspose.words.internal.zzXXi;
import com.aspose.words.internal.zzXad;
import com.aspose.words.internal.zzY4K;
import com.aspose.words.internal.zzYVP;
import com.aspose.words.internal.zzYjS;
import com.aspose.words.internal.zzZ82;
import com.aspose.words.internal.zzZCS;
import com.aspose.words.internal.zzZNx;
import com.aspose.words.internal.zzZhM;
import com.aspose.words.internal.zzZvP;
import com.aspose.words.internal.zzqb;
import com.aspose.words.zz2f;
import com.aspose.words.zzBB;
import com.aspose.words.zzUu;
import com.aspose.words.zzVRM;
import com.aspose.words.zzVSi;
import com.aspose.words.zzVW3;
import com.aspose.words.zzVWZ;
import com.aspose.words.zzVZh;
import com.aspose.words.zzWEr;
import com.aspose.words.zzWVa;
import com.aspose.words.zzWjH;
import com.aspose.words.zzWkX;
import com.aspose.words.zzWne;
import com.aspose.words.zzWtU;
import com.aspose.words.zzX1f;
import com.aspose.words.zzXD5;
import com.aspose.words.zzXHZ;
import com.aspose.words.zzXK2;
import com.aspose.words.zzXKc;
import com.aspose.words.zzXLu;
import com.aspose.words.zzXcE;
import com.aspose.words.zzXud;
import com.aspose.words.zzXw7;
import com.aspose.words.zzXwY;
import com.aspose.words.zzY8p;
import com.aspose.words.zzYBN;
import com.aspose.words.zzYGb;
import com.aspose.words.zzYK;
import com.aspose.words.zzYLo;
import com.aspose.words.zzYSk;
import com.aspose.words.zzYYL;
import com.aspose.words.zzYdV;
import com.aspose.words.zzYmb;
import com.aspose.words.zzYuQ;
import com.aspose.words.zzZ0s;
import com.aspose.words.zzZCT;
import com.aspose.words.zzZFb;
import com.aspose.words.zzZNg;
import com.aspose.words.zzZXX;
import com.aspose.words.zzZl;
import com.aspose.words.zzi5;
import com.aspose.words.zzpy;
import com.aspose.words.zzzF;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWne,
zzY8p,
zzZ0s {
    private Document zzXBD;
    private Node zzZRO;
    private Node zz3K;
    private zzZl zzmy;
    private Font zzZ3P;
    private zzZhM<zzZl> zzXeJ;
    private zzZhM<zzWkX> zzZ1;
    private zzZhM<zzWPL> zzYuz;
    private zzXcE zzj2 = zzXcE.zzYy4();
    private zzXHZ zzWML = new zzXHZ();
    private RowFormat zzWlV;
    private CellFormat zzqD;
    private zzZhM<zzXKc> zzAB;
    private int zzZbB = 0;
    private int zzZKC = -1;
    private int zzY0P;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXWe(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXWe(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXWe(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWPL(documentBuilder.getCurrentSection(), zzYBN.zzXT9(headerFooterType), 0, 0);
    }

    private void zzXWe(int n, int n2, int n3, int n4) {
        this.zzXBD.ensureMinimum();
        Section section = (Section)this.zzXBD.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWPL(section, 1, n3, n4);
    }

    private void zzWPL(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYBN.zzYnK(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzXBD, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzXBD));
            }
        }
        this.zzWPL(story, n2, n3);
    }

    private void zzWPL(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWPL(paragraph2, n3);
    }

    final void zzZa5(Paragraph paragraph, int n) {
        this.zzWPL(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWVI().zzOK() ? zzYK.zzWgK(this.zzXBD, fieldName) : zzYK.zzWPt(this.zzWVI(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWPL(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWPL(field, isAfter, false);
    }

    private boolean zzWPL(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXud zzXud2 = field.getFormat().zzWUH();
        Inline inline = zzXud2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWPL(inline.zzXsC(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzXwY.zzWPL(this.zzXBD, bookmarkName) : zzXwY.zzD8(this.zzXBD, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXOq() == 6) {
            this.zzD8((Paragraph)node.zzXuf(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYGb.zzYzo(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzD8(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWPL(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZGt(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzWPL(cell, characterIndex);
    }

    private void zzD8(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXOq() == 6) {
            this.zzXWA(node);
        } else {
            Node node2 = node;
            if (zzYGb.zzYju(node2.getNodeType())) {
                Paragraph paragraph = zzYGb.zzYzo(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzXWA(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXOq() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzXWA(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzY0P = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYRT();
            return;
        }
        if (!this.zzXpR()) {
            this.zzYRT();
        }
    }

    private boolean zzXpR() {
        Node node = this.zzWVI();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzWVI(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWPL(inline.zzXsC(), true);
            return true;
        }
        return false;
    }

    private void zzYRT() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWPL(documentBuilder.getCurrentParagraph().zzVYv(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZGt(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZwd() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWVI().zzWtj(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzXgj();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWPL(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZs(text, false);
    }

    public void writeln(String text) {
        this.zzZs(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzjh();
        Paragraph paragraph = this.getCurrentParagraph();
        zzzF zzzF2 = new zzzF(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzXBD, this.zzXBV(), this.zzYmf());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzD8(this.zzWVI(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzzF2.dispose();
        }
        if (this.getDocument().zzVQb()) {
            zzVSi.zzZa5(paragraph, this.getDocument().zzXvB());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZ4c() {
        zzZl zzZl2;
        Run run;
        Run run2;
        zzZ0s zzZ0s2;
        this.zzjh();
        Node node = this.zzWVI();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzZ0s2 = paragraph;
            run2 = zzZ0s2.zzXju(false);
        } else {
            run2 = run = (Run)node.zzWrR(21);
        }
        if (run2 == null && zzWCy.zzW3B(node, paragraph.zzX7J())) {
            run = paragraph.zzX7J();
        }
        if (run != null) {
            zzZ0s2 = run.zzXsC();
            zzZl2 = (zzZl)((zzWjH)((Object)zzZ0s2)).zzVT0();
        } else {
            zzZ0s2 = paragraph.zzVYv();
            zzZl2 = (zzZl)((zzWjH)((Object)zzZ0s2)).zzVT0();
        }
        zzZl zzZl4 = zzZl2;
        Paragraph paragraph2 = new Paragraph(this.zzXBD, this.zzXBV(), zzZl4);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzzF zzzF2 = new zzzF(this.zzXBD);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzD8(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzzF2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzYLo.zzWgK(this);
    }

    public void insertBreak(int breakType) {
        this.zzYzo(breakType, true);
    }

    final void zzYzo(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzWx7(bl)) {
                    this.zzZLa(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzWx7(bl)) {
                    this.zzZLa(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzWx7(bl)) {
                    this.zz7d(1);
                }
                return;
            }
            case 5: {
                if (this.zzWx7(bl)) {
                    this.zz7d(2);
                }
                return;
            }
            case 3: {
                if (this.zzWx7(bl)) {
                    this.zz7d(0);
                }
                return;
            }
            case 6: {
                if (this.zzWx7(bl)) {
                    this.zz7d(3);
                }
                return;
            }
            case 7: {
                if (this.zzWx7(bl)) {
                    this.zz7d(4);
                }
                return;
            }
            case 8: {
                this.zzZLa(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXXi.zzXFy(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzW2r.zzD8("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzjh();
        return zzYGb.zzWPL(fieldType, updateField, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzjh();
        return zzYGb.zzWPL(fieldCode, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzjh();
        return zzYGb.zzWPL(fieldCode, fieldValue, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWCy.zzD8((Object)displayText, "displayText");
        zzWCy.zzD8((Object)urlOrBookmark, "hrefOrBookmark");
        zzVRM zzVRM2 = this.zzD8(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzVRM2.zzD8(documentBuilder.zzXYH(88, true));
        return zzYGb.zzWPL(zzVRM2.getStart(), zzVRM2.getSeparator(), zzVRM2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzvl(70);
        if (zzXXi.zzXFy(name)) {
            this.startBookmark(name);
        }
        this.zzWZW(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzWbQ(70);
        String string = zzXXi.zzXFy(fieldValue) ? fieldValue : FormField.zzZiV;
        Run run = new Run(this.zzXBD, string, this.zzYmf());
        this.insertNode(run);
        Node node = this.zzXYH(70, true);
        if (zzXXi.zzXFy(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZtl(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzD8((Paragraph)node.zzXuf(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzvl(71);
        if (zzXXi.zzXFy(name)) {
            this.startBookmark(name);
        }
        this.zzWZW(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXYH(71, false);
        if (zzXXi.zzXFy(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZtl(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzvl(83);
        if (zzXXi.zzXFy(name)) {
            this.startBookmark(name);
        }
        this.zzWZW(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXYH(83, false);
        if (zzXXi.zzXFy(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZtl(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzXBD, footnoteType, !zzXXi.zzXFy(referenceMark), referenceMark, this.zzYmf());
        Style style = this.getDocument().getStyles().zzYXj(zzYGb.zzZ8X(footnoteType));
        footnote.zzXsC().set(50, style.zzZxF());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzXBD);
        Style style2 = this.getDocument().getStyles().zzYXj(zzYGb.zzZXO(footnoteType));
        paragraph.zztc().set(1000, style2.zzZxF());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzXBD, '\u0002', new zzZl()) : new Run(this.zzXBD, footnote.getReferenceMark(), new zzZl());
        inline.zzXsC().set(50, style.zzZxF());
        paragraph.appendChild(inline);
        if (zzXXi.zzXFy(footnoteText)) {
            Node node = this.zzWVI();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzXWA(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYHl(zzYjS zzYjS2) throws Exception {
        return this.zzWPL(zzYjS2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYHl(zzYjS.zzD8(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWPL(zzYjS zzYjS2, double d, double d2) throws Exception {
        return this.zzWPL(zzYjS2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWPL(zzYjS.zzD8(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzWEm zzWEm2 = new zzWEm();){
            zzWrj.zzWPL(image, zzWEm2);
            Shape shape = this.zzWPL(zzWEm2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWCy.zzWPL(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZvP.zzWS(fileName);
        try {
            Shape shape = this.zzWPL((zzYjS)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzYjS)object).close();
            }
        }
    }

    private Shape zzWPL(zzYjS zzYjS2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzYjS2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzWCy.zzWgK(zzYjS2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWPL(zzYjS.zzD8(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWPL(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzWMQ(byte[] byArray) throws Exception {
        Shape shape = this.zzWPL(byArray, 2, 0.0, 2, 0.0, -1.0, -1.0, 0, true);
        return shape;
    }

    private Shape zzWPL(byte[] byArray, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object;
        Object object2;
        Shape shape;
        Object object3;
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzY4K.zzXpP(byArray)) {
            object3 = new zzWrj(byArray);
            bl2 = true;
            ((zzPo)object3).dispose();
        }
        object3 = null;
        boolean bl3 = this.zzXBD.getCompatibilityOptions().getMswVersion() > 12 || this.zzXBD.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzXBD, 0);
            object2 = new zzXw7();
            ((zzWtU)object2).zzWPL(zzXLu.zzX52("rect"));
            ((zzXw7)object2).zzWPL(new zzYYL());
            ((zzXw7)object2).zzZaK().zzZzb().zzVTQ(this.zzXBD);
            zzZCT zzZCT2 = new zzZCT();
            object = zzZCT2;
            zzZCT2.zzD8(new zzXK2(this.zzXBD.zzWQF(), ""));
            ((zzZFb)object).zzWPL(new zzWEr());
            ((zz2f)object2).zzWPL((zzZFb)object);
            shape.zzXre(75);
            shape.zznj((zz2f)object2);
        } else {
            shape = new Shape((DocumentBase)this.zzXBD, 75);
        }
        if (zzY4K.zzXbY(byArray)) {
            int n4 = bl3 ? 6 : 2;
            object = shape.getImageData().zzWPL(byArray, new zzXD5(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzY4K.zzW11((byte[])object));
                this.zzWPL((zzXw7)shape.zzX30(), byArray, imageSize);
            }
            byArray = object;
        }
        if (bl3 && bl2) {
            ((zzXw7)shape.zzX30()).zzZaK().zzZzb().zzXQq(byArray);
            object2 = zzY4K.zzZA8(byArray);
            object3 = new zzXD5(((zzXad)object2).getWidthPoints(), ((zzXad)object2).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes(byArray);
        }
        shape.zzWPL(this.zzYmf());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzY4K.zzYBC(byArray)) {
            d5 = DocumentBuilder.zzWPL(shape, byArray);
        }
        shape.zzWPL(d3, d4, (zzXD5)object3, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzWPL(Shape shape, byte[] byArray) throws Exception {
        int n = zzY4K.zzZSm(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYGb.zzYMx(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYGb.zzXkR(n);
        return d;
    }

    private void zzWPL(zzXw7 zzXw72, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXw72.zzZaK().zzZzb().getExtensions();
        try (zzWEm zzWEm2 = new zzWEm(byArray);){
            object = zzYGb.zzWPL(zzWEm2, this.zzXBD);
            ((zzVZh)object).zzZXg(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzVZh)object).zzXwd();
            byArray2 = ((zzVZh)object).zzXhP(true);
        }
        zzXw72.zzZaK().zzZzb().setExtensions(new zzZCS<zzX1f>());
        object = zzX1f.zzWPL(byArray2, this.zzXBD);
        zzXw72.zzZaK().zzZzb().getExtensions().zzFe(((zzX1f)object).getUri(), (zzX1f)object);
    }

    private Shape zzWPL(zzYjS zzYjS2, String string, boolean bl, zzYjS zzYjS3) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzXuW(string);
        Shape shape = this.zzWPL(zzYjS3, bl, zzVWZ2, null);
        zzBB zzBB2 = zzYmb.zzWPL(zzYjS2, string, bl);
        return DocumentBuilder.zzWPL(null, false, shape, zzVWZ2.zzYx2, zzBB2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWPL(zzYjS.zzD8(stream), progId, asIcon, zzYjS.zzD8(presentation));
    }

    private Shape zzWPL(String string, boolean bl, boolean bl2, zzYjS zzYjS2) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzY49(zzYVP.zzZ1K(string));
        return this.zzWPL(string, bl, bl2, zzYjS2, zzVWZ2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWPL(fileName, isLinked, asIcon, zzYjS.zzD8(presentation));
    }

    private Shape zzWPL(String string, String string2, boolean bl, boolean bl2, zzYjS zzYjS2) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzXuW(string2);
        return this.zzWPL(string, bl, bl2, zzYjS2, zzVWZ2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWPL(fileName, progId, isLinked, asIcon, zzYjS.zzD8(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzY49(zzYVP.zzZ1K(fileName));
        return this.zzWPL(fileName, isLinked, iconFile, iconCaption, zzVWZ2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzXuW(progId);
        return this.zzWPL(fileName, isLinked, iconFile, iconCaption, zzVWZ2);
    }

    private Shape zzWPL(zzYjS zzYjS2, String string, String string2, String string3) throws Exception {
        zzVWZ zzVWZ2 = zzVWZ.zzXuW(string);
        Shape shape = this.zzWPL(string2, string3, zzVWZ2);
        zzBB zzBB2 = zzYmb.zzWPL(zzYjS2, string, true);
        return DocumentBuilder.zzWPL(null, false, shape, zzVWZ2.zzYx2, zzBB2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWPL(zzYjS.zzD8(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWPL(zzpy zzpy2, zzYjS zzYjS2) throws Exception {
        Shape shape = this.zzZLH(zzYjS2);
        shape.zzXre(201);
        shape.getOleFormat().zzD8(zzpy2.zzXh6());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzjh();
        if (this.zzro()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzXLP(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzi5 zzi52 = zzYGb.zzWPL(html, options, this);
        zzi52.zzXm7();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzjh();
        return zzYGb.zzWPL(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzjh();
        return zzYGb.zzWPL(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzYdV zzYdV2 = new zzYdV();
        return zzYdV2.zzWPL(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZNg(this).zzWPL(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZNg(this).zzWPL(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzXBD, 75);
        shape.zzWPL(this.zzYmf());
        shape.zzWDJ(true);
        shape.getSignatureLine().zzWPL(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzof(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzWU7(this.zzXBD);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzro() {
        boolean bl = false;
        if (this.zzWVI().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWVI().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXLP(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzjh();
        if (this.zzZwd() == null) {
            this.startTable();
        }
        if (this.zzZwd().zzdP() == 1) {
            this.zzZwd().zzX22();
        }
        if (this.zzZwd().zzdP() == 3) {
            this.zzZwd().zzWES();
        }
        return this.zzZwd().zzY74();
    }

    public Table startTable() {
        this.zzAB.push(new zzXKc(this));
        return this.zzZwd().startTable();
    }

    public Table endTable() {
        if (this.zzZwd() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZwd().endTable();
        this.zzAB.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZwd() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZwd().endRow();
        if (this.zzZ3P != null && this.zzZ3P.getHidden()) {
            row.zzXUB().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXBD, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXBD, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWpj();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXBD, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzZsy();
        bookmarkStart.zzqi(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWpj();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzZsy();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXBD, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzQJ(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzXBD);
        this.zzZKC = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZKC == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXBD, this.zzZKC);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXBD, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWCy.zzD8((Object)importFormatOptions, "ImportFormatOptions");
        this.zzjh();
        return zzYuQ.zzWPL(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzXBD;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzXBD) {
            return;
        }
        this.zzXBD = value;
        this.zzXWA(null);
        this.zzmy = new zzZl();
        this.zzXeJ = null;
        this.zzZ1 = null;
        this.zzZ3P = null;
        this.zzAB = new zzZhM();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZ3P == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZ3P = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZ3P;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzWlV == null) {
            this.zzWlV = new RowFormat(this);
        }
        return this.zzWlV;
    }

    public CellFormat getCellFormat() {
        if (this.zzqD == null) {
            this.zzqD = new CellFormat(this);
        }
        return this.zzqD;
    }

    final void zzWeh(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzZl zzZl2 = this.getCurrentParagraph().zzVYv();
        this.zzu6().push(new zzWPL(this.zzYmf(), (zzZl)zzZl2.zzVT0()));
    }

    public void popFont() {
        zzZhM<zzWPL> zzZhM2 = this.zzu6();
        if (zzZhM2.size() > 0) {
            zzWPL zzWPL2 = (zzWPL)this.zzu6().pop();
            this.zzWPL(zzWPL2.zzXsC(), false);
            this.getCurrentParagraph().zzK4(zzWPL2.zzY9Z());
        }
    }

    final void zz1() {
        this.zzIE().push(this.zzYmf());
    }

    final void zzWVj() {
        zzZhM<zzZl> zzZhM2 = this.zzIE();
        if (zzZhM2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWPL((zzZl)documentBuilder.zzIE().pop(), false);
        }
    }

    final void zzrI() {
        this.zzZwx().push(this.zzXBV());
    }

    final void zzCS() {
        zzZhM<zzWkX> zzZhM2 = this.zzZwx();
        if (zzZhM2.size() > 0) {
            this.getCurrentParagraph().zzWPL((zzWkX)this.zzZwx().pop());
        }
    }

    final zzVRM zzD8(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzvl(88);
        zzWVa zzWVa2 = new zzWVa();
        zzWVa2.setTarget(string2);
        zzWVa2.setScreenTip(string3);
        if (bl) {
            zzWVa2.setSubAddress(string);
        } else {
            zzWVa2.setAddress(zzWWV.zzXTb(string));
            zzWVa2.setSubAddress(zzWWV.zzZjk(string));
        }
        this.zzWZW(zzWVa2.toString());
        FieldSeparator fieldSeparator = this.zzWbQ(88);
        return new zzVRM(fieldStart, fieldSeparator, null);
    }

    final zzVRM zzVR1(String string, String string2, String string3) {
        boolean bl = zzWWV.zzXFF(string);
        String string4 = bl ? zzWWV.zzZjk(string) : string;
        return this.zzD8(string4, bl, string2, string3);
    }

    final FieldEnd zzWSg() {
        return this.zzXYH(88, true);
    }

    final zzZl zzYmf() {
        zzZl zzZl2 = this.zzmy;
        return (zzZl)zzZl2.zzVT0();
    }

    final zzWkX zzXBV() {
        zzWkX zzWkX2 = this.getCurrentParagraph().zztc();
        return (zzWkX)zzWkX2.zzVT0();
    }

    final zzXcE zzZr9() {
        zzXcE zzXcE2 = this.zzXUB();
        return (zzXcE)zzXcE2.zzVT0();
    }

    final zzXHZ zzYvj() {
        zzXHZ zzXHZ2 = this.zzWRm();
        return (zzXHZ)zzXHZ2.zzVT0();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWVI(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWVI().getNodeType() == 8;
    }

    private void zzZs(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYBN.zz4m(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzWuk(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZbB) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZLa(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzWuk(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzjh();
        if (this.zzZwd() != null && this.zzZwd().zzdP() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzWVI().getParentNode().insertBefore(node, this.zzWVI());
    }

    final void zzWIQ(int n) {
        this.zzWx7(true);
        this.zz7d(n);
    }

    private void zz7d(int n) {
        this.insertParagraph();
        zzzF zzzF2 = new zzzF(this.getDocument());
        try {
            zzYSk zzYSk2 = this.getCurrentSection().zzXBy();
            zzYSk zzYSk3 = (zzYSk)zzYSk2.zzVT0();
            Section section = new Section(this.zzXBD, zzYSk3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzXBD));
            this.zzXBD.insertAfter(section, this.getCurrentSection());
            section.getBody().zzD8(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzzF2.dispose();
        }
    }

    final FieldStart zzvl(int n) {
        this.zzjh();
        return zzYGb.zzWPL(n, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzWZW(String string) {
        return zzYGb.zzD8(string, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzXYH(int n, boolean bl) {
        return zzYGb.zzD8(n, bl, this.zzYmf(), this.zzWVI(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzWbQ(int n) {
        return zzYGb.zzD8(n, this.zzYmf(), this.zzWVI(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZtl(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzXBD, new zzVW3(), this.zzYmf());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWx7(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZwd() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZGt(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzWuk(String string) {
        if (this.zzVX5(string)) {
            zzMq zzMq2 = new zzMq(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZNx zzZNx2 : zzMq2.zzWgs(this.getParagraphFormat().getBidi())) {
                zzZXX zzZXX2 = zzZXX.zzVPD(zzZNx2.zzZMu());
                zzZl zzZl2 = this.zzYmf();
                zzZl2.zzVR1(265, zzZXX2);
                if (zzZNx2.zzVRq()) {
                    zzZl2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzXBD, zzZNx2.getText(), zzZl2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZLa(string);
    }

    private boolean zzVX5(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzZ82.zzSh(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWPL(zzZl zzZl2, boolean bl) {
        zzZl zzZl4;
        if (bl) {
            zzZl zzZl5 = zzZl2;
            zzZl4 = (zzZl)zzZl5.zzVT0();
        } else {
            zzZl4 = zzZl2;
        }
        this.zzmy = zzZl4;
    }

    final void zzY9T() {
        this.zzmy.clear();
    }

    final void zzZsx() {
        if (this.zzWpj() != null) {
            zzXHZ zzXHZ2;
            zzXHZ zzXHZ3 = zzXHZ2 = this.zzWpj().zzWRm();
            this.zzWML = (zzXHZ)zzXHZ3.zzVT0();
            zzXHZ2.zzD8(this.zzWML);
        }
    }

    private Shape zzWPL(String string, boolean bl, boolean bl2, zzYjS zzYjS2, zzVWZ zzVWZ2) throws Exception {
        if (zzVWZ2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWPL(zzYjS2, bl2, zzVWZ2, string);
        zzBB zzBB2 = zzYmb.zzWPL(string, bl, bl2, zzVWZ2);
        return DocumentBuilder.zzWPL(string, bl, shape, zzVWZ2.zzYx2, zzBB2);
    }

    private Shape zzWPL(String string, boolean bl, String string2, String string3, zzVWZ zzVWZ2) throws Exception {
        if (zzVWZ2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzYVP.zzWnU(string);
        }
        Shape shape = string2 != null ? this.zzZvd(string2, string3) : this.zzWPL(null, string3, zzVWZ2);
        zzBB zzBB2 = zzYmb.zzWPL(string, bl, true, zzVWZ2);
        return DocumentBuilder.zzWPL(string, bl, shape, zzVWZ2.zzYx2, zzBB2);
    }

    private static Shape zzWPL(String string, boolean bl, Shape shape, String string2, zzBB zzBB2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXre(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzD8(zzBB2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWPL(zzYjS zzYjS2, boolean bl, zzVWZ zzVWZ2, String string) throws Exception {
        if (zzVWZ2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzYjS2 != null) {
            return this.zzZLH(zzYjS2);
        }
        if (!bl) {
            return this.zzWPi(zzYmb.zzXhG().get("normal"));
        }
        String string2 = string != null ? zzYVP.zzWnU(string) : zzYmb.zzYUu(zzVWZ2.zzWjm);
        return this.zzWPL(zzVWZ2, string2);
    }

    private Shape zzWPL(String string, String string2, zzVWZ zzVWZ2) throws Exception {
        if (zzVWZ2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYmb.zzYUu(zzVWZ2.zzWjm);
        }
        if (string != null) {
            return this.zzZvd(string, string2);
        }
        return this.zzWPL(zzVWZ2, string2);
    }

    private Shape zzWPL(zzVWZ zzVWZ2, String string) throws Exception {
        if (zzVWZ2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYmb.zzZa1(zzVWZ2.zzWjm);
        zzqb zzqb2 = new zzqb(byArray, null, string, this.getDocument().zzZMf());
        return this.zzWPi(zzqb2.zzW4O());
    }

    private Shape zzZvd(String string, String string2) throws Exception {
        zzqb zzqb2 = new zzqb(string, string2, this.getDocument().zzZMf());
        return this.zzWPi(zzqb2.zzW4O());
    }

    private Shape zzZLH(zzYjS zzYjS2) throws Exception {
        byte[] byArray = zzWCy.zzWgK(zzYjS2);
        return this.zzWPi(byArray);
    }

    private Shape zzWPi(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzXBD, 1);
        shape.zzXre(75);
        shape.zzWPL(this.zzYmf());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzof(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzWPL(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzD8(compositeNode, n);
            return;
        }
        this.zzZa5(compositeNode, n);
    }

    private void zzD8(CompositeNode compositeNode, int n) {
        zzUu zzUu2 = zzUu.zzXDm(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzUu2.zzWPL(null, true, true, true, false, true);
            node = zzUu2.getNode();
            if (zzUu2.zzYoZ() && (!node.isComposite() || node.zzXOq() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzMV().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzD8(null, node);
            this.zzY0P = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZa5(CompositeNode compositeNode, int n) {
        zzUu zzUu2 = zzUu.zzW11(compositeNode);
        while (zzUu2.getNode() != compositeNode || !zzUu2.zzYoZ()) {
            int n2;
            Node node = zzUu2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzMV().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzD8(null, node);
                this.zzY0P = n;
                return;
            }
            while (zzUu2.zzWPL(null, false, true, true, false, true) && zzUu2.zzYoZ() && zzUu2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzjh() {
        int n = this.zzY0P;
        if (n == 0) {
            return;
        }
        this.zzY0P = 0;
        Run run = zzWCy.zzWPL((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzob(n);
        }
    }

    private Run zzZLa(String string) {
        Run run = new Run(this.zzXBD, string, this.zzYmf());
        this.insertNode(run);
        return run;
    }

    final boolean zzZjO() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzjT() {
        return this.zzZbB;
    }

    final void zzZfG(int n) {
        this.zzZbB = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzWVI();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWVI();
        }
        return (Paragraph)this.zzWVI().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXKc zzZwd() {
        zzZhM<zzXKc> zzZhM2 = this.zzAB;
        if (zzZhM2.size() > 0) {
            return (zzXKc)this.zzAB.peek();
        }
        return null;
    }

    private Cell zzWpj() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXE1();
    }

    private zzZhM<zzZl> zzIE() {
        if (this.zzXeJ == null) {
            this.zzXeJ = new zzZhM();
        }
        return this.zzXeJ;
    }

    private zzZhM<zzWkX> zzZwx() {
        if (this.zzZ1 == null) {
            this.zzZ1 = new zzZhM();
        }
        return this.zzZ1;
    }

    private zzZhM<zzWPL> zzu6() {
        if (this.zzYuz == null) {
            this.zzYuz = new zzZhM();
        }
        return this.zzYuz;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzmy.zzX1u(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYmA(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYmA(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzmy.zzVR1(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYg1()) {
            this.getCurrentParagraph().zzVYv().zzVR1(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzmy.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzmy.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYg1()) {
            this.getCurrentParagraph().zzVYv().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzXUB().zzX1u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzXUB().zzWng(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzXUB().zzZk4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzXUB().zzVR1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzXUB().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzXUB().clear();
        zzXcE.zzYy4().zzD8(this.zzXUB());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWRm().zzX1u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzWRm().zzWng(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzWRm().zzZk4(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWCy.zzWPL(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWpj() != null ? this.zzWpj().getCellFormat() : this.getCellFormat();
            border.zzWPL(cellFormat);
        }
        this.zzWRm().zzVR1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWRm().clear();
    }

    private Node zzWVI() {
        Node node = this.zzZRO != null && this.zzZRO.getParentNode() == null ? this.zz3K : this.zzZRO;
        if (node != null && node.zzXOq() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzXWA(Node node) {
        this.zzZRO = node;
        if (this.zzZRO != null) {
            this.zz3K = this.zzZRO.getParentNode();
        }
    }

    private zzXcE zzXUB() {
        if (this.zzZwd() != null && this.zzZwd().zzdP() == 1) {
            return this.zzj2;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzXUB();
        }
        return this.zzj2;
    }

    private zzXHZ zzWRm() {
        if (this.zzZwd() != null && this.zzZwd().zzdP() != 3) {
            return this.zzWML;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXE1().zzWRm();
        }
        return this.zzWML;
    }

    static final class zzWPL {
        private zzZl zzmy;
        private zzZl zzYBc;

        public zzWPL(zzZl zzZl2, zzZl zzZl4) {
            this.zzmy = zzZl2;
            this.zzYBc = zzZl4;
        }

        public final zzZl zzXsC() {
            return this.zzmy;
        }

        public final zzZl zzY9Z() {
            return this.zzYBc;
        }
    }
}

