/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzHs;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzXPD;
import com.aspose.words.internal.zzXXi;
import com.aspose.words.internal.zzXvZ;
import com.aspose.words.internal.zzYjS;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYVw;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzYzB = new HashMap();
    private static HashMap<Integer, Integer> zzWe5 = new HashMap();
    private static HashMap<Integer, Integer> zzX9s = new HashMap();
    private static HashMap<Integer, Integer> zzXfu = new HashMap();
    private static HashMap<Integer, Integer> zzWpQ = new HashMap();
    private static HashMap<Integer, Integer> zzXt1 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWCy.zzWPL(fileName, "fileName");
        try (zzXPD zzXPD2 = zzWCy.zzWYJ(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZvd(zzXPD2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZvd(zzXvZ.zzWPL(stream));
    }

    static FileFormatInfo zzZvd(zzYjS zzYjS2) throws Exception {
        if (zzYjS2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzYVw zzYVw2 = new zzYVw();
            zzYjS zzYjS3 = zzYjS2;
            zzYVw zzYVw3 = zzYVw2;
            return zzYVw2.zzD8(zzYjS3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZa5(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzWWM(zzHs.zzZVH(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzWSl(zzHs.zzZVH(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXXi.zzXFy(string = zzHs.zzZqN(FileFormatUtil.zzYx9(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzWWM(FileFormatUtil.zzgJ(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzWSl(FileFormatUtil.zzYx9(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzHs.zzZqN(FileFormatUtil.zzgJ(saveFormat));
        if (zzXXi.zzXFy(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzWSl(zzHs.zz5J(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzHs.zzZqN(FileFormatUtil.zzX4F(imageType));
    }

    static Exception zzZa5(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzXEP(int n) {
        return zzHs.toString(FileFormatUtil.zzgJ(n));
    }

    static int zzWSl(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWCy.zzWPL(zzWpQ, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWVP(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWCy.zzWPL(zzXt1, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZmP(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYx9(int n) {
        return zzWCy.zzWPL(zzYzB, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzgJ(int n) {
        return zzWCy.zzWPL(zzWe5, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzX4F(int n) {
        return zzWCy.zzWPL(zzX9s, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWWM(int n) {
        return zzWCy.zzWPL(zzXfu, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzVR1(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWCy.zzD8(zzWpQ, Integer.valueOf(n), Integer.valueOf(n2));
            zzWCy.zzD8(zzWe5, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXfu.containsKey(n)) {
                zzWCy.zzD8(zzXfu, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWCy.zzD8(zzYzB, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWCy.zzD8(zzXt1, Integer.valueOf(n), Integer.valueOf(n4));
            zzWCy.zzD8(zzX9s, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzVR1(11, 10, 10, 1);
        FileFormatUtil.zzVR1(11, 0, 0, 1);
        FileFormatUtil.zzVR1(12, 11, 11, 1);
        FileFormatUtil.zzVR1(13, 20, 20, 1);
        FileFormatUtil.zzVR1(13, 0, 254, 1);
        FileFormatUtil.zzVR1(14, 21, 21, 1);
        FileFormatUtil.zzVR1(15, 22, 22, 1);
        FileFormatUtil.zzVR1(16, 23, 23, 1);
        FileFormatUtil.zzVR1(18, 24, 24, 1);
        FileFormatUtil.zzVR1(19, 25, 25, 1);
        FileFormatUtil.zzVR1(20, 26, 26, 1);
        FileFormatUtil.zzVR1(21, 27, 27, 1);
        FileFormatUtil.zzVR1(24, 30, 30, 1);
        FileFormatUtil.zzVR1(17, 31, 31, 1);
        FileFormatUtil.zzVR1(25, 50, 50, 1);
        FileFormatUtil.zzVR1(26, 45, 255, 1);
        FileFormatUtil.zzVR1(27, 51, 51, 1);
        FileFormatUtil.zzVR1(28, 0, 52, 1);
        FileFormatUtil.zzVR1(29, 0, 53, 1);
        FileFormatUtil.zzVR1(22, 60, 60, 1);
        FileFormatUtil.zzVR1(23, 61, 61, 1);
        FileFormatUtil.zzVR1(33, 40, 64, 1);
        FileFormatUtil.zzVR1(40, 47, 255, 1);
        FileFormatUtil.zzVR1(41, 48, 255, 1);
        FileFormatUtil.zzVR1(34, 41, 255, 1);
        FileFormatUtil.zzVR1(35, 46, 255, 1);
        FileFormatUtil.zzVR1(37, 42, 255, 1);
        FileFormatUtil.zzVR1(36, 44, 255, 1);
        FileFormatUtil.zzVR1(30, 52, 255, 1);
        FileFormatUtil.zzVR1(31, 70, 62, 1);
        FileFormatUtil.zzVR1(32, 73, 63, 1);
        FileFormatUtil.zzVR1(38, 71, 255, 1);
        FileFormatUtil.zzVR1(8, 100, 255, 1);
        FileFormatUtil.zzVR1(9, 105, 255, 1);
        FileFormatUtil.zzVR1(6, 101, 255, 6);
        FileFormatUtil.zzVR1(7, 102, 255, 7);
        FileFormatUtil.zzVR1(5, 104, 255, 5);
        FileFormatUtil.zzVR1(4, 0, 255, 4);
        FileFormatUtil.zzVR1(3, 0, 255, 3);
        FileFormatUtil.zzVR1(39, 72, 255, 1);
        FileFormatUtil.zzVR1(2, 103, 255, 2);
    }
}

