/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.zzWji;
import com.aspose.words.zzYGb;
import com.aspose.words.zzZ0s;

public class ListFormat {
    private zzWji zzYzl;
    private zzZ0s zzVRI;
    private ListCollection zzYLH;
    private ListLevel zzaH;
    private ListLevel zzWCm;

    ListFormat(zzWji parentParaAttrs, zzZ0s parentRunAttrs, ListCollection lists) {
        this.zzYzl = parentParaAttrs;
        this.zzVRI = parentRunAttrs;
        this.zzYLH = lists;
    }

    public void applyBulletDefault() {
        if (this.zzYLH.getCount() > 2046) {
            zzYGb.zzD8(this.zzYLH.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzVZW(listFormat.zzYLH.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzaH = null;
    }

    public void applyNumberDefault() {
        if (this.zzYLH.getCount() > 2046) {
            zzYGb.zzD8(this.zzYLH.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzVZW(listFormat.zzYLH.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzaH = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzaH = null;
    }

    public void listIndent() throws Exception {
        if (this.zzVS7() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzVS7() + 1);
            ListFormat listFormat2 = this;
            this.zzaH = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzVS7() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzVS7() - 1);
            ListFormat listFormat2 = this;
            this.zzaH = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzWCy.zzWPL((Object)this.zzYLH.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzWiC();
        }
        return this.zzVS7();
    }

    public void setListLevelNumber(int value) {
        this.zzYzl.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzaH = null;
    }

    final int zzVS7() {
        return (Integer)this.zzYzl.fetchParaAttr(1110);
    }

    final int zzWiC() {
        Paragraph paragraph = zzWCy.zzWPL((Object)this.zzYzl, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZwc(1110, 1);
        }
        return this.zzVS7();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzYLH.zzXBz(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzVZW(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzYLH.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzVZW(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzaH = null;
    }

    final List zzZpZ() {
        int n = this.zzWLZ();
        if (n != 0) {
            return this.zzYLH.zzXBz(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzWCy.zzWPL((Object)this.zzYLH.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzXtz();
            }
            return this.zzXtb();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzXtb() {
        try {
            if (this.zzaH == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzVUV(this.zzVS7()) : null;
                this.zzaH = listLevel != null ? new ListLevel(listLevel, this.zzVRI) : null;
            }
            return this.zzaH;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzXtz() {
        if (this.zzWCm == null) {
            List list = this.zzZpZ();
            ListLevel listLevel = list != null ? list.zzVUV(this.zzWiC()) : null;
            this.zzWCm = listLevel != null ? new ListLevel(listLevel, this.zzVRI) : null;
        }
        return this.zzWCm;
    }

    final int getListId() {
        return (Integer)this.zzYzl.fetchParaAttr(1120);
    }

    private void zzVZW(int n) {
        Object object = this.zzYzl.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zztc().zzZze() + this.getListLevel().zztc().zzXZF())) {
            n3 = 0;
        }
        this.zzYzl.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzaH = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzYzl.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zztc().zzZze() + this.getListLevel().zztc().zzXZF();
        this.zzYzl.setParaAttr(1160, n4);
    }

    private int zzWLZ() {
        Paragraph paragraph = zzWCy.zzWPL((Object)this.zzYzl, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZwc(1120, 1);
        }
        return this.getListId();
    }
}

