/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzZhM;
import com.aspose.words.zzUu;
import com.aspose.words.zzYGb;
import com.aspose.words.zzYkS;
import com.aspose.words.zzZls;

public abstract class Node
implements Cloneable {
    private Node zzY2c;
    private Node zzYNq;
    private Node zzz6;
    private int zzY7A;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzVTQ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzY2c == null) {
            return null;
        }
        if (this.zzY2c.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzY2c;
    }

    final CompositeNode zzXuf() {
        if (zzYGb.zzWOL(this.getParentNode())) {
            return this.getParentNode().zzXuf();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYTn() {
        if (zzYGb.zzWOL(this.getParentNode()) || zzYGb.zzWU7(this.getParentNode())) {
            return this.getParentNode().zzYTn();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzY2c != null) {
            return this.zzY2c.getDocument();
        }
        return null;
    }

    final Document zzQH() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzX8Q() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzXpK();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzz6;
    }

    final Node zz3s() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYGb.zzYju((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZiV() {
        Node node = zzYGb.zzWgK(this.getPreviousSibling(), false);
        if (node == null && zzYGb.zzWOL(this.getParentNode())) {
            node = this.getParentNode().zzZiV();
        }
        return node;
    }

    final Node zzYbF() {
        Node node = zzYGb.zzZMM(this.getNextSibling(), false);
        if (node == null && zzYGb.zzWOL(this.getParentNode())) {
            node = this.getParentNode().zzYbF();
        }
        return node;
    }

    final CompositeNode zzZbe() {
        Node node = this;
        while ((node = node.zzZiV()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzXgj() {
        Node node = this;
        while ((node = node.zzYbF()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYNq;
    }

    final Node zzCI() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYGb.zzYju((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzBQ() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZyh() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzWoe() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYGb.zzZPY(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWS7() {
        return this.zzYNq;
    }

    final void zzWVX(Node node) {
        this.zzYNq = node;
    }

    final Node zzCE() {
        return this.zzz6;
    }

    final void zzW45(Node node) {
        this.zzz6 = node;
    }

    final Node zzXaT() {
        Node node = this;
        if (node.zzYNq != null) {
            node = this;
            return node.zzYNq;
        }
        return this.getParentNode();
    }

    final int zzXOq() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYGb.zzWQX(this);
        boolean bl2 = zzYGb.zzZXg(this);
        boolean bl3 = zzYGb.zzXW3(this);
        boolean bl4 = zzYGb.zzZKr(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXOq() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXOq() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzWPL(isCloneChildren, null);
    }

    Node zzWPL(boolean bl, zzYkS zzYkS2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzY2c != null) {
            node.zzY2c = this.getDocument().zzWYh();
        }
        node.zzYNq = null;
        node.zzz6 = null;
        if (zzYkS2 != null) {
            zzYkS2.zzVTQ(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzWYJ(StringBuilder stringBuilder) {
        zzWCy.zzD8(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzY4Y(Node node) {
        this.zzY2c = node != null ? node : this.getDocument().zzWYh();
    }

    final void zzVTQ(DocumentBase documentBase) {
        this.zzY2c = documentBase != null ? documentBase.zzWYh() : null;
    }

    final boolean zzWtj(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWpO() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzEF(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWrR(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzW3B(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZ1x(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZls zzZls2 = zzYGb.zzYPA(saveFormat);
        return zzZls2.zzyF(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZls zzZls2 = zzYGb.zzWPL(saveOptions);
        return zzZls2.zzyF(this);
    }

    final Node zzWsH(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYGb.zzof(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzUu zzZOX() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzUu.zzW11(node);
        }
        return zzUu.zzXDm(this.getParentNode());
    }

    final zzUu zzS2() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzUu.zzXDm(node);
        }
        return zzUu.zzW11(this.getParentNode());
    }

    final boolean zzVYQ(Node node) {
        return Node.zzXUR(this, node);
    }

    final boolean zzOK() {
        return this.getAncestor(1) == null;
    }

    static Node zzWam(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZhM<Node> zzZhM2 = Node.zz0I(node);
        zzZhM<Node> zzZhM3 = Node.zz0I(node2);
        return Node.zzWPL(zzZhM2, zzZhM3);
    }

    static boolean zzXUR(Node node, Node node2) {
        zzZhM<Node> zzZhM2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZhM<Node> zzZhM3 = Node.zz0I(node);
        Node node3 = Node.zzWPL(zzZhM3, zzZhM2 = Node.zz0I(node2));
        if (node3 == null) {
            return false;
        }
        zzZhM<Node> zzZhM4 = zzZhM3;
        if (zzZhM4.size() == 0 || (zzZhM4 = zzZhM2).size() == 0) {
            zzZhM4 = zzZhM2;
            boolean bl = zzZhM4.size() > 0;
            return bl;
        }
        Object e = zzZhM3.peek();
        Object e2 = zzZhM2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZhM<Node> zz0I(Node node) {
        zzZhM<Node> zzZhM2 = new zzZhM<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZhM2.push(node2);
        }
        return zzZhM2;
    }

    private static Node zzWPL(zzZhM<Node> zzZhM2, zzZhM<Node> zzZhM3) {
        Node node = null;
        while (zzZhM2.peek() == zzZhM3.peek()) {
            node = (Node)zzZhM2.pop();
            zzZhM3.pop();
            zzZhM<Node> zzZhM4 = zzZhM2;
            if (zzZhM4.size() != 0 && (zzZhM4 = zzZhM3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzY7A;
    }

    public void setCustomNodeId(int value) {
        this.zzY7A = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzXwY(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWBY(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZ31(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWBY(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWBY(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

