/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzHs;
import com.aspose.words.internal.zzYVP;

public abstract class SaveOptions {
    private boolean zzWcy;
    private boolean zzXPi = true;
    private boolean zzYZj = false;
    private boolean zzWI5 = true;
    private boolean zzZRx;
    private String zzZeK;
    private boolean zzZks;
    private boolean zzXFu = false;
    private boolean zzYKK = true;
    private int zzZxG = 1;
    private int zzYJr = 1;
    private int zzXN6 = 0;
    private String zzX3P = "";
    private boolean zzZFv = true;
    private boolean zzZIo = true;
    private boolean zzRg;
    private boolean zzXTE;
    private int zzX1b = 0;
    private boolean zzW0A = true;
    private boolean zzWXc = false;
    private boolean zz9f = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzo6() {
        return false;
    }

    boolean zzX25() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWI5;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWI5 = value;
    }

    public String getTempFolder() {
        return this.zzZeK;
    }

    public void setTempFolder(String value) {
        this.zzZeK = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZRx;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZRx = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZks;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZks = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXFu;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXFu = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYKK;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYKK = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZxG;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZxG = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXN6;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXN6 = value;
    }

    public int getImlRenderingMode() {
        return this.zzYJr;
    }

    public void setImlRenderingMode(int value) {
        this.zzYJr = value;
    }

    public String getDefaultTemplate() {
        return this.zzX3P;
    }

    public void setDefaultTemplate(String value) {
        this.zzX3P = value;
    }

    public boolean getUpdateFields() {
        return this.zzZFv;
    }

    public void setUpdateFields(boolean value) {
        this.zzZFv = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzRg;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzRg = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzXTE;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzXTE = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzWXc;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzWXc = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYZj;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYZj = value;
    }

    final boolean zzZax() {
        return this.zzZIo;
    }

    final boolean zzWut() {
        return this.zzW0A;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWSl(zzHs.zz5J(zzYVP.zzZ1K(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzX1b;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzX1b = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWcy;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWcy = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zz9f;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zz9f = value;
    }

    final boolean zzJJ() {
        return this.zzXPi;
    }
}

