/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.zzYSk;
import com.aspose.words.zzYkS;
import com.aspose.words.zzZfN;

public final class Section
extends CompositeNode<Node>
implements zzZfN {
    private zzYSk zzYA9;
    private PageSetup zzWbw;
    private HeaderFooterCollection zzZ6r;

    public Section(DocumentBase doc) {
        this(doc, new zzYSk());
    }

    Section(DocumentBase doc, zzYSk sectPr) {
        super(doc);
        this.zzYA9 = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZ6r == null) {
            this.zzZ6r = new HeaderFooterCollection(this);
        }
        return this.zzZ6r;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWbw == null) {
            Section section = this;
            this.zzWbw = new PageSetup(section, section.getDocument().zzYpL(), this.getDocument().getStyles(), new zzWPL(this));
        }
        return this.zzWbw;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzWHh();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzwv(!value);
    }

    final zzYSk zzXBy() {
        return this.zzYA9;
    }

    final void zzZa5(zzYSk zzYSk2) {
        this.zzYA9 = zzYSk2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWPL(boolean bl, zzYkS zzYkS2) {
        zzYSk zzYSk2;
        Section section = (Section)super.zzWPL(bl, zzYkS2);
        zzYSk zzYSk3 = this.zzYA9;
        section.zzYA9 = zzYSk2 = (zzYSk)zzYSk3.zzVT0();
        section.zzWbw = null;
        section.zzZ6r = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWPL(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzD8(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzVTQ(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzVTQ(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWcX(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWgK(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWcX(n) == null;
            }
        }
        return false;
    }

    final void zzZa5(Shape shape, boolean bl) {
        this.zzWPL(shape, 4, bl);
        this.zzWPL(shape, 0, bl);
        this.zzWPL(shape, 1, bl);
    }

    private void zzWPL(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzXaQ() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzY6L()) {
                if (!shape.zzYHj()) continue;
                shape.remove();
            }
        }
    }

    private void zzVTQ(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzD8(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYA9.zzX1u(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYpL().zzZwl.zzWng(key);
        }
        return zzYSk.zzYaq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYA9.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYpL().zzZwl.zzVR1(key, value);
            return;
        }
        this.zzYA9.zzVR1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYA9.clear();
    }

    final boolean zzYTy() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZxr() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzWPL
    implements zzZfN {
        private Section zzXt2;

        zzWPL(Section section) {
            this.zzXt2 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzk5().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzk5().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzk5().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZfN zzk5() {
            Document document = zzWCy.zzWPL((Object)this.zzXt2.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXt2;
        }
    }
}

