/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzMq;
import com.aspose.words.internal.zzW2r;
import com.aspose.words.internal.zzWCy;
import com.aspose.words.internal.zzX2b;
import com.aspose.words.internal.zzXXi;
import com.aspose.words.internal.zzY0D;
import com.aspose.words.internal.zzZL8;
import com.aspose.words.zzZ5H;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzXBD;
    private zzZ5H zzXVZ;

    Watermark(Document doc, zzZ5H watermarkProvider) {
        this.zzXBD = doc;
        this.zzXVZ = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZpl(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWPL(text, textWatermarkOptions, this.zzXBD);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWCy.zzD8((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzXBD, 75);
        shape.getImageData().setImage(image);
        this.zzWPL(shape, options, this.zzXBD);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWCy.zzD8((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzXBD, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWPL(shape, options, this.zzXBD);
    }

    public final int getType() {
        Shape shape = this.zzXVZ.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYHj();
        if (shape.zzZz1()) {
            return 0;
        }
        if (shape.zzZZ0()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzXVZ.add(shape);
    }

    public final void remove() {
        this.zzXVZ.remove();
    }

    private static void zzZpl(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzXXi.zzZc5(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWCy.zzWPL(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWPL(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzD8(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzFe(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzD8(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZ3G() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYLM()) / d2) > (double)(f = pageSetup.zzWJd())) {
            d = (double)f / d3;
        }
        shape.zzcE(zzZL8.zzZa5(d2 * d, 2, zzY0D.zzYzv));
        shape.zzZ8N(zzZL8.zzZa5(d3 * d, 2, zzY0D.zzYzv));
    }

    private Shape zzWPL(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWPL(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzFe(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWPL(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzWUb() ? 1.0f : textWatermarkOptions.getFontSize();
        zzX2b zzX2b2 = document.zzZMf().zzZa5(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzX2b2.zzXYH(shape.getTextPath().getText());
        if (textWatermarkOptions.zzWUb()) {
            l = Watermark.zzWPL(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzcE(zzZL8.zzZa5(Float.intBitsToFloat(n), 2, zzY0D.zzYzv));
        shape.zzZ8N(zzZL8.zzZa5(zzMq.zzXNC(l), 2, zzY0D.zzYzv));
    }

    private static long zzWPL(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYLM();
        float f2 = pageSetup.zzWJd();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzMq.zzXNC(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzMq.zzZFp(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzMq.zzXNC(l) >= Float.intBitsToFloat(n)) {
            return zzMq.zzZFp(f2 / f3, f2);
        }
        float f6 = f;
        return zzMq.zzZFp(f6, f6 * f3);
    }

    private static void zzFe(Shape shape, String string) {
        shape.setName(zzW2r.zzD8("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

