/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW2L;
import com.aspose.words.internal.zzWSN;
import com.aspose.words.internal.zzXB2;
import com.aspose.words.internal.zzXBc;
import com.aspose.words.internal.zzY5J;
import com.aspose.words.internal.zzYJz;
import com.aspose.words.internal.zzYo2;
import com.aspose.words.internal.zzZHN;
import com.aspose.words.internal.zzZyh;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYV
extends CertPathBuilderSpi {
    private final zzWSN zzWzN;
    private zzXBc zzZEc;

    zzYV(zzWSN zzWSN2) {
        this.zzWzN = zzWSN2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZHN pkixParams;
        if (params instanceof zzZHN) {
            pkixParams = (zzZHN)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZHN.zzWPL((PKIXBuilderParameters)params).zz7p();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZHN.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZyh zzZyh2 = pkixParams.zzZAL().zzYq8();
        try {
            collection = zzYJz.zzWPL(zzZyh2, pkixParams.zzZAL().zzY9M());
            collection.addAll(zzYJz.zzWPL(zzZyh2, pkixParams.zzZAL().zza7()));
        }
        catch (zzXBc zzXBc2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXBc2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzWPL(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzZEc != null) {
            throw new CertPathBuilderException(this.zzZEc.getMessage(), this.zzZEc.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzWPL(X509Certificate x509Certificate, zzZHN zzZHN2, List list) throws CertPathBuilderException {
        zzXB2 zzXB22;
        zzYo2 zzYo22;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZHN2.zzWWS().contains(x509Certificate)) {
            return null;
        }
        if (zzZHN2.zzY8Q() != -1 && list.size() - 1 > zzZHN2.zzY8Q()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzYo22 = new zzYo2(this.zzWzN);
            zzXB22 = new zzXB2(this.zzWzN);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzYJz.zzWPL(x509Certificate, zzZHN2.zzZAL().zzZnD(), zzZHN2.zzZAL().zzXjO()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzYo22.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXBc("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXB22.engineValidate(certPath, zzZHN2);
                }
                catch (Exception exception) {
                    throw new zzXBc("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzW2L> arrayList = new ArrayList<zzW2L>();
            arrayList.addAll(zzZHN2.zzZAL().zzY9M());
            try {
                arrayList.addAll(zzYJz.zzWPL(x509Certificate.getExtensionValue(zzY5J.zzIO.getId()), zzZHN2.zzZAL().zzmP()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXBc("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzYJz.zzWPL(x509Certificate, zzZHN2.zzZAL().zza7(), arrayList));
            }
            catch (zzXBc zzXBc2) {
                throw new zzXBc("Cannot find issuer certificate for certificate in certification path.", zzXBc2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXBc("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzWPL(x509Certificate2, zzZHN2, list);
            }
        }
        catch (zzXBc zzXBc3) {
            this.zzZEc = zzXBc3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

