/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW2r;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZfE = new ArrayList();
    private final Map<String, DataColumn> zzWiB = new HashMap<String, DataColumn>();
    private DataTable zzYwd;

    DataColumnCollection(DataTable table) {
        this.zzYwd = table;
    }

    public void add(DataColumn column) {
        if (zzW2r.zzYyC(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYqh(column.getColumnName());
        if (this.zzWiB.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzVTQ(this.zzYwd);
        column.setOrdinal(this.zzZfE.size());
        this.zzZfE.add(column);
        this.zzWiB.put(string, column);
        this.zzYwd.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYwd);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYwd);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzW2r.zzYyC(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYqh(columnName);
        DataColumn dataColumn = this.zzWiB.get(string);
        if (dataColumn != null) {
            int n = this.zzZfE.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZfE.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZfE.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZfE.remove(n);
            this.zzWiB.remove(DataColumnCollection.zzYqh(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYwd.getRows()) {
                dataRow.remove(n);
            }
            this.zzYwd.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZfE.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZfE.iterator();
    }

    public void clear() {
        this.zzWiB.clear();
        this.zzZfE.clear();
    }

    final DataColumn[] zzQw() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZfE);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWPL(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZfE.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZfE.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYqh(string);
            String string3 = DataColumnCollection.zzYqh(dataColumn.getColumnName());
            this.zzWiB.remove(string3);
            this.zzWiB.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYqh(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

