/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW2r;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zznj;

public class DataRelation {
    private DataKey zzZiy;
    private DataKey zzX5p;
    private String zzZIm;
    private String[] zzYZw;
    private String[] zzL3;
    private DataColumn[] zzX4v;
    private DataColumn[] zzYsb;
    private UniqueConstraint zzZjt;
    private ForeignKeyConstraint zzVU9;
    private boolean zz1W = true;
    private DataSet zzIv;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        DataColumn[] dataColumnArray = DataRelation.zzD8(parentTable, parentColumnNames);
        DataColumn[] dataColumnArray2 = DataRelation.zzD8(childTable, childColumnNames);
        this.zzWPL(relationName, dataColumnArray, dataColumnArray2, true);
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        this.zzWPL(relationName, parentColumns, childColumns, createConstraints);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    private static DataColumn[] zzD8(DataTable dataTable, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column names need to have at least one column name.");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        DataColumn[] dataColumnArray = new DataColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DataColumn dataColumn = dataTable.getColumns().get(stringArray[i]);
            if (dataColumn == null) {
                throw new IllegalArgumentException(zzW2r.zzD8("The given column {0} does not exist in {1}", stringArray[i], dataTable.getTableName()));
            }
            dataColumnArray[i] = dataColumn;
        }
        return dataColumnArray;
    }

    private void zzWPL(String string, DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, boolean bl) {
        int n;
        DataColumn dataColumn;
        int n2;
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        if (dataColumnArray2 == null) {
            throw new IllegalArgumentException("childColumns");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Key Length mismatch");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            if (dataColumnArray[i].getTable().getDataSet() != null && dataColumnArray2[i].getTable().getDataSet() != null) continue;
            throw new IllegalArgumentException("Parent or Child columns do not have DataSet");
        }
        DataColumn[] dataColumnArray3 = dataColumnArray;
        int n3 = dataColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray3 = dataColumnArray2;
        n3 = dataColumnArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < dataColumnArray2.length; ++n) {
            if (dataColumnArray[n].zzD8(dataColumnArray2[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzX4v = dataColumnArray;
        this.zzYsb = dataColumnArray2;
        this.zzZIm = string == null ? "" : string;
        this.zz1W = bl;
        this.zzX5p = new DataKey(dataColumnArray, true);
        this.zzZiy = new DataKey(dataColumnArray2, true);
        this.zzIv = dataTable.getDataSet();
        this.zzYZw = new String[this.zzX4v.length];
        for (n = 0; n < this.zzX4v.length; ++n) {
            this.zzYZw[n] = this.zzX4v[n].getColumnName();
        }
        this.zzL3 = new String[this.zzYsb.length];
        for (n = 0; n < this.zzYsb.length; ++n) {
            this.zzL3[n] = this.zzYsb[n].getColumnName();
        }
    }

    public String getRelationName() {
        return this.zzZIm;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        return this.getParentKey().getTable();
    }

    public DataTable getChildTable() {
        return this.getChildKey().getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzYZw;
    }

    public String[] getChildColumnNames() {
        return this.zzL3;
    }

    public DataColumn[] getParentColumns() {
        return this.zzX4v;
    }

    public DataColumn[] getChildColumns() {
        return this.zzYsb;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzZjt;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzZjt = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzVU9;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzVU9 = childKeyConstraint;
    }

    public DataKey getChildKey() {
        return this.zzZiy;
    }

    public DataKey getParentKey() {
        return this.zzX5p;
    }

    public DataSet getDataSet() {
        return this.zzIv;
    }

    public int hashCode() {
        int n = 31 + this.zzZIm.hashCode();
        n = n * 31 + ((String)null).hashCode();
        n = n * 31 + ((String)null).hashCode();
        for (int i = 0; i < this.zzYZw.length; ++i) {
            n = n * 31 + this.zzYZw[i].hashCode();
            n = n * 31 + this.zzL3[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    static DataRow[] zzWPL(DataKey dataKey, DataKey dataKey2, DataRow dataRow) {
        Object[] objectArray = dataRow.getKeyValues(dataKey2);
        if (DataRelation.zzVOs(objectArray)) {
            return new DataRow[0];
        }
        zznj zznj2 = dataKey.getSortIndex();
        return zznj2.zzXWe(objectArray);
    }

    private static boolean zzVOs(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (DataRelation.zzZRe(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean zzZRe(Object object) {
        return object == null || DBNull.Value == object;
    }

    final void zzZSq() throws InvalidConstraintException, DataException {
        if (!this.zz1W) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zzZa5(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zzD8(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzD8(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzWPL(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzZa5(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzWPL(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzWPL(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzWPL(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

